/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoTributo;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoManualDTO;
import br.com.elotech.tributos.dto.DebitoManualIssDTO;
import br.com.elotech.tributos.dto.DebitoManualParcelaDTO;
import br.com.elotech.tributos.dto.GerarParcelasDebitoDTO;
import br.com.elotech.tributos.params.NextSubdividaValueParams;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.DebitoParcelaTributoService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.DividaService;
import br.com.elotech.tributos.service.FormaCorrecaoService;
import br.com.elotech.tributos.service.PermissoesDividaService;
import br.com.elotech.tributos.service.SituacaoParcelaService;
import br.com.elotech.tributos.service.exception.GeracaoDebitoManualException;
import br.com.elotech.tributos.util.CalculoUtils;
import br.com.elotech.tributos.util.CalculoValoresConstants;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GeraDebitoService {
    private final CadastroGeralService cadastroGeralService;
    private final ContextService contextService;
    private final DividaService dividaService;
    private final FormaCorrecaoService formaCorrecaoService;
    private final DebitoService debitoService;
    private final SituacaoParcelaService situacaoParcelaService;
    private final DebitoParcelaService debitoParcelaService;
    private final DebitoParcelaTributoService debitoParcelaTributoService;
    private final PermissoesDividaService permissoesDividaService;

    public GeraDebitoService(CadastroGeralService cadastroGeralService, ContextService contextService, DividaService dividaService, FormaCorrecaoService formaCorrecaoService, DebitoService debitoService, SituacaoParcelaService situacaoParcelaService, DebitoParcelaService debitoParcelaService, DebitoParcelaTributoService debitoParcelaTributoService, PermissoesDividaService permissoesDividaService) {
        this.cadastroGeralService = cadastroGeralService;
        this.contextService = contextService;
        this.dividaService = dividaService;
        this.formaCorrecaoService = formaCorrecaoService;
        this.debitoService = debitoService;
        this.situacaoParcelaService = situacaoParcelaService;
        this.debitoParcelaService = debitoParcelaService;
        this.debitoParcelaTributoService = debitoParcelaTributoService;
        this.permissoesDividaService = permissoesDividaService;
    }

    @Transactional
    public DebitoIdDTO geraDebitoManual(DebitoManualDTO debitoManualDTO) {
        Long entidadePrincipal = this.contextService.getEntidadePrincipal();
        Long exercicioAtual = this.contextService.getExercicioAtual();
        Debito debito = debitoManualDTO.toEntity(entidadePrincipal, SecurityUtils.getUserAise());
        if (Objects.isNull(debito.getSubDivida())) {
            debito.setSubDivida(this.getNextSubdivida(NextSubdividaValueParams.of((DebitoManualDTO)debitoManualDTO)));
        }
        debito.setDataPrimeiraParcela();
        debito.setDataInclusao(LocalDate.now());
        debito.setChildrenId();
        debito.setNumeroParcela(Long.valueOf(debitoManualDTO.getParcelas().size()));
        debito.setUsuario(SecurityUtils.getUserAise());
        if (Objects.isNull(debitoManualDTO.getFormaCorrecao())) {
            debito.setFormaCorrecao(this.formaCorrecaoService.getFormaCorrecaoPadrao(debitoManualDTO.getDivida(), entidadePrincipal, debitoManualDTO.getExercicio()));
        } else {
            debito.setFormaCorrecao((FormaCorrecao)this.formaCorrecaoService.findById((Serializable)debitoManualDTO.getFormaCorrecao()).orElseThrow(() -> GeracaoDebitoManualException.formaCorrecaoNotFound((Long)debitoManualDTO.getFormaCorrecao())));
        }
        Divida divida = (Divida)this.dividaService.findByEntidadeAndExercicioAndDivida(debito.getEntidade(), exercicioAtual, debito.getGuiaRecolhimento()).orElseThrow(() -> GeracaoDebitoManualException.dividaNotFound((Long)debito.getEntidade(), (Long)exercicioAtual, (Long)debito.getGuiaRecolhimento()));
        debito.setConstituido(divida.isConstituido());
        debito.generateDebitoParcelaTributo(divida.getPermiteLancarValorZero());
        debito.getParcelas().forEach(debitoParcela -> debitoParcela.setSituacaoDebito(this.situacaoParcelaService.getSituacaoParcelaNovoDebito(debitoParcela.getSituacaoDebito(), debitoParcela.getValorTotal())));
        this.validaDebitoManual(debito, divida);
        Debito savedDebito = this.debitoService.save(debito);
        return DebitoIdDTO.of((Long)savedDebito.getId(), (Long)savedDebito.getEntidade(), (Long)savedDebito.getExercicio(), (Long)savedDebito.getTipoCadastro(), (Long)savedDebito.getCadastroGeralId(), (Long)divida.getDivida(), (Long)savedDebito.getSubDivida());
    }

    @Transactional
    public List<Debito> geraDebitoManualIss(DebitoManualIssDTO debitoManualIssDTO) {
        Long entidade = this.contextService.getEntidadePrincipal();
        if (Boolean.FALSE.equals(debitoManualIssDTO.getTipoCadastro().permiteEmissaoDebitoISS())) {
            throw GeracaoDebitoManualException.tipoCadastroInvalido((TipoCadastro)debitoManualIssDTO.getTipoCadastro());
        }
        Divida divida = (Divida)this.dividaService.findByEntidadeAndExercicioAndDivida(entidade, debitoManualIssDTO.getExercicio(), debitoManualIssDTO.getDivida()).orElseThrow(() -> GeracaoDebitoManualException.dividaNotFound((Long)entidade, (Long)debitoManualIssDTO.getExercicio(), (Long)debitoManualIssDTO.getDivida()));
        FormaCorrecao formaCorrecao = Objects.isNull(debitoManualIssDTO.getFormaCorrecao()) ? this.formaCorrecaoService.getFormaCorrecaoPadrao(debitoManualIssDTO.getDivida(), this.contextService.getEntidadePrincipal(), debitoManualIssDTO.getExercicio()) : (FormaCorrecao)this.formaCorrecaoService.findById((Serializable)debitoManualIssDTO.getFormaCorrecao()).orElseThrow(() -> GeracaoDebitoManualException.formaCorrecaoNotFound((Long)debitoManualIssDTO.getFormaCorrecao()));
        Optional cadastroGeral = this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(TipoCadastro.fromValue((Long)debitoManualIssDTO.getTipoCadastro().getValue()), debitoManualIssDTO.getCadastroGeral());
        if (!cadastroGeral.isPresent()) {
            throw GeracaoDebitoManualException.cadastroNotFound((Long)debitoManualIssDTO.getTipoCadastro().getValue(), (Long)debitoManualIssDTO.getCadastroGeral());
        }
        List debitosGerados = debitoManualIssDTO.toEntity(entidade, SecurityUtils.getUserAise());
        return debitosGerados.stream().map(debitoGerado -> {
            Optional match = this.debitoService.findByCompositeKey(entidade, debitoGerado.getExercicio(), debitoGerado.getTipoCadastro(), debitoGerado.getCadastroGeralId(), debitoManualIssDTO.getDivida(), debitoGerado.getSubDivida());
            return match.map(debito -> this.addParcelaDebitoISS(debito, debitoManualIssDTO, (DebitoParcela)debitoGerado.getParcelas().get(0))).orElseGet(() -> this.setAttributesDebitoISS(debitoGerado, formaCorrecao, divida));
        }).map(arg_0 -> ((DebitoService)this.debitoService).save(arg_0)).collect(Collectors.toList());
    }

    private Debito addParcelaDebitoISS(Debito debito, DebitoManualIssDTO debitoManualIssDTO, DebitoParcela debitoParcela) {
        Long subDividaIssHomologado = 100L;
        String tributoId = debitoManualIssDTO.getTributo().getId().getTributo();
        DebitoTributo tributo = (DebitoTributo)debito.getDebitoTributoByTributo(tributoId).orElseThrow(() -> GeracaoDebitoManualException.tributoNaoExisteNoDebito((String)tributoId, (Debito)debito));
        DebitoManualParcelaDTO parcelaDTO = Boolean.TRUE.equals(debitoManualIssDTO.getBaixaAutomatica()) ? (DebitoManualParcelaDTO)debitoManualIssDTO.getParcelas().get(0) : (DebitoManualParcelaDTO)debitoManualIssDTO.getParcelaByNumeroParcela(Long.valueOf(debito.getSubDivida() - subDividaIssHomologado)).orElseThrow(() -> GeracaoDebitoManualException.parcelaNotFound((Long)(debito.getSubDivida() - subDividaIssHomologado)));
        tributo.setValorBaseCalculo(tributo.getValorBaseCalculo().add(parcelaDTO.getValorBaseCalculo()));
        tributo.setValorTributo(tributo.getValorTributo().add(parcelaDTO.getValor()));
        debitoParcela.setDebitoAndUpdateIdParcela(debito);
        debitoParcela.setSituacaoDebito(this.situacaoParcelaService.getSituacaoParcelaNovoDebito(debitoParcela.getSituacaoDebito(), debitoParcela.getValorTotal()));
        this.debitoParcelaService.save((EloEntity)debitoParcela, null);
        this.debitoParcelaTributoService.saveAll(debitoParcela.getTributos());
        debito.getParcelas().add(debitoParcela);
        debito.setNumeroParcela(Long.valueOf(debito.getNumeroParcela() + 1L));
        debito.validaGeracaoDebitoManual(debito.getDivida());
        if (Objects.nonNull(debitoManualIssDTO.getObservacoes())) {
            debitoManualIssDTO.getObservacoes().stream().map(observacao -> observacao.toEntity(SecurityUtils.getUserAise())).forEach(debito.getObservacoes()::add);
            debito.setObservacoesId();
        }
        return debito;
    }

    private Debito setAttributesDebitoISS(Debito debito, FormaCorrecao formaCorrecao, Divida divida) {
        debito.setUsuario(SecurityUtils.getUserAise());
        debito.setFormaCorrecao(formaCorrecao);
        debito.setConstituido(divida.isConstituido());
        debito.setDivida(divida);
        debito.getParcelas().forEach(debitoParcela -> debitoParcela.setSituacaoDebito(this.situacaoParcelaService.getSituacaoParcelaNovoDebito(debitoParcela.getSituacaoDebito(), debitoParcela.getValorTotal())));
        debito.setChildrenId();
        debito.validaGeracaoDebitoManual(divida);
        return debito;
    }

    private void validaDebitoManual(Debito debito, Divida divida) {
        Optional cadastroGeral = this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(TipoCadastro.fromValue((Long)debito.getTipoCadastro()), debito.getCadastroGeralId());
        if (!cadastroGeral.isPresent()) {
            throw GeracaoDebitoManualException.cadastroNotFound((Long)debito.getTipoCadastro(), (Long)debito.getCadastroGeralId());
        }
        this.permissoesDividaService.validaPermissaoDividaByUsuario(divida.getEntidade(), divida.getExercicio(), divida.getDivida());
        debito.validaGeracaoDebitoManual(divida);
    }

    public List<DebitoManualParcelaDTO> gerarParcelas(GerarParcelasDebitoDTO gerarParcelasDebitoDTO) {
        ArrayList<DebitoManualParcelaDTO> parcelas = new ArrayList<DebitoManualParcelaDTO>();
        BigDecimal valorTributo = gerarParcelasDebitoDTO.getTributos().stream().map(tributo -> tributo.getValorTributo().subtract(tributo.getValorRenuncia())).reduce(BigDecimal.ZERO, BigDecimal::add);
        int indice = 0;
        while ((long)indice < gerarParcelasDebitoDTO.getQuantidadeParcelas()) {
            DebitoManualParcelaDTO parcela = new DebitoManualParcelaDTO();
            parcela.setSituacao(Long.valueOf(1L));
            BigDecimal valorParcela = indice == 0 ? CalculoUtils.divideESomaValorDiferenca((BigDecimal)valorTributo, (Integer)gerarParcelasDebitoDTO.getQuantidadeParcelas().intValue(), (Integer)CalculoValoresConstants.QUANTIDADE_CASAS_DECIMAIS) : CalculoUtils.divideETruncaValor((BigDecimal)valorTributo, (Integer)gerarParcelasDebitoDTO.getQuantidadeParcelas().intValue(), (Integer)CalculoValoresConstants.QUANTIDADE_CASAS_DECIMAIS);
            parcela.setValor(valorParcela);
            parcela.setParcela(Long.valueOf(gerarParcelasDebitoDTO.getParcelaInicial() + (long)indice));
            parcela.setDataVencimento(gerarParcelasDebitoDTO.getDataVencimentoInicial().plusMonths(indice));
            parcelas.add(parcela);
            ++indice;
        }
        return parcelas;
    }

    private Long getNextSubdivida(NextSubdividaValueParams nextSubdividaValueParams) {
        return this.debitoService.getNextValueSubdivida(nextSubdividaValueParams);
    }
}

