/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.DividaFormaPagamentoTributo;
import br.com.elotech.tributos.repository.DividaFormaPagamentoTributoRepository;
import br.com.elotech.tributos.repository.DividaRepository;
import br.com.elotech.tributos.service.ContextService;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class DividaService
extends CrudService<Divida, Long> {
    private final DividaRepository dividaRepository;
    private final DividaFormaPagamentoTributoRepository dividaFormaPagamentoTributoRepository;
    private final ContextService contextService;

    public DividaService(DividaRepository dividaRepository, DividaFormaPagamentoTributoRepository dividaFormaPagamentoTributoRepository, ContextService contextService) {
        this.dividaRepository = dividaRepository;
        this.dividaFormaPagamentoTributoRepository = dividaFormaPagamentoTributoRepository;
        this.contextService = contextService;
    }

    public Optional<Divida> findByEntidadeAndExercicioAndDivida(Long entidade, Long exercicio, Long divida) {
        return this.dividaRepository.findByEntidadeAndExercicioAndDivida(entidade, exercicio, divida);
    }

    public Divida save(Divida entity, Authentication authentication) {
        entity.setRelationsKeys();
        List tributosInseridos = entity.adicionaDividaFormaPagamentoTributoByDividaTributo();
        List tributosRemovidos = this.atualizaTributosRemovidos(entity);
        List tributosSalvos = entity.getAllDividaFormaPagamentoTributo(tributosRemovidos);
        entity.clearDividaFormaPagamentoTributos();
        super.save((EloEntity)entity, authentication);
        tributosInseridos.addAll(tributosSalvos);
        this.dividaFormaPagamentoTributoRepository.saveAll((Iterable)tributosInseridos);
        return entity;
    }

    protected void beforeDelete(Divida divida, Authentication authentication) {
        super.beforeDelete((EloEntity)divida, authentication);
        this.dividaFormaPagamentoTributoRepository.deleteAll((Iterable)divida.getAllDividaFormaPagamentoTributo(null));
    }

    private List<DividaFormaPagamentoTributo> atualizaTributosRemovidos(Divida divida) {
        List dividas = divida.getAllDividaFormaPagamentoTributoRemovido();
        if (!dividas.isEmpty()) {
            this.dividaFormaPagamentoTributoRepository.deleteAll((Iterable)dividas);
        }
        return dividas;
    }

    public Page<Divida> findDividaByExercicioAtualAndRsql(String search, Pageable pageable) {
        search = String.format("exercicio==%d %s", this.contextService.getExercicioAtual(), search.isEmpty() ? "" : "and " + search);
        return this.findByRsql(search, pageable);
    }
}

