/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.common.dto.EntidadeInfo;
import br.com.elotech.core.common.service.EntidadeService;
import br.com.elotech.tributos.domain.TipoFormaPagamento;
import br.com.elotech.tributos.dto.DebitoAgrupadoPorFormaPagamentoDTO;
import br.com.elotech.tributos.dto.DebitoParcelaTributoCotaUnicaDTO;
import br.com.elotech.tributos.repository.DebitoCotaUnicaRepository;
import br.com.elotech.tributos.service.ExercicioService;
import br.com.elotech.tributos.util.AgrupaDebitos;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class DebitoCotaUnicaService {
    private final DebitoCotaUnicaRepository debitoCotaUnicaRepository;
    private final ExercicioService exercicioService;
    private final EntidadeService entidadeService;

    public DebitoCotaUnicaService(DebitoCotaUnicaRepository debitoCotaUnicaRepository, ExercicioService exercicioService, EntidadeService entidadeService) {
        this.debitoCotaUnicaRepository = debitoCotaUnicaRepository;
        this.exercicioService = exercicioService;
        this.entidadeService = entidadeService;
    }

    public List<DebitoAgrupadoPorFormaPagamentoDTO> findAllDebitoAgrupadoPorFormaPagamentoDisponivelWeb(Long tipoCadastro, Long cadastroGeral) {
        return AgrupaDebitos.agrupaDebitosPorDebitoEFormaPagamento((List)this.getDebitoParcelaReceita(tipoCadastro, cadastroGeral));
    }

    public List<DebitoAgrupadoPorFormaPagamentoDTO> findAllDebitoFirstCotaUnicaDisponivelWeb(Long tipoCadastro, Long cadastroGeral) {
        List debitosParcelaReceitaCotaUnicaDTO = this.getDebitoParcelaReceita(tipoCadastro, cadastroGeral).stream().filter(parcelaReceita -> TipoFormaPagamento.COTA_UNICA.getValue().equals(parcelaReceita.getTipoFormaPagamento())).collect(Collectors.toList());
        Comparator<DebitoParcelaTributoCotaUnicaDTO> vencimentoComparator = Comparator.comparing(DebitoParcelaTributoCotaUnicaDTO::getVencimento);
        LocalDate menorVencimentoCotaUnica = debitosParcelaReceitaCotaUnicaDTO.stream().min(vencimentoComparator).map(DebitoParcelaTributoCotaUnicaDTO::getVencimento).orElse(null);
        return AgrupaDebitos.agrupaDebitosPorDebitoEFormaPagamento(debitosParcelaReceitaCotaUnicaDTO.stream().filter(parcelaReceita -> parcelaReceita.getVencimento().equals(menorVencimentoCotaUnica)).collect(Collectors.toList()));
    }

    private List<DebitoParcelaTributoCotaUnicaDTO> getDebitoParcelaReceita(Long tipoCadastro, Long cadastroGeral) {
        Long exercicio = this.exercicioService.getExercicio();
        EntidadeInfo entidade = this.entidadeService.findEntidadePrincipal();
        return this.debitoCotaUnicaRepository.findAllDebitoParcelaReceitaDisponivelWeb(entidade.getId(), exercicio, tipoCadastro, cadastroGeral, LocalDate.now());
    }
}

