/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.ParametroEntidadeEnum;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioProfundidade;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSegmento;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioTestada;
import br.com.elotech.tributos.domain.relatorio.RelatorioSistema;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.SubReportDTO;
import br.com.elotech.tributos.dto.SubReportItemDTO;
import br.com.elotech.tributos.report.loader.EspelhoImobiliarioParamLoader;
import br.com.elotech.tributos.repository.imobiliario.CadastroImobiliarioRepository;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.CadastroImobiliarioSituacaoService;
import br.com.elotech.tributos.service.ParametroEntidadeService;
import br.com.elotech.tributos.service.ParametroGeralService;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class CadastroImobiliarioService
extends CrudService<CadastroImobiliario, Long> {
    private static final int DUAS_CASAS_DECIMAIS = 2;
    private static final int QUATRO_CASAS_DECIMAIS = 4;
    private final ParametroEntidadeService parametroEntidadeService;
    private final ParametroGeralService parametroGeralService;
    private final CadastroGeralService cadastroGeralService;
    private final CadastroImobiliarioSituacaoService imobiliarioSituacaoService;
    private final CadastroImobiliarioRepository cadastroImobiliarioRepository;
    private final EspelhoImobiliarioParamLoader espelhoImobiliarioParamLoader;

    public CadastroImobiliarioService(CadastroGeralService cadastroGeralService, CadastroImobiliarioSituacaoService imobiliarioSituacaoService, ParametroEntidadeService parametroEntidadeService, ParametroGeralService parametroGeralService, CadastroImobiliarioRepository cadastroImobiliarioRepository, EspelhoImobiliarioParamLoader espelhoImobiliarioParamLoader) {
        this.cadastroGeralService = cadastroGeralService;
        this.imobiliarioSituacaoService = imobiliarioSituacaoService;
        this.parametroEntidadeService = parametroEntidadeService;
        this.parametroGeralService = parametroGeralService;
        this.cadastroImobiliarioRepository = cadastroImobiliarioRepository;
        this.espelhoImobiliarioParamLoader = espelhoImobiliarioParamLoader;
    }

    protected void beforeSave(CadastroImobiliario cadastroImobiliario, Authentication authentication) {
        this.cadastroGeralService.validaCadastroGeralExclusaoLogica((CadastroGeral)cadastroImobiliario);
        this.setEnderecoLocalizacao(cadastroImobiliario);
        this.setProfundidadeMedia(cadastroImobiliario);
        this.setAreaUnidadeConstruida(cadastroImobiliario);
        this.setAreaTotalConstruida(cadastroImobiliario);
        this.setArredondamentoArea(cadastroImobiliario);
        if (Objects.nonNull(cadastroImobiliario.getSituacaoImobiliario())) {
            this.imobiliarioSituacaoService.setAtualSituacao(cadastroImobiliario);
        }
        super.beforeSave((EloEntity)cadastroImobiliario, authentication);
    }

    private void setEnderecoLocalizacao(CadastroImobiliario cadastroImobiliario) {
        List testadas = cadastroImobiliario.getCadastroImobiliarioTestadas();
        for (CadastroImobiliarioTestada testada : testadas) {
            if (!testada.getPrincipal().booleanValue()) continue;
            cadastroImobiliario.setCidade(testada.getLogradouroTestada().getLogradouro().getCidade());
            cadastroImobiliario.setLogradouro(testada.getLogradouroTestada().getLogradouro());
            cadastroImobiliario.setNumero(testada.getNumero());
        }
    }

    private void setProfundidadeMedia(CadastroImobiliario cadastroImobiliario) {
        List profundidades = cadastroImobiliario.getCadastroImobiliarioProfundidades();
        BigDecimal soma = profundidades.stream().map(CadastroImobiliarioProfundidade::getProfundidade).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (soma.compareTo(BigDecimal.ZERO) > 0) {
            cadastroImobiliario.setProfundidadeMedia(soma.divide(new BigDecimal(profundidades.size()), 4, RoundingMode.HALF_UP));
        }
    }

    private void setAreaUnidadeConstruida(CadastroImobiliario cadastroImobiliario) {
        BigDecimal soma = BigDecimal.ZERO;
        List segmentos = cadastroImobiliario.getCadastroImobiliarioSegmentos();
        if (!segmentos.isEmpty()) {
            soma = this.utilizaSituacaoSegmento() != false ? segmentos.stream().filter(segmento -> Objects.nonNull(segmento.getSituacaoSegmento()) && segmento.getSituacaoSegmento().getLancaImposto() != false).map(CadastroImobiliarioSegmento::getAreaConstruida).reduce(BigDecimal.ZERO, BigDecimal::add) : segmentos.stream().map(CadastroImobiliarioSegmento::getAreaConstruida).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        cadastroImobiliario.setAreaUnidadeConstruida(soma);
    }

    private void setAreaTotalConstruida(CadastroImobiliario cadastroImobiliario) {
        cadastroImobiliario.setAreaTotalConstruida(cadastroImobiliario.getAreaUnidadeConstruida());
    }

    private void setArredondamentoArea(CadastroImobiliario cadastroImobiliario) {
        int casasDecimais = this.parametroCasasDecimaisImobiliario().intValue();
        if (casasDecimais < 2 && casasDecimais > 4) {
            casasDecimais = 2;
        }
        if (Objects.nonNull(cadastroImobiliario.getAreaLote())) {
            cadastroImobiliario.setAreaLote(cadastroImobiliario.getAreaLote().setScale(casasDecimais, 4));
        }
        if (Objects.nonNull(cadastroImobiliario.getAreaUtilLote())) {
            cadastroImobiliario.setAreaUtilLote(cadastroImobiliario.getAreaUtilLote().setScale(casasDecimais, 4));
        }
        if (Objects.nonNull(cadastroImobiliario.getAreaPrivativa())) {
            cadastroImobiliario.setAreaPrivativa(cadastroImobiliario.getAreaPrivativa().setScale(casasDecimais, 4));
        }
        if (Objects.nonNull(cadastroImobiliario.getAreaComum())) {
            cadastroImobiliario.setAreaComum(cadastroImobiliario.getAreaComum().setScale(casasDecimais, 4));
        }
    }

    private Boolean utilizaSituacaoSegmento() {
        return this.parametroEntidadeService.getParamValueAsBoolean(ParametroEntidadeEnum.UTILIZA_SITUACAO_SEGMENTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    private Long parametroCasasDecimaisImobiliario() {
        return this.parametroGeralService.getParamValueAsLong(ParametroGeralEnum.CASAS_DECIMAIS_IMOBILIARIO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    public CadastroImobiliario findByTipoCadastroAndCadastroGeral(TipoCadastro tipoCadastro, Long cadastroGeral) {
        CadastroImobiliario cadastroImobiliarioEntity = this.cadastroImobiliarioRepository.findByTipoCadastroAndCadastroGeral(tipoCadastro, cadastroGeral);
        return cadastroImobiliarioEntity;
    }

    public ImprimirRelatorioDTO buildImpressaoEspelhoDTO(Long cadastroGeral) {
        ImprimirRelatorioDTO dto = new ImprimirRelatorioDTO();
        dto.setRelatorio(RelatorioSistema.CADASTRO_IMOBILIARIO_COMPLETO.getId());
        dto.setFiltro(String.format(" cg.TipoCadastro = %d and cg.CadastroGeral = %d", TipoCadastro.IMOBILIARIO.getValue(), cadastroGeral));
        dto.setListParametros(this.espelhoImobiliarioParamLoader.load());
        dto.setSubReports(this.getSubReportDTO(dto.getFiltro()));
        return dto;
    }

    private SubReportDTO getSubReportDTO(String filtro) {
        SubReportDTO subReportDTO = new SubReportDTO();
        subReportDTO.setItems((Set)Sets.newHashSet((Object[])new SubReportItemDTO[]{new SubReportItemDTO("PROPRIETARIOS", filtro), new SubReportItemDTO("TESTADA", filtro), new SubReportItemDTO("CAUCAO", filtro), new SubReportItemDTO("TERRENO", filtro), new SubReportItemDTO("SEGMENTO", filtro), new SubReportItemDTO("ObservacaoImobiliario", filtro), new SubReportItemDTO("AREAVERDE", filtro), new SubReportItemDTO("Geminada", filtro), new SubReportItemDTO("Isencao", filtro), new SubReportItemDTO("SegmentoDemolicao", filtro), new SubReportItemDTO("TESTADA_GENERICA", filtro)}));
        return subReportDTO;
    }
}

