/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Proprietario;
import br.com.elotech.tributos.domain.SituacaoMobiliario;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSituacao;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.domain.mobiliario.RegimeFiscal;
import br.com.elotech.tributos.dto.CadastroGeralAcessoWebDTO;
import br.com.elotech.tributos.dto.CadastroGeralResponsavelDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoCadastroDTO;
import br.com.elotech.tributos.repository.CadastroGeralRepository;
import br.com.elotech.tributos.repository.projections.CadastroGeralResponsavelProjection;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.RegimeFiscalPeriodoService;
import br.com.elotech.tributos.service.ResponsavelCadastroService;
import br.com.elotech.tributos.service.exception.CadastroExclusaoLogicaException;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CadastroGeralService
extends CrudService<CadastroGeral, Long> {
    private static final String RESPONSAVEL_PRINCIPAL_NOT_FOUND = "N\u00e3o existe um propriet\u00e1rio principal para o cadastro: %d-%d";
    private final ResponsavelCadastroService responsavelCadastroService;
    private final CadastroGeralRepository cadastroGeralRepository;
    private final RegimeFiscalPeriodoService regimeFiscalPeriodoService;
    private final PessoaService pessoaService;

    public CadastroGeralService(CadastroGeralRepository cadastroGeralRepository, ResponsavelCadastroService responsavelCadastroService, RegimeFiscalPeriodoService regimeFiscalPeriodoService, PessoaService pessoaService) {
        this.cadastroGeralRepository = cadastroGeralRepository;
        this.responsavelCadastroService = responsavelCadastroService;
        this.regimeFiscalPeriodoService = regimeFiscalPeriodoService;
        this.pessoaService = pessoaService;
    }

    public List<CadastroGeral> findByPessoaCnpjCpf(String cnpjCpf) {
        return this.cadastroGeralRepository.findByPessoaCnpjCpf(cnpjCpf);
    }

    public Optional<CadastroGeral> findByTipoCadastroAndCadastroGeral(TipoCadastro tipoCadastro, Long cadastroGeral) {
        return this.cadastroGeralRepository.findOneByTipoCadastroAndCadastroGeral(tipoCadastro, cadastroGeral);
    }

    private Optional<CadastroGeral> findByTipoCadastroAndCadastroGeral(CadastroGeralResponsavelProjection projection) {
        return this.findByTipoCadastroAndCadastroGeral(TipoCadastro.fromValue((Long)projection.getTipoCadastro()), projection.getCadastroGeral());
    }

    public Optional<CadastroGeralAcessoWebDTO> getCadastro(TipoCadastro tipoCadastro, Long codigoCadastroGeral) {
        return this.findByTipoCadastroAndCadastroGeral(tipoCadastro, codigoCadastroGeral).map(arg_0 -> this.preencheDTO(arg_0));
    }

    public List<CadastroGeralAcessoWebDTO> getCadastrosByCpf(String cpf) {
        Set cadastros = this.responsavelCadastroService.findResponsavelList(cpf).stream().map(arg_0 -> this.findByTipoCadastroAndCadastroGeral(arg_0)).map(Optional::get).collect(Collectors.toSet());
        cadastros.addAll(this.cadastroGeralRepository.findByPessoaCnpjCpf(cpf));
        return cadastros.stream().map(arg_0 -> this.preencheDTO(arg_0)).collect(Collectors.toList());
    }

    private CadastroGeralAcessoWebDTO preencheDTO(CadastroGeral cadastroGeral) {
        CadastroImobiliarioSituacao situacao;
        CadastroGeralAcessoWebDTO cadastroGeralAcessoWebDTO = new CadastroGeralAcessoWebDTO();
        cadastroGeralAcessoWebDTO.setTipoCadastro(cadastroGeral.getTipoCadastro().getValue());
        cadastroGeralAcessoWebDTO.setDescTipoCadastro(cadastroGeral.getTipoCadastro().getDescricao());
        cadastroGeralAcessoWebDTO.setCadastroGeral(cadastroGeral.getCadastroGeral());
        cadastroGeralAcessoWebDTO.setNome(cadastroGeral.getPessoa().getNome());
        cadastroGeralAcessoWebDTO.setCnpjCpf(cadastroGeral.getPessoa().getCnpjCpf());
        cadastroGeralAcessoWebDTO.setEndereco(cadastroGeral.getEnderecoFormatado());
        cadastroGeralAcessoWebDTO.setCidadeUf(cadastroGeral.getCidadeFormatada());
        cadastroGeralAcessoWebDTO.setCep(cadastroGeral.getCep());
        if (cadastroGeral.getTipoCadastro().isMobiliario().booleanValue()) {
            SituacaoMobiliario situacao2;
            CadastroMobiliario cadastroMobiliario = (CadastroMobiliario)cadastroGeral;
            RegimeFiscal regimeFiscal = this.regimeFiscalPeriodoService.findRegimeFiscal(cadastroMobiliario.getCadastroGeralISS());
            if (Objects.nonNull(regimeFiscal)) {
                cadastroGeralAcessoWebDTO.setRegimeFiscal(regimeFiscal.getDescricao());
            }
            if (Objects.nonNull(situacao2 = cadastroMobiliario.getSituacaoAtual())) {
                cadastroGeralAcessoWebDTO.setSituacao(situacao2.getId());
                cadastroGeralAcessoWebDTO.setDescSituacao(situacao2.getDescricao());
            }
            cadastroGeralAcessoWebDTO.setNumeroAlvara(cadastroMobiliario.getNumeroAlvara());
            cadastroGeralAcessoWebDTO.setExercicioAlvara(cadastroMobiliario.getExercicioAlvara());
            cadastroGeralAcessoWebDTO.setAtividadePrincipal(cadastroMobiliario.getAtividadePrincipal());
            cadastroGeralAcessoWebDTO.setObservacaoAlvara(cadastroMobiliario.getObservacaoAlvara());
            cadastroGeralAcessoWebDTO.setDataAbertura(cadastroMobiliario.getDataAbertura());
            cadastroGeralAcessoWebDTO.setDataEncerramento(cadastroMobiliario.getDataEncerramento());
            cadastroGeralAcessoWebDTO.setDataValidadeAlvara(cadastroMobiliario.getDataValidadeAlvara());
            cadastroGeralAcessoWebDTO.setDataUltimaFiscalizacao(cadastroMobiliario.getDataUltimaFiscalizacao());
        } else if (cadastroGeral.getTipoCadastro().isImobiliario().booleanValue() && Objects.nonNull(situacao = ((CadastroImobiliario)cadastroGeral).getSituacaoAtual())) {
            cadastroGeralAcessoWebDTO.setSituacao(situacao.getId());
            cadastroGeralAcessoWebDTO.setDescSituacao(situacao.getSituacaoImobiliario().getDescricao());
        }
        return cadastroGeralAcessoWebDTO;
    }

    public Boolean exists(TipoCadastro tipoCadastro, Long cadastroGeral) {
        return this.cadastroGeralRepository.existsByTipoCadastroAndCadastroGeral(tipoCadastro, cadastroGeral);
    }

    public void validaCadastroGeral(TipoCadastro tipoCadastro, Long cadastroGeral) {
        if (!this.exists(tipoCadastro, cadastroGeral).booleanValue()) {
            throw new CadastroNaoEncontradoException(tipoCadastro, cadastroGeral);
        }
    }

    public void validaCadastroGeralExclusaoLogica(CadastroGeral cadastroGeral) {
        CadastroGeral cadastroGeralSalvo;
        if (!cadastroGeral.isNew() && (cadastroGeralSalvo = (CadastroGeral)this.findOne((Serializable)cadastroGeral.getId())) != null && cadastroGeralSalvo.getExclusaoLogica().booleanValue()) {
            throw new CadastroExclusaoLogicaException(cadastroGeral.getTipoCadastro(), cadastroGeral.getCadastroGeral());
        }
    }

    public Pessoa getResponsavel(Long idCadastro) {
        CadastroGeral cadastroGeral = (CadastroGeral)this.cadastroGeralRepository.findOne((Object)idCadastro);
        if (Objects.isNull(cadastroGeral)) {
            throw new CadastroNaoEncontradoException(idCadastro);
        }
        if (cadastroGeral.getTipoCadastro().isImobiliario().booleanValue()) {
            return cadastroGeral.getProprietarios().stream().filter(Proprietario::getCoResponsavelPrincipal).map(Proprietario::getPessoa).findAny().orElse(cadastroGeral.getPessoa());
        }
        return cadastroGeral.getPessoa();
    }

    private String getResponsavelPrincipalNotFoundExceptionMessage(CadastroGeral cadastroGeral) {
        return String.format(RESPONSAVEL_PRINCIPAL_NOT_FOUND, cadastroGeral.getTipoCadastro().getValue(), cadastroGeral.getCadastroGeral());
    }

    public Pessoa getResponsavelPrincipal(CadastroGeral cadastroGeral) {
        Supplier<EloValidationException> eloValidationExceptionSupplier = () -> new EloValidationException(this.getResponsavelPrincipalNotFoundExceptionMessage(cadastroGeral));
        if (Arrays.asList(TipoCadastro.IMOBILIARIO, TipoCadastro.RURAL, TipoCadastro.AVULSO).contains(cadastroGeral.getTipoCadastro())) {
            return this.cadastroGeralRepository.findProprietario(cadastroGeral.getTipoCadastro().getValue(), cadastroGeral.getCadastroGeral()).stream().filter(CadastroGeralResponsavelDTO::getResponsavel).findFirst().map(dto -> this.pessoaService.findOne(dto.getPessoa())).orElseThrow(eloValidationExceptionSupplier);
        }
        if (cadastroGeral.getTipoCadastro().isMobiliario().booleanValue()) {
            return this.cadastroGeralRepository.findSocioMobiliario(cadastroGeral.getTipoCadastro().getValue(), cadastroGeral.getCadastroGeral()).stream().filter(CadastroGeralResponsavelDTO::getResponsavel).findFirst().map(dto -> this.pessoaService.findOne(dto.getPessoa())).orElseThrow(eloValidationExceptionSupplier);
        }
        return this.cadastroGeralRepository.findById((Object)cadastroGeral.getId()).map(CadastroGeral::getPessoa).orElseThrow(eloValidationExceptionSupplier);
    }

    public List<Pessoa> getTodosResponsaveis(CadastroGeral cadastroGeral) {
        if (Arrays.asList(TipoCadastro.IMOBILIARIO, TipoCadastro.RURAL, TipoCadastro.AVULSO).contains(cadastroGeral.getTipoCadastro())) {
            return this.cadastroGeralRepository.findProprietario(cadastroGeral.getTipoCadastro().getValue(), cadastroGeral.getCadastroGeral()).stream().map(CadastroGeralResponsavelDTO::getPessoa).map(arg_0 -> ((PessoaService)this.pessoaService).findOne(arg_0)).collect(Collectors.toList());
        }
        if (cadastroGeral.getTipoCadastro().isMobiliario().booleanValue()) {
            return this.cadastroGeralRepository.findSocioMobiliario(cadastroGeral.getTipoCadastro().getValue(), cadastroGeral.getCadastroGeral()).stream().map(dto -> this.pessoaService.findOne(dto.getPessoa())).collect(Collectors.toList());
        }
        return this.cadastroGeralRepository.findProprietariosById(cadastroGeral.getId()).stream().map(Proprietario::getPessoa).collect(Collectors.toList());
    }

    public Set<ParcelamentoCadastroDTO> getCadastrosByCpfCnpj(String cpfCnpj) {
        return this.cadastroGeralRepository.getCadastrosByCpfCnpj(cpfCnpj);
    }
}

