/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.common.service.EntidadeService;
import br.com.elotech.tributos.dto.ParametroItbiDTO;
import br.com.elotech.tributos.repository.ParametroItbiRepository;
import br.com.elotech.tributos.service.ExercicioService;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/parametros-itbi"})
public class ParametroItbiResource {
    private final ParametroItbiRepository parametroItbiRepository;
    private final ExercicioService exercicioService;
    private final EntidadeService entidadeService;

    public ParametroItbiResource(ParametroItbiRepository parametroItbiRepository, ExercicioService exercicioService, EntidadeService entidadeService) {
        this.parametroItbiRepository = parametroItbiRepository;
        this.exercicioService = exercicioService;
        this.entidadeService = entidadeService;
    }

    @GetMapping
    public ResponseEntity<ParametroItbiDTO> findByEntidadeAndExercicio() {
        Long entidade = this.entidadeService.findEntidadePrincipal().getId();
        Long exercicio = this.exercicioService.getExercicio();
        return ResponseEntity.ok((Object)this.parametroItbiRepository.findByEntidadeAndExercicio(entidade, exercicio));
    }
}

