/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.ws.AisePdfService;
import br.com.elotech.tributos.ws.rest.dto.BloquetoDTO;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gerar-boletos"})
public class GeraBoletoResource {
    private final AisePdfService aisePdfService;
    private final GeraBoletoService geraBoletoService;

    public GeraBoletoResource(AisePdfService aisePdfService, GeraBoletoService geraBoletoService) {
        this.geraBoletoService = geraBoletoService;
        this.aisePdfService = aisePdfService;
    }

    @PostMapping
    public ResponseEntity<List<BloquetoDTO>> geraBoletos(@RequestBody @Valid GeraBoletoDTO geraBoletoDTO) {
        List boletos = this.geraBoletoService.geraBoleto(geraBoletoDTO, Boolean.TRUE);
        return ResponseEntity.ok(boletos.stream().map(boleto -> {
            BloquetoDTO boletoDTO = BloquetoDTO.of((Bloqueto)boleto);
            boletoDTO.setUrlImpressao(this.aisePdfService.fetchBloqueto(boletoDTO.getBloqueto()));
            return boletoDTO;
        }).collect(Collectors.toList()));
    }
}

