/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.dto.DebitoAgrupadoPorFormaPagamentoDTO;
import br.com.elotech.tributos.dto.DebitoCarneDTO;
import br.com.elotech.tributos.params.CadastroGeralParams;
import br.com.elotech.tributos.service.DebitoCarneService;
import br.com.elotech.tributos.service.DebitoCotaUnicaService;
import br.com.elotech.tributos.service.ws.AiseDebitosCarneService;
import br.com.elotech.tributos.ws.rest.dto.DebitoCarneAiseDTO;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/debitoscarne"})
public class DebitosCarneResource {
    private final DebitoCarneService debitoCarneService;
    private final AiseDebitosCarneService aiseDebitosCarneService;
    private final DebitoCotaUnicaService debitoCotaUnicaService;

    public DebitosCarneResource(DebitoCarneService debitoCarneService, AiseDebitosCarneService aiseDebitosCarneService, DebitoCotaUnicaService debitoCotaUnicaService) {
        this.debitoCarneService = debitoCarneService;
        this.aiseDebitosCarneService = aiseDebitosCarneService;
        this.debitoCotaUnicaService = debitoCotaUnicaService;
    }

    @GetMapping(params={"tipoCadastro", "cadastroGeral"})
    public ResponseEntity<List<DebitoCarneAiseDTO>> getDebitosCarne(CadastroGeralParams params) {
        return ResponseEntity.ok().body((Object)this.aiseDebitosCarneService.getDebitosCarneAise(params));
    }

    @GetMapping(value={"/agrupado-forma-pagamento"}, params={"tipo-cadastro", "cadastro-geral"})
    public ResponseEntity<List<DebitoAgrupadoPorFormaPagamentoDTO>> findAllAgrupadoFormaPagamento(@RequestParam(value="tipo-cadastro") Long tipoCadastro, @RequestParam(value="cadastro-geral") Long cadastroGeral) {
        return ResponseEntity.ok((Object)this.debitoCotaUnicaService.findAllDebitoAgrupadoPorFormaPagamentoDisponivelWeb(tipoCadastro, cadastroGeral));
    }

    @GetMapping(value={"/com-forma-pagamento"}, params={"entidade", "exercicio", "tipoCadastro", "cadastroGeral"})
    public ResponseEntity<List<DebitoCarneDTO>> getDebitosCarneComFormaPagamento(@RequestParam(value="entidade") Long entidade, @RequestParam(value="exercicio") Long exercicio, @RequestParam(value="tipoCadastro") Long tipoCadastro, @RequestParam(value="cadastroGeral") Long cadastroGeral) {
        return ResponseEntity.ok((Object)this.debitoCarneService.getDebitosCarneComFormasPagamento(entidade, exercicio, tipoCadastro, cadastroGeral));
    }
}

