/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.cancelamento.CancelamentoDocumentoDTO;
import br.com.elotech.tributos.dto.documento.cda.AtualizaItensParcelasDTO;
import br.com.elotech.tributos.resource.RelatorioResource;
import br.com.elotech.tributos.service.CertidaoDividaAtivaService;
import br.com.elotech.tributos.service.DocumentoItemDividaAtivaService;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/certidoes-divida-ativa"})
@Transactional(readOnly=true)
public class CertidaoDividaAtivaResource {
    private final CertidaoDividaAtivaService certidaoDividaAtivaService;
    private final RelatorioResource relatorioResource;
    private final DocumentoItemDividaAtivaService documentoItemDividaAtivaService;

    public CertidaoDividaAtivaResource(CertidaoDividaAtivaService certidaoDividaAtivaService, RelatorioResource relatorioResource, DocumentoItemDividaAtivaService documentoItemDividaAtivaService) {
        this.certidaoDividaAtivaService = certidaoDividaAtivaService;
        this.relatorioResource = relatorioResource;
        this.documentoItemDividaAtivaService = documentoItemDividaAtivaService;
    }

    @GetMapping(value={"/{id}/resumo"})
    public ResponseEntity<DocumentoDTO> findDocumentosDividaAtiva(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.certidaoDividaAtivaService.findDocumentosDividaAtiva(id));
    }

    @Transactional
    @PutMapping(value={"{id}/cancelar"})
    public ResponseEntity<DocumentoDTO> cancelarCda(@PathVariable Long id, @RequestBody CancelamentoDocumentoDTO cancelamentoDocumentoDTO) {
        return ResponseEntity.ok((Object)this.certidaoDividaAtivaService.cancelarCda(id, cancelamentoDocumentoDTO));
    }

    @GetMapping(value={"/{id}/imprimir"})
    public void getImpirimirCertidoesDividaAtiva(@PathVariable Long id, HttpServletResponse response) throws IOException {
        ImprimirRelatorioDTO imprimirRelatorioDTO = this.certidaoDividaAtivaService.buildImpressaoCDA(id);
        this.relatorioResource.imprimirRelatorioGenerico(imprimirRelatorioDTO, response);
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<DocumentoDTO>> findAllDocumentoDividaAtiva(@RequestParam Optional<String> search, Pageable page) {
        return ResponseEntity.ok((Object)this.certidaoDividaAtivaService.getDocumentos(search, page));
    }

    @PutMapping(value={"/{id}/atualiza-itens-parcelas"})
    public ResponseEntity<Void> atualizaItensParcelas(@PathVariable Long id, @Valid @RequestBody AtualizaItensParcelasDTO dto) {
        this.documentoItemDividaAtivaService.atualizaItensParcelas(id, dto);
        return ResponseEntity.noContent().build();
    }
}

