/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.dto.CadastroMobiliarioDTO;
import br.com.elotech.tributos.dto.ContratoSocialPessoaDTO;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.resource.RelatorioResource;
import br.com.elotech.tributos.service.CadastroMobiliarioService;
import br.com.elotech.tributos.service.ContratoSocialPessoaService;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cadastro-mobiliario"})
public class CadastroMobiliarioResource
extends CrudResource<CadastroMobiliario, Long> {
    private final CadastroMobiliarioService cadastroMobiliarioService;
    private final ContratoSocialPessoaService contratoSocialPessoaService;
    private final RelatorioResource relatorioResource;

    public CadastroMobiliarioResource(CadastroMobiliarioService cadastroMobiliarioService, ContratoSocialPessoaService contratoSocialPessoaService, RelatorioResource relatorioResource) {
        this.cadastroMobiliarioService = cadastroMobiliarioService;
        this.contratoSocialPessoaService = contratoSocialPessoaService;
        this.relatorioResource = relatorioResource;
    }

    @PostMapping(value={"/alteracao-cadastral"})
    public ResponseEntity<CadastroMobiliarioDTO> alterarCadastroMobiliario(@RequestBody CadastroMobiliarioDTO cadastroMobiliarioDTO) {
        CadastroMobiliario cadastroMobiliario = this.cadastroMobiliarioService.alteracaoCadastral(cadastroMobiliarioDTO);
        return ResponseEntity.ok().body((Object)CadastroMobiliarioDTO.from((CadastroMobiliario)cadastroMobiliario));
    }

    @GetMapping(value={"/{cadastroGeral}/contrato-social/participantes"})
    public ResponseEntity<List<ContratoSocialPessoaDTO>> findParticipantesUltimoContrato(@PathVariable(value="cadastroGeral") Long cadastroGeral) {
        return ResponseEntity.ok((Object)this.contratoSocialPessoaService.findParticipantesUltimoContrato(cadastroGeral));
    }

    @GetMapping(path={"/imprimir-espelho"}, params={"cadastroGeral"})
    public void imprimirEspelho(@RequestParam(value="cadastroGeral") Long cadastroGeral, HttpServletResponse response) throws IOException {
        ImprimirRelatorioDTO imprimirRelatorioDTO = this.cadastroMobiliarioService.buildImpressaoEspelhoDTO(cadastroGeral);
        this.relatorioResource.imprimirRelatorioGenerico(imprimirRelatorioDTO, response);
    }
}

