/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.dto.CadastroGeralAcessoWebDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoCadastroDTO;
import br.com.elotech.tributos.params.CadastroGeralParams;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cadastro-geral"})
public class CadastroGeralResource
extends CrudResource<CadastroGeral, Long> {
    private final CadastroGeralService cadastroGeralService;

    public CadastroGeralResource(CadastroGeralService cadastroGeralService) {
        this.cadastroGeralService = cadastroGeralService;
    }

    @GetMapping(params={"cnpjCpf"})
    public ResponseEntity<List<CadastroGeral>> getByCnpjCpf(@RequestParam(value="cnpjCpf") String cnpjCpf) {
        return ResponseEntity.ok().body((Object)this.loadByCnpjCpf(cnpjCpf));
    }

    @GetMapping(path={"/getCadastros"}, params={"cpf"})
    public ResponseEntity<List<CadastroGeralAcessoWebDTO>> getCadastrosByCpf(@RequestParam(value="cpf") String cpf) {
        return ResponseEntity.ok().body((Object)this.cadastroGeralService.getCadastrosByCpf(cpf));
    }

    @GetMapping(path={"/getCadastro"}, params={"tipoCadastro", "cadastroGeral"})
    public ResponseEntity<CadastroGeralAcessoWebDTO> getCadastro(CadastroGeralParams params) {
        Optional cadastroAcessoWebDto = this.cadastroGeralService.getCadastro(params.getTipoCadastro(), params.getCadastroGeral());
        if (!cadastroAcessoWebDto.isPresent()) {
            this.throwCadastroGeralNaoEncontrado(params);
        }
        return ResponseEntity.ok().body(cadastroAcessoWebDto.get());
    }

    @GetMapping(params={"tipoCadastro", "cadastroGeral"})
    public ResponseEntity<CadastroGeral> getByTipoCadastroAndCadastroGeral(CadastroGeralParams params) {
        Optional cadastroGeral = this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(params.getTipoCadastro(), params.getCadastroGeral());
        if (!cadastroGeral.isPresent()) {
            this.throwCadastroGeralNaoEncontrado(params);
        }
        return ResponseEntity.ok().body(cadastroGeral.get());
    }

    private List<CadastroGeral> loadByCnpjCpf(String cnpjCpf) {
        return this.cadastroGeralService.findByPessoaCnpjCpf(cnpjCpf);
    }

    private void throwCadastroGeralNaoEncontrado(CadastroGeralParams params) {
        throw RestException.notFound((String)String.format("Cadastro %d n\u00e3o encontrado", params.getCadastroGeral()), (Throwable)new CadastroNaoEncontradoException(params.getTipoCadastro(), params.getCadastroGeral()));
    }

    @GetMapping(path={"/by-cpf-cnpj/{cpfCnpj}"})
    public ResponseEntity<Set<ParcelamentoCadastroDTO>> getCadastrosByCpfCnpj(@PathVariable String cpfCnpj) {
        return ResponseEntity.ok().body((Object)this.cadastroGeralService.getCadastrosByCpfCnpj(cpfCnpj));
    }
}

