/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.dto.BatchInstanceDTO;
import br.com.elotech.tributos.dto.HistoricoBatchDTO;
import br.com.elotech.tributos.service.BatchService;
import java.util.List;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/batch"})
public class BatchResource {
    private final BatchService batchService;

    public BatchResource(BatchService batchService) {
        this.batchService = batchService;
    }

    @PostMapping(value={"/retry/{jobExecutionId}"})
    public ResponseEntity<Void> retryJob(@PathVariable Long jobExecutionId) throws JobParametersInvalidException, JobRestartException, NoSuchJobException {
        this.batchService.retryJob(jobExecutionId);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/tarefas"})
    public ResponseEntity<Page<BatchInstanceDTO>> getTarefas(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.batchService.getTarefas(search, pageable));
    }

    @GetMapping(value={"/historico/{instanceId}"})
    public ResponseEntity<List<HistoricoBatchDTO>> getExecutionFromInstanceId(@PathVariable Long instanceId) {
        return ResponseEntity.ok((Object)this.batchService.findHistoricoExecutionByInstanceId(instanceId));
    }

    @GetMapping(value={"/running-job"})
    public ResponseEntity<Boolean> hasRunningJob() {
        return ResponseEntity.ok((Object)this.batchService.hasRunningJob());
    }
}

