/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.dividaativa.LivroDTO;
import br.com.elotech.tributos.repository.LivroRepositoryCustom;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class LivroRepositoryImpl
implements LivroRepositoryCustom {
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public LivroRepositoryImpl(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public LivroDTO getLivroResumo(Long entidade, Long exercicio, Long livro) {
        String sql = "SELECT TL.ENTIDADE, TL.EXERCICIO, TL.LIVRO, TL.DATAINCLUSAO, TL.USUARIO, BATCHJOB.JOB_EXECUTION_ID AS IDJOB, BATCHJOB.STATUS AS JOBSTATUS,  CASE WHEN COALESCE(TL.ENGLOBAPARCELAS,'N') = 'N' THEN 0 ELSE 1 END AS ENGLOBAPARCELAS,  SUM(TLPR.VALORORIGINAL) AS VALORTOTALORIGINAL,  SUM(TLPR.VALORJUROS) AS VALORTOTALJUROS,  SUM(TLPR.VALORMULTA) AS VALORTOTALMULTA,  SUM(TLPR.VALORCORRECAO) AS VALORTOTALCORRECAO,  SUM(TLPR.VALORORIGINAL+TLPR.VALORJUROS+TLPR.VALORMULTA+TLPR.VALORCORRECAO) AS VALORTOTAL,  (select count(*) from triblivroregistro tlr   where tlr.entidade = tl.entidade   and tlr.exercicio = tl.exercicio   and tlr.livro = tl.livro) AS TOTALREGISTROS FROM TRIBLIVRO TL LEFT OUTER JOIN TRIBLIVROPARCELARECEITA TLPR ON TL.ENTIDADE = TLPR.ENTIDADE AND TL.EXERCICIO = TLPR.EXERCICIO AND TL.LIVRO = TLPR.LIVRO LEFT OUTER JOIN BATCH_JOB_EXECUTION BATCHJOB ON TL.IDJOB = BATCHJOB.JOB_EXECUTION_ID WHERE TL.ENTIDADE = :entidade AND TL.EXERCICIO = :exercicio AND TL.LIVRO = :livro GROUP BY TL.ENTIDADE, TL.EXERCICIO, TL.LIVRO, TL.DATAINCLUSAO, TL.USUARIO, TL.ENGLOBAPARCELAS, BATCHJOB.JOB_EXECUTION_ID, BATCHJOB.STATUS ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("entidade", (Object)entidade);
        parameters.addValue("exercicio", (Object)exercicio);
        parameters.addValue("livro", (Object)livro);
        try {
            return (LivroDTO)this.jdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(LivroDTO.class));
        }
        catch (EmptyResultDataAccessException e) {
            throw new EloValidationException(String.format("Livro n\u00e3o localizado: %d/%d", livro, exercicio));
        }
    }
}

