/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.tributos.domain.DebitoParcelaId;
import br.com.elotech.tributos.domain.LivroId;
import br.com.elotech.tributos.domain.LivroRegistro;
import br.com.elotech.tributos.dto.dividaativa.GeraLivroDebitoParcelaDTO;
import br.com.elotech.tributos.dto.dividaativa.GeraLivroDebitoParcelaTributoDTO;
import br.com.elotech.tributos.dto.dividaativa.LivroExistenteSequenciadoresDTO;
import br.com.elotech.tributos.dto.dividaativa.TotalizadorLivroDTO;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.util.SqlUtils;
import java.sql.Date;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class GeraLivroRepository {
    private final EntidadeRepository entidadeRepository;
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public GeraLivroRepository(EntidadeRepository entidadeRepository, NamedParameterJdbcTemplate jdbcTemplate) {
        this.entidadeRepository = entidadeRepository;
        this.jdbcTemplate = jdbcTemplate;
    }

    private String getSqlDebitos(String filtros, Boolean agrupaPorParcela) {
        return String.format("SELECT DISTINCT    TD.IDDEBITO,   TD.ENTIDADE,   TD.EXERCICIO,   TD.TIPOCADASTRO,   TD.CADASTROGERAL,   TCG.IDKEY AS IDCADASTROGERAL,   TD.GUIARECOLHIMENTO AS DIVIDA,   TGR.DESCRICAO AS DESCRICAODIVIDA,   TGR.IDKEY AS IDDIVIDA,   TD.SUBDIVIDA,   TDP.PARCELA,   TDP.SITUACAODEBITO, " + (agrupaPorParcela != false ? "" : " TDPR.RECEITA AS TRIBUTO, ") + (agrupaPorParcela != false ? "" : " TDPR.IDDEBITOPARCELARECEITA AS IDDEBITOPARCELATRIBUTO, ") + "  TDP.DATAVENCIMENTO,   TDP.DATALANCAMENTO,   TD.DATAPRIMEIRAPARCELA,   (SELECT MIN(X.DATAVENCIMENTO) FROM  TRIBDEBITOPARCELA X            JOIN TRIBSITUACAOPARCELA TSP ON TSP.SITUACAOPARCELA = X.SITUACAODEBITO            JOIN TRIBTIPOSITUACAOPARCELA TTSP ON TTSP.TIPOSITUACAOPARCELA = TSP.TIPOSITUACAOPARCELA      WHERE TD.ENTIDADE = X.ENTIDADE        AND TD.EXERCICIO = X.EXERCICIO        AND TD.TIPOCADASTRO = X.TIPOCADASTRO        AND TD.CADASTROGERAL = X.CADASTROGERAL        AND TD.GUIARECOLHIMENTO = X.GUIARECOLHIMENTO        AND TD.SUBDIVIDA = X.SUBDIVIDA        AND TTSP.TIPO = 'A') MINDATAVENCIMENTOPARCELA,   TDP.SITUACAOLEGAL,   TD.FORMACORRECAO,   PES.PESSOA,   PES.NOME AS PESSOANOME,   PES.CNPJ_CPF,   CASE WHEN COALESCE(TD.PARCELADO, 'N') = 'S' THEN 1 ELSE 0 END AS PARCELADO ,   CASE WHEN COALESCE(TD.REPARCELADO, 'N') = 'S' THEN 1 ELSE 0 END AS REPARCELADO, " + (agrupaPorParcela != false ? " SUM(TDPR.VALOR) AS VALOR " : " TDPR.VALOR ") + "FROM TRIBDEBITO TD JOIN TRIBDEBITOPARCELA TDP  ON TD.ENTIDADE = TDP.ENTIDADE AND TD.EXERCICIO = TDP.EXERCICIO AND TD.TIPOCADASTRO = TDP.TIPOCADASTRO AND TD.CADASTROGERAL = TDP.CADASTROGERAL AND TD.GUIARECOLHIMENTO = TDP.GUIARECOLHIMENTO AND TD.SUBDIVIDA = TDP.SUBDIVIDA JOIN TRIBDEBITOPARCELARECEITA TDPR  ON TDP.ENTIDADE = TDPR.ENTIDADE AND TDP.EXERCICIO = TDPR.EXERCICIO AND TDP.TIPOCADASTRO = TDPR.TIPOCADASTRO AND TDP.CADASTROGERAL = TDPR.CADASTROGERAL AND TDP.GUIARECOLHIMENTO = TDPR.GUIARECOLHIMENTO AND TDP.SUBDIVIDA = TDPR.SUBDIVIDA AND TDP.PARCELA = TDPR.PARCELA JOIN TRIBCADASTROGERAL TCG  ON TCG.TIPOCADASTRO = TD.TIPOCADASTRO AND TCG.CADASTROGERAL = TD.CADASTROGERAL JOIN PESSOA PES  ON TCG.PESSOA = PES.PESSOA JOIN TRIBSITUACAOPARCELA TSP  ON TSP.SITUACAOPARCELA = TDP.SITUACAODEBITO JOIN TRIBTIPOSITUACAOPARCELA TTSP  ON TSP.TIPOSITUACAOPARCELA = TTSP.TIPOSITUACAOPARCELA JOIN TRIBGUIARECOLHIMENTO TGR  ON TD.ENTIDADE = TGR.ENTIDADE AND TD.EXERCICIO = TGR.EXERCICIO AND TD.GUIARECOLHIMENTO = TGR.GUIARECOLHIMENTO WHERE TD.ENTIDADE = :Entidade   AND TD.CONSTITUIDO = 'S'   AND TDP.LIVRO IS NULL   AND COALESCE(TCG.EXCLUSAOLOGICA,'N') = 'N'   AND TDPR.VALOR > 0   AND TTSP.TIPO = 'A'  %s " + (agrupaPorParcela != false ? "GROUP BY TD.IDDEBITO, TD.ENTIDADE, TD.EXERCICIO, TD.TIPOCADASTRO, TD.CADASTROGERAL, TCG.IDKEY, TD.GUIARECOLHIMENTO, TGR.DESCRICAO, TGR.IDKEY,   TD.SUBDIVIDA, TDP.PARCELA, TDP.SITUACAODEBITO, TDP.DATAVENCIMENTO, TDP.DATALANCAMENTO, TD.DATAPRIMEIRAPARCELA, TDP.SITUACAOLEGAL, TD.FORMACORRECAO,   PES.PESSOA, PES.NOME, PES.CNPJ_CPF, TD.PARCELADO, TD.REPARCELADO " : "") + "ORDER BY TD.TIPOCADASTRO, TD.CADASTROGERAL, TD.EXERCICIO, TD.GUIARECOLHIMENTO, TD.SUBDIVIDA, TDP.PARCELA ", filtros);
    }

    public Page<GeraLivroDebitoParcelaDTO> getDebitoParcelas(String filtro, Pageable pageable, Long entidade) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("Entidade", (Object)entidade);
        String sqlBase = this.getSqlDebitos(filtro, Boolean.TRUE);
        String sqlContagem = String.format("select count(*) as total from (%s) count_query", sqlBase);
        Long numeroTotal = (Long)this.jdbcTemplate.queryForObject(sqlContagem, (SqlParameterSource)parameters, (rs, rowNum) -> rs.getLong("total"));
        String sqlComPaginacao = SqlUtils.withPagination((String)sqlBase, (Pageable)pageable, (DataSource)this.jdbcTemplate.getJdbcTemplate().getDataSource());
        List pagedRecords = this.jdbcTemplate.query(sqlComPaginacao, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(GeraLivroDebitoParcelaDTO.class));
        return new PageImpl(pagedRecords, pageable, numeroTotal.longValue());
    }

    public List<GeraLivroDebitoParcelaTributoDTO> getParcelaTributos(String filtro) {
        Long entidade = this.entidadeRepository.findByEntidadeprincipal().getId();
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("Entidade", (Object)entidade);
        return this.jdbcTemplate.query(this.getSqlDebitos(filtro, Boolean.FALSE), (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(GeraLivroDebitoParcelaTributoDTO.class));
    }

    public void updateDebitoParcela(DebitoParcelaId parcelaId, LivroRegistro livroRegistro, Integer situacaoLegal, Long situacaoDebito, Boolean englobaDebitos) {
        String sql = "UPDATE TRIBDEBITOPARCELA SET EXERCICIOLIVRO = :EXERCICIOLIVRO, LIVRO = :LIVRO, NUMEROFOLHA = :NUMEROFOLHA, NUMEROINSCRICAO = :NUMEROINSCRICAO, SITUACAOLEGAL = :SITUACAOLEGAL, DATADIVIDAATIVA = :DATADIVIDAATIVA, " + (englobaDebitos != false ? "SITUACAODEBITO = :SITUACAODEBITO, " : "") + "DATASITUACAO = :DATADIVIDAATIVA WHERE ENTIDADE = :ENTIDADE AND EXERCICIO = :EXERCICIO AND TIPOCADASTRO = :TIPOCADASTRO AND CADASTROGERAL = :CADASTROGERAL AND GUIARECOLHIMENTO = :GUIARECOLHIMENTO AND SUBDIVIDA = :SUBDIVIDA AND PARCELA = :PARCELA ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("EXERCICIOLIVRO", (Object)livroRegistro.getId().getLivro().getId().getExercicio());
        parameters.addValue("LIVRO", (Object)livroRegistro.getId().getLivro().getId().getLivro());
        parameters.addValue("NUMEROFOLHA", (Object)livroRegistro.getNumeroFolha());
        parameters.addValue("NUMEROINSCRICAO", (Object)livroRegistro.getNumeroInscricao());
        parameters.addValue("SITUACAOLEGAL", (Object)situacaoLegal);
        parameters.addValue("DATADIVIDAATIVA", (Object)Date.valueOf(livroRegistro.getDataInscricao()), 91);
        if (englobaDebitos.booleanValue()) {
            parameters.addValue("SITUACAODEBITO", (Object)situacaoDebito);
        }
        parameters.addValue("ENTIDADE", (Object)parcelaId.getEntidade());
        parameters.addValue("EXERCICIO", (Object)parcelaId.getExercicio());
        parameters.addValue("TIPOCADASTRO", (Object)parcelaId.getTipoCadastro());
        parameters.addValue("CADASTROGERAL", (Object)parcelaId.getCadastroGeral());
        parameters.addValue("GUIARECOLHIMENTO", (Object)parcelaId.getDivida());
        parameters.addValue("SUBDIVIDA", (Object)parcelaId.getSubDivida());
        parameters.addValue("PARCELA", (Object)parcelaId.getParcela());
        this.jdbcTemplate.update(sql, (SqlParameterSource)parameters);
    }

    public void updateDebitoParcelaEnglobado(DebitoParcelaId parcelaId, LivroRegistro livroRegistro, Integer situacaoLegal) {
        String sql = "UPDATE TRIBDEBITOPARCELA SET EXERCICIOLIVRO = :EXERCICIOLIVRO, LIVRO = :LIVRO, NUMEROFOLHA = :NUMEROFOLHA, NUMEROINSCRICAO = :NUMEROINSCRICAO, SITUACAOLEGAL = :SITUACAOLEGAL, DATADIVIDAATIVA = :DATADIVIDAATIVA, DATASITUACAO = :DATADIVIDAATIVA WHERE ENTIDADE = :ENTIDADE AND EXERCICIO = :EXERCICIO AND TIPOCADASTRO = :TIPOCADASTRO AND CADASTROGERAL = :CADASTROGERAL AND GUIARECOLHIMENTO = :GUIARECOLHIMENTO AND SUBDIVIDA = :SUBDIVIDA AND PARCELA = :PARCELA ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("EXERCICIOLIVRO", (Object)livroRegistro.getId().getLivro().getId().getExercicio());
        parameters.addValue("LIVRO", (Object)livroRegistro.getId().getLivro().getId().getLivro());
        parameters.addValue("NUMEROFOLHA", (Object)livroRegistro.getNumeroFolha());
        parameters.addValue("NUMEROINSCRICAO", (Object)livroRegistro.getNumeroInscricao());
        parameters.addValue("SITUACAOLEGAL", (Object)situacaoLegal);
        parameters.addValue("DATADIVIDAATIVA", (Object)Date.valueOf(livroRegistro.getDataInscricao()), 91);
        parameters.addValue("ENTIDADE", (Object)parcelaId.getEntidade());
        parameters.addValue("EXERCICIO", (Object)parcelaId.getExercicio());
        parameters.addValue("TIPOCADASTRO", (Object)parcelaId.getTipoCadastro());
        parameters.addValue("CADASTROGERAL", (Object)parcelaId.getCadastroGeral());
        parameters.addValue("GUIARECOLHIMENTO", (Object)parcelaId.getDivida());
        parameters.addValue("SUBDIVIDA", (Object)parcelaId.getSubDivida());
        parameters.addValue("PARCELA", (Object)parcelaId.getParcela());
        this.jdbcTemplate.update(sql, (SqlParameterSource)parameters);
    }

    public LivroExistenteSequenciadoresDTO getLastLivroExistenteSequenciadores(LivroId livroId) {
        String sql = "select seq.lastSequencia,        seq.lastNumeroInscricao,        seq.lastNumeroFolha,        max(SEQUENCIAFOLHA) lastSequenciaFolha from (SELECT tlr.entidade,              tlr.EXERCICIO,              tlr.livro,              coalesce(max(tlr.sequencia), 0)       lastSequencia,              coalesce(max(tlr.numeroInscricao), 0) lastNumeroInscricao,              coalesce(max(tlr.numeroFolha), 0)     lastNumeroFolha       FROM TribLivroRegistro tlr       WHERE tlr.entidade = :entidade         AND tlr.exercicio = :exercicio         AND tlr.livro = :livro       group by tlr.entidade, tlr.EXERCICIO, tlr.livro) seq inner join TRIBLIVROREGISTRO tlr2         on seq.ENTIDADE = tlr2.entidade and seq.EXERCICIO = tlr2.EXERCICIO and seq.LIVRO = tlr2.livro             and tlr2.NUMEROFOLHA = seq.lastNumeroFolha group by seq.entidade, seq.EXERCICIO, seq.livro, seq.lastSequencia, seq.lastNumeroInscricao,          seq.lastNumeroFolha";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("entidade", (Object)livroId.getEntidade());
        parameters.addValue("exercicio", (Object)livroId.getExercicio());
        parameters.addValue("livro", (Object)livroId.getLivro());
        List sequenciadoresDTO = this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(LivroExistenteSequenciadoresDTO.class));
        return sequenciadoresDTO.isEmpty() ? LivroExistenteSequenciadoresDTO.of((Long)0L, (Long)1L, (Long)0L) : (LivroExistenteSequenciadoresDTO)sequenciadoresDTO.get(0);
    }

    public TotalizadorLivroDTO getTotalizadores(LivroId livroId) {
        String sql = "select coalesce(sum(VALORORIGINAL),0) as valororiginal,             coalesce(sum(VALORJUROS),0)    as valorjuros,             coalesce(sum(VALORMULTA),0)    as valormulta,             coalesce(sum(VALORCORRECAO),0)  as valorcorrecao,             coalesce(count(*),0)           as totalregistros,            coalesce(max(NUMEROFOLHA),0)   as numerofolhas from triblivroregistro tlr  WHERE tlr.entidade = :entidade  AND tlr.exercicio = :exercicio  AND tlr.livro = :livro";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("entidade", (Object)livroId.getEntidade());
        parameters.addValue("exercicio", (Object)livroId.getExercicio());
        parameters.addValue("livro", (Object)livroId.getLivro());
        return (TotalizadorLivroDTO)this.jdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(TotalizadorLivroDTO.class));
    }
}

