/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.atendimento;

import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.atendimento.Atendimento;
import br.com.elotech.tributos.domain.atendimento.TipoAtendimento;
import br.com.elotech.tributos.dto.AtendimentoPessoaDTO;
import br.com.elotech.tributos.dto.EnderecoCadastroGeralDTO;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;

public class AtendimentoDTO {
    private Long id;
    @NotNull
    private TipoAtendimento tipoAtendimento;
    private UUID atendente;
    private LocalDateTime horarioInicio;
    private LocalDateTime horarioFim;
    @Length(max=14)
    private @Length(max=14) String cpfCnpjRequerente;
    @Length(max=150)
    private @Length(max=150) String nomeRequerente;
    @Length(max=250)
    private @Length(max=250) String observacao;
    private AtendimentoPessoaDTO contribuinte;
    @NotNull
    private EnderecoCadastroGeralDTO cadastroGeral;

    public Atendimento toEntity(CadastroGeral cadastroGeral) {
        Atendimento atendimento = new Atendimento();
        atendimento.setId(this.getId());
        atendimento.setAtendente(this.getAtendente());
        atendimento.setCadastroGeral(cadastroGeral);
        Optional.ofNullable(this.getContribuinte()).ifPresent(pessoa -> atendimento.setContribuinte(pessoa.toEntity()));
        atendimento.setCpfCnpjRequerente(this.getCpfCnpjRequerente());
        atendimento.setHorarioInicio(this.getHorarioInicio());
        atendimento.setHorarioFim(this.getHorarioFim());
        atendimento.setNomeRequerente(this.getNomeRequerente());
        atendimento.setObservacao(this.getObservacao());
        atendimento.setTipoAtendimento(this.getTipoAtendimento());
        return atendimento;
    }

    public static AtendimentoDTO from(Atendimento atendimento) {
        AtendimentoDTO dto = new AtendimentoDTO();
        Optional.ofNullable(atendimento.getId()).ifPresent(arg_0 -> dto.setId(arg_0));
        Optional.ofNullable(atendimento.getAtendente()).ifPresent(arg_0 -> dto.setAtendente(arg_0));
        Optional.ofNullable(atendimento.getCadastroGeral()).map(EnderecoCadastroGeralDTO::from).ifPresent(arg_0 -> dto.setCadastroGeral(arg_0));
        Optional.ofNullable(atendimento.getContribuinte()).map(AtendimentoPessoaDTO::from).ifPresent(arg_0 -> dto.setContribuinte(arg_0));
        Optional.ofNullable(atendimento.getCpfCnpjRequerente()).ifPresent(arg_0 -> dto.setCpfCnpjRequerente(arg_0));
        Optional.ofNullable(atendimento.getHorarioFim()).ifPresent(arg_0 -> dto.setHorarioFim(arg_0));
        Optional.ofNullable(atendimento.getHorarioInicio()).ifPresent(arg_0 -> dto.setHorarioInicio(arg_0));
        Optional.ofNullable(atendimento.getNomeRequerente()).ifPresent(arg_0 -> dto.setNomeRequerente(arg_0));
        Optional.ofNullable(atendimento.getObservacao()).ifPresent(arg_0 -> dto.setObservacao(arg_0));
        Optional.ofNullable(atendimento.getTipoAtendimento()).ifPresent(arg_0 -> dto.setTipoAtendimento(arg_0));
        return dto;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public TipoAtendimento getTipoAtendimento() {
        return this.tipoAtendimento;
    }

    public void setTipoAtendimento(TipoAtendimento tipoAtendimento) {
        this.tipoAtendimento = tipoAtendimento;
    }

    public UUID getAtendente() {
        return this.atendente;
    }

    public void setAtendente(UUID atendente) {
        this.atendente = atendente;
    }

    public LocalDateTime getHorarioInicio() {
        return this.horarioInicio;
    }

    public void setHorarioInicio(LocalDateTime horarioInicio) {
        this.horarioInicio = horarioInicio;
    }

    public LocalDateTime getHorarioFim() {
        return this.horarioFim;
    }

    public void setHorarioFim(LocalDateTime horarioFim) {
        this.horarioFim = horarioFim;
    }

    public String getCpfCnpjRequerente() {
        return this.cpfCnpjRequerente;
    }

    public void setCpfCnpjRequerente(String cpfCnpjRequerente) {
        this.cpfCnpjRequerente = cpfCnpjRequerente;
    }

    public String getNomeRequerente() {
        return this.nomeRequerente;
    }

    public void setNomeRequerente(String nomeRequerente) {
        this.nomeRequerente = nomeRequerente;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public AtendimentoPessoaDTO getContribuinte() {
        return this.contribuinte;
    }

    public void setContribuinte(AtendimentoPessoaDTO contribuinte) {
        this.contribuinte = contribuinte;
    }

    public EnderecoCadastroGeralDTO getCadastroGeral() {
        return this.cadastroGeral;
    }

    public void setCadastroGeral(EnderecoCadastroGeralDTO cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }
}

