/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.acrescimo;

import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.SituacaoLegal;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItemDetalhe;
import br.com.elotech.tributos.dto.DebitoEmAbertoDTO;
import br.com.elotech.tributos.dto.DebitoManualDTO;
import br.com.elotech.tributos.dto.DebitoManualParcelaDTO;
import br.com.elotech.tributos.dto.DebitoManualTributoDTO;
import br.com.elotech.tributos.dto.DividaDTO;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoCdaDTO;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoDTO;
import br.com.elotech.tributos.dto.dividaativa.GeraLivroDebitoParcelaTributoDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class AcrescimoDTO {
    private BigDecimal valor = BigDecimal.ZERO;
    private BigDecimal valorOriginal = BigDecimal.ZERO;
    private BigDecimal valorCorrecao = BigDecimal.ZERO;
    private BigDecimal valorMulta = BigDecimal.ZERO;
    private BigDecimal valorJuros = BigDecimal.ZERO;
    private BigDecimal valorDescontoPrincipal = BigDecimal.ZERO;
    private BigDecimal valorDescontoCorrecao = BigDecimal.ZERO;
    private BigDecimal valorDescontoMulta = BigDecimal.ZERO;
    private BigDecimal valorDescontoJuros = BigDecimal.ZERO;
    private BigDecimal valorDesconto = BigDecimal.ZERO;
    private BigDecimal valorTotal = BigDecimal.ZERO;
    private BigDecimal descontoParcelamento = BigDecimal.ZERO;
    private Long entidade;
    private Long exercicio;
    private LocalDate dataReferencia;
    private LocalDate dataLancamento;
    private LocalDate dataVencimento;
    private LocalDate dataPrimeiraParcela;
    private LocalDate dataVencimentoOriginal;
    private DividaDTO divida;
    private String tributo;
    private Long formaPagamento;
    private Long formaCorrecao;
    private SituacaoLegal situacaoLegal;
    private Boolean parcelado;
    private Boolean calculaValorDesconto = Boolean.TRUE;

    public static AcrescimoDTO of(DebitoEmAbertoDTO debitoEmAbertoDTO, Long formaPagamentoPadrao) {
        AcrescimoDTO acrescimoDTO = new AcrescimoDTO();
        acrescimoDTO.setValor(debitoEmAbertoDTO.getValorPrincipal());
        acrescimoDTO.setEntidade(debitoEmAbertoDTO.getEntidade());
        acrescimoDTO.setExercicio(debitoEmAbertoDTO.getExercicio());
        acrescimoDTO.setDataReferencia(LocalDate.now());
        acrescimoDTO.setDataLancamento(debitoEmAbertoDTO.getDataLancamento());
        acrescimoDTO.setDataVencimento(debitoEmAbertoDTO.getDataVencimento());
        acrescimoDTO.setDataPrimeiraParcela(debitoEmAbertoDTO.getDataPrimeiraParcela());
        DividaDTO dividaDTO = new DividaDTO();
        dividaDTO.setDivida(debitoEmAbertoDTO.getDivida());
        acrescimoDTO.setDivida(dividaDTO);
        acrescimoDTO.setTributo(debitoEmAbertoDTO.getTributo());
        acrescimoDTO.setFormaPagamento(formaPagamentoPadrao);
        acrescimoDTO.setFormaCorrecao(debitoEmAbertoDTO.getFormaCorrecao());
        acrescimoDTO.setSituacaoLegal(SituacaoLegal.fromValue((Integer)debitoEmAbertoDTO.getSituacaoLegal()));
        acrescimoDTO.setParcelado(Boolean.valueOf(debitoEmAbertoDTO.getParcelado() != false || debitoEmAbertoDTO.getReparcelado() != false));
        return acrescimoDTO;
    }

    public static AcrescimoDTO of(LoteCdaItemDetalhe loteCdaItemDetalhe, Long formaPagamentoPadrao) {
        return AcrescimoDTO.builder().exercicio(loteCdaItemDetalhe.getParcelaTributo().getExercicio()).dataLancamento(loteCdaItemDetalhe.getParcelaTributo().getDebitoParcela().getDebito().getDataLancamento()).dataPrimeiraParcela(loteCdaItemDetalhe.getParcelaTributo().getDebitoParcela().getDebito().getDataPrimeiraParcela()).dataVencimento(loteCdaItemDetalhe.getParcelaTributo().getDebitoParcela().getDataVencimento()).formaCorrecao(loteCdaItemDetalhe.getParcelaTributo().getDebitoParcela().getDebito().getFormaCorrecao().getId()).parcelado(loteCdaItemDetalhe.getParcelaTributo().getDebitoParcela().getDebito().getParcelado()).situacaoLegal(loteCdaItemDetalhe.getParcelaTributo().getDebitoParcela().getSituacaoLegal()).tributo(loteCdaItemDetalhe.getParcelaTributo().getTributo()).valor(loteCdaItemDetalhe.getParcelaTributo().getValor()).formaPagamento(formaPagamentoPadrao).divida(DividaDTO.of((Divida)loteCdaItemDetalhe.getParcelaTributo().getDebitoParcela().getDebito().getDivida())).build();
    }

    public static AcrescimoDTO of(AcrescimoCdaDTO acrescimoCdaDTO, Long formaPagamentoPadrao, LocalDate dataReferencia) {
        DividaDTO dividaDTO = new DividaDTO();
        dividaDTO.setEntidade(acrescimoCdaDTO.getEntidade());
        dividaDTO.setExercicio(acrescimoCdaDTO.getExercicio());
        dividaDTO.setDivida(acrescimoCdaDTO.getIdDivida());
        return AcrescimoDTO.builder().entidade(acrescimoCdaDTO.getEntidade()).exercicio(acrescimoCdaDTO.getExercicio()).dataLancamento(acrescimoCdaDTO.getDataLancamento()).dataPrimeiraParcela(acrescimoCdaDTO.getDataPrimeiraParcela()).dataVencimento(acrescimoCdaDTO.getDataVencimento()).dataReferencia(dataReferencia).formaCorrecao(acrescimoCdaDTO.getFormaCorrecao()).parcelado(acrescimoCdaDTO.getParcelado()).situacaoLegal(acrescimoCdaDTO.getSituacaoLegal()).tributo(acrescimoCdaDTO.getTributo()).valor(acrescimoCdaDTO.getValor()).formaPagamento(formaPagamentoPadrao).divida(dividaDTO).calculaValorDesconto(acrescimoCdaDTO.getCalculaValorDesconto()).build();
    }

    public static AcrescimoDTO of(DebitoManualDTO debitoManualDTO, DebitoManualTributoDTO debitoTributo, Long formaPagamentoPadrao, Long entidade) {
        DividaDTO dividaDTO = new DividaDTO();
        dividaDTO.setEntidade(entidade);
        dividaDTO.setExercicio(debitoManualDTO.getExercicio());
        dividaDTO.setDivida(debitoManualDTO.getDivida());
        DebitoManualParcelaDTO debitoManualParcelaDTO = debitoManualDTO.getParcelas().stream().findFirst().orElse(new DebitoManualParcelaDTO());
        return AcrescimoDTO.builder().entidade(entidade).exercicio(debitoManualDTO.getExercicio()).dataLancamento(debitoManualDTO.getDataLancamento()).dataPrimeiraParcela(debitoManualParcelaDTO.getDataVencimento()).dataVencimento(debitoManualParcelaDTO.getDataVencimento()).dataReferencia(LocalDate.now()).formaCorrecao(debitoManualDTO.getFormaCorrecao()).parcelado(Boolean.FALSE).situacaoLegal(SituacaoLegal.DIVIDA_ATIVA).tributo(debitoTributo.getTributo()).valor(debitoTributo.getValorTributo()).formaPagamento(formaPagamentoPadrao).divida(dividaDTO).calculaValorDesconto(Boolean.FALSE).build();
    }

    public static AcrescimoDTO of(GeraLivroDebitoParcelaTributoDTO livroParcelaTributoDTO, Divida divida, Long formaPagamentoPadrao) {
        return AcrescimoDTO.builder().entidade(livroParcelaTributoDTO.getEntidade()).exercicio(livroParcelaTributoDTO.getExercicio()).dataLancamento(livroParcelaTributoDTO.getDataLancamento()).dataPrimeiraParcela(livroParcelaTributoDTO.getDataPrimeiraParcela()).dataVencimento(livroParcelaTributoDTO.getDataVencimento()).formaCorrecao(livroParcelaTributoDTO.getFormaCorrecao()).parcelado(Boolean.valueOf(livroParcelaTributoDTO.getParcelado() != false || livroParcelaTributoDTO.getReparcelado() != false)).situacaoLegal(SituacaoLegal.DIVIDA_ATIVA).tributo(livroParcelaTributoDTO.getTributo()).valor(livroParcelaTributoDTO.getValor()).formaPagamento(formaPagamentoPadrao).divida(DividaDTO.of((Divida)divida)).build();
    }

    public BigDecimal getValorDesconto() {
        this.valorDesconto = this.valorDescontoPrincipal.add(this.valorDescontoCorrecao).add(this.valorDescontoMulta).add(this.valorDescontoJuros);
        return this.valorDesconto;
    }

    public BigDecimal getValorTotal() {
        this.valorTotal = this.valor.add(this.valorCorrecao).add(this.valorMulta).add(this.valorJuros).subtract(this.getValorDesconto());
        return this.valorTotal;
    }

    public static Builder builder() {
        return new Builder(null);
    }

    @Generated
    public AcrescimoDTO() {
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public BigDecimal getValorOriginal() {
        return this.valorOriginal;
    }

    @Generated
    public BigDecimal getValorCorrecao() {
        return this.valorCorrecao;
    }

    @Generated
    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    @Generated
    public BigDecimal getValorJuros() {
        return this.valorJuros;
    }

    @Generated
    public BigDecimal getValorDescontoPrincipal() {
        return this.valorDescontoPrincipal;
    }

    @Generated
    public BigDecimal getValorDescontoCorrecao() {
        return this.valorDescontoCorrecao;
    }

    @Generated
    public BigDecimal getValorDescontoMulta() {
        return this.valorDescontoMulta;
    }

    @Generated
    public BigDecimal getValorDescontoJuros() {
        return this.valorDescontoJuros;
    }

    @Generated
    public BigDecimal getDescontoParcelamento() {
        return this.descontoParcelamento;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public LocalDate getDataReferencia() {
        return this.dataReferencia;
    }

    @Generated
    public LocalDate getDataLancamento() {
        return this.dataLancamento;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public LocalDate getDataPrimeiraParcela() {
        return this.dataPrimeiraParcela;
    }

    @Generated
    public LocalDate getDataVencimentoOriginal() {
        return this.dataVencimentoOriginal;
    }

    @Generated
    public DividaDTO getDivida() {
        return this.divida;
    }

    @Generated
    public String getTributo() {
        return this.tributo;
    }

    @Generated
    public Long getFormaPagamento() {
        return this.formaPagamento;
    }

    @Generated
    public Long getFormaCorrecao() {
        return this.formaCorrecao;
    }

    @Generated
    public SituacaoLegal getSituacaoLegal() {
        return this.situacaoLegal;
    }

    @Generated
    public Boolean getParcelado() {
        return this.parcelado;
    }

    @Generated
    public Boolean getCalculaValorDesconto() {
        return this.calculaValorDesconto;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setValorOriginal(BigDecimal valorOriginal) {
        this.valorOriginal = valorOriginal;
    }

    @Generated
    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    @Generated
    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    @Generated
    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    @Generated
    public void setValorDescontoPrincipal(BigDecimal valorDescontoPrincipal) {
        this.valorDescontoPrincipal = valorDescontoPrincipal;
    }

    @Generated
    public void setValorDescontoCorrecao(BigDecimal valorDescontoCorrecao) {
        this.valorDescontoCorrecao = valorDescontoCorrecao;
    }

    @Generated
    public void setValorDescontoMulta(BigDecimal valorDescontoMulta) {
        this.valorDescontoMulta = valorDescontoMulta;
    }

    @Generated
    public void setValorDescontoJuros(BigDecimal valorDescontoJuros) {
        this.valorDescontoJuros = valorDescontoJuros;
    }

    @Generated
    public void setValorDesconto(BigDecimal valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    @Generated
    public void setValorTotal(BigDecimal valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Generated
    public void setDescontoParcelamento(BigDecimal descontoParcelamento) {
        this.descontoParcelamento = descontoParcelamento;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setDataReferencia(LocalDate dataReferencia) {
        this.dataReferencia = dataReferencia;
    }

    @Generated
    public void setDataLancamento(LocalDate dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setDataPrimeiraParcela(LocalDate dataPrimeiraParcela) {
        this.dataPrimeiraParcela = dataPrimeiraParcela;
    }

    @Generated
    public void setDataVencimentoOriginal(LocalDate dataVencimentoOriginal) {
        this.dataVencimentoOriginal = dataVencimentoOriginal;
    }

    @Generated
    public void setDivida(DividaDTO divida) {
        this.divida = divida;
    }

    @Generated
    public void setTributo(String tributo) {
        this.tributo = tributo;
    }

    @Generated
    public void setFormaPagamento(Long formaPagamento) {
        this.formaPagamento = formaPagamento;
    }

    @Generated
    public void setFormaCorrecao(Long formaCorrecao) {
        this.formaCorrecao = formaCorrecao;
    }

    @Generated
    public void setSituacaoLegal(SituacaoLegal situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public void setParcelado(Boolean parcelado) {
        this.parcelado = parcelado;
    }

    @Generated
    public void setCalculaValorDesconto(Boolean calculaValorDesconto) {
        this.calculaValorDesconto = calculaValorDesconto;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AcrescimoDTO)) {
            return false;
        }
        AcrescimoDTO other = (AcrescimoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        BigDecimal this$valorOriginal = this.getValorOriginal();
        BigDecimal other$valorOriginal = other.getValorOriginal();
        if (this$valorOriginal == null ? other$valorOriginal != null : !((Object)this$valorOriginal).equals(other$valorOriginal)) {
            return false;
        }
        BigDecimal this$valorCorrecao = this.getValorCorrecao();
        BigDecimal other$valorCorrecao = other.getValorCorrecao();
        if (this$valorCorrecao == null ? other$valorCorrecao != null : !((Object)this$valorCorrecao).equals(other$valorCorrecao)) {
            return false;
        }
        BigDecimal this$valorMulta = this.getValorMulta();
        BigDecimal other$valorMulta = other.getValorMulta();
        if (this$valorMulta == null ? other$valorMulta != null : !((Object)this$valorMulta).equals(other$valorMulta)) {
            return false;
        }
        BigDecimal this$valorJuros = this.getValorJuros();
        BigDecimal other$valorJuros = other.getValorJuros();
        if (this$valorJuros == null ? other$valorJuros != null : !((Object)this$valorJuros).equals(other$valorJuros)) {
            return false;
        }
        BigDecimal this$valorDescontoPrincipal = this.getValorDescontoPrincipal();
        BigDecimal other$valorDescontoPrincipal = other.getValorDescontoPrincipal();
        if (this$valorDescontoPrincipal == null ? other$valorDescontoPrincipal != null : !((Object)this$valorDescontoPrincipal).equals(other$valorDescontoPrincipal)) {
            return false;
        }
        BigDecimal this$valorDescontoCorrecao = this.getValorDescontoCorrecao();
        BigDecimal other$valorDescontoCorrecao = other.getValorDescontoCorrecao();
        if (this$valorDescontoCorrecao == null ? other$valorDescontoCorrecao != null : !((Object)this$valorDescontoCorrecao).equals(other$valorDescontoCorrecao)) {
            return false;
        }
        BigDecimal this$valorDescontoMulta = this.getValorDescontoMulta();
        BigDecimal other$valorDescontoMulta = other.getValorDescontoMulta();
        if (this$valorDescontoMulta == null ? other$valorDescontoMulta != null : !((Object)this$valorDescontoMulta).equals(other$valorDescontoMulta)) {
            return false;
        }
        BigDecimal this$valorDescontoJuros = this.getValorDescontoJuros();
        BigDecimal other$valorDescontoJuros = other.getValorDescontoJuros();
        if (this$valorDescontoJuros == null ? other$valorDescontoJuros != null : !((Object)this$valorDescontoJuros).equals(other$valorDescontoJuros)) {
            return false;
        }
        BigDecimal this$valorDesconto = this.getValorDesconto();
        BigDecimal other$valorDesconto = other.getValorDesconto();
        if (this$valorDesconto == null ? other$valorDesconto != null : !((Object)this$valorDesconto).equals(other$valorDesconto)) {
            return false;
        }
        BigDecimal this$valorTotal = this.getValorTotal();
        BigDecimal other$valorTotal = other.getValorTotal();
        if (this$valorTotal == null ? other$valorTotal != null : !((Object)this$valorTotal).equals(other$valorTotal)) {
            return false;
        }
        BigDecimal this$descontoParcelamento = this.getDescontoParcelamento();
        BigDecimal other$descontoParcelamento = other.getDescontoParcelamento();
        if (this$descontoParcelamento == null ? other$descontoParcelamento != null : !((Object)this$descontoParcelamento).equals(other$descontoParcelamento)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        LocalDate this$dataReferencia = this.getDataReferencia();
        LocalDate other$dataReferencia = other.getDataReferencia();
        if (this$dataReferencia == null ? other$dataReferencia != null : !((Object)this$dataReferencia).equals(other$dataReferencia)) {
            return false;
        }
        LocalDate this$dataLancamento = this.getDataLancamento();
        LocalDate other$dataLancamento = other.getDataLancamento();
        if (this$dataLancamento == null ? other$dataLancamento != null : !((Object)this$dataLancamento).equals(other$dataLancamento)) {
            return false;
        }
        LocalDate this$dataVencimento = this.getDataVencimento();
        LocalDate other$dataVencimento = other.getDataVencimento();
        if (this$dataVencimento == null ? other$dataVencimento != null : !((Object)this$dataVencimento).equals(other$dataVencimento)) {
            return false;
        }
        LocalDate this$dataPrimeiraParcela = this.getDataPrimeiraParcela();
        LocalDate other$dataPrimeiraParcela = other.getDataPrimeiraParcela();
        if (this$dataPrimeiraParcela == null ? other$dataPrimeiraParcela != null : !((Object)this$dataPrimeiraParcela).equals(other$dataPrimeiraParcela)) {
            return false;
        }
        LocalDate this$dataVencimentoOriginal = this.getDataVencimentoOriginal();
        LocalDate other$dataVencimentoOriginal = other.getDataVencimentoOriginal();
        if (this$dataVencimentoOriginal == null ? other$dataVencimentoOriginal != null : !((Object)this$dataVencimentoOriginal).equals(other$dataVencimentoOriginal)) {
            return false;
        }
        DividaDTO this$divida = this.getDivida();
        DividaDTO other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        String this$tributo = this.getTributo();
        String other$tributo = other.getTributo();
        if (this$tributo == null ? other$tributo != null : !this$tributo.equals(other$tributo)) {
            return false;
        }
        Long this$formaPagamento = this.getFormaPagamento();
        Long other$formaPagamento = other.getFormaPagamento();
        if (this$formaPagamento == null ? other$formaPagamento != null : !((Object)this$formaPagamento).equals(other$formaPagamento)) {
            return false;
        }
        Long this$formaCorrecao = this.getFormaCorrecao();
        Long other$formaCorrecao = other.getFormaCorrecao();
        if (this$formaCorrecao == null ? other$formaCorrecao != null : !((Object)this$formaCorrecao).equals(other$formaCorrecao)) {
            return false;
        }
        SituacaoLegal this$situacaoLegal = this.getSituacaoLegal();
        SituacaoLegal other$situacaoLegal = other.getSituacaoLegal();
        if (this$situacaoLegal == null ? other$situacaoLegal != null : !this$situacaoLegal.equals(other$situacaoLegal)) {
            return false;
        }
        Boolean this$parcelado = this.getParcelado();
        Boolean other$parcelado = other.getParcelado();
        if (this$parcelado == null ? other$parcelado != null : !((Object)this$parcelado).equals(other$parcelado)) {
            return false;
        }
        Boolean this$calculaValorDesconto = this.getCalculaValorDesconto();
        Boolean other$calculaValorDesconto = other.getCalculaValorDesconto();
        return !(this$calculaValorDesconto == null ? other$calculaValorDesconto != null : !((Object)this$calculaValorDesconto).equals(other$calculaValorDesconto));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AcrescimoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        BigDecimal $valorOriginal = this.getValorOriginal();
        result = result * 59 + ($valorOriginal == null ? 43 : ((Object)$valorOriginal).hashCode());
        BigDecimal $valorCorrecao = this.getValorCorrecao();
        result = result * 59 + ($valorCorrecao == null ? 43 : ((Object)$valorCorrecao).hashCode());
        BigDecimal $valorMulta = this.getValorMulta();
        result = result * 59 + ($valorMulta == null ? 43 : ((Object)$valorMulta).hashCode());
        BigDecimal $valorJuros = this.getValorJuros();
        result = result * 59 + ($valorJuros == null ? 43 : ((Object)$valorJuros).hashCode());
        BigDecimal $valorDescontoPrincipal = this.getValorDescontoPrincipal();
        result = result * 59 + ($valorDescontoPrincipal == null ? 43 : ((Object)$valorDescontoPrincipal).hashCode());
        BigDecimal $valorDescontoCorrecao = this.getValorDescontoCorrecao();
        result = result * 59 + ($valorDescontoCorrecao == null ? 43 : ((Object)$valorDescontoCorrecao).hashCode());
        BigDecimal $valorDescontoMulta = this.getValorDescontoMulta();
        result = result * 59 + ($valorDescontoMulta == null ? 43 : ((Object)$valorDescontoMulta).hashCode());
        BigDecimal $valorDescontoJuros = this.getValorDescontoJuros();
        result = result * 59 + ($valorDescontoJuros == null ? 43 : ((Object)$valorDescontoJuros).hashCode());
        BigDecimal $valorDesconto = this.getValorDesconto();
        result = result * 59 + ($valorDesconto == null ? 43 : ((Object)$valorDesconto).hashCode());
        BigDecimal $valorTotal = this.getValorTotal();
        result = result * 59 + ($valorTotal == null ? 43 : ((Object)$valorTotal).hashCode());
        BigDecimal $descontoParcelamento = this.getDescontoParcelamento();
        result = result * 59 + ($descontoParcelamento == null ? 43 : ((Object)$descontoParcelamento).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        LocalDate $dataReferencia = this.getDataReferencia();
        result = result * 59 + ($dataReferencia == null ? 43 : ((Object)$dataReferencia).hashCode());
        LocalDate $dataLancamento = this.getDataLancamento();
        result = result * 59 + ($dataLancamento == null ? 43 : ((Object)$dataLancamento).hashCode());
        LocalDate $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : ((Object)$dataVencimento).hashCode());
        LocalDate $dataPrimeiraParcela = this.getDataPrimeiraParcela();
        result = result * 59 + ($dataPrimeiraParcela == null ? 43 : ((Object)$dataPrimeiraParcela).hashCode());
        LocalDate $dataVencimentoOriginal = this.getDataVencimentoOriginal();
        result = result * 59 + ($dataVencimentoOriginal == null ? 43 : ((Object)$dataVencimentoOriginal).hashCode());
        DividaDTO $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        String $tributo = this.getTributo();
        result = result * 59 + ($tributo == null ? 43 : $tributo.hashCode());
        Long $formaPagamento = this.getFormaPagamento();
        result = result * 59 + ($formaPagamento == null ? 43 : ((Object)$formaPagamento).hashCode());
        Long $formaCorrecao = this.getFormaCorrecao();
        result = result * 59 + ($formaCorrecao == null ? 43 : ((Object)$formaCorrecao).hashCode());
        SituacaoLegal $situacaoLegal = this.getSituacaoLegal();
        result = result * 59 + ($situacaoLegal == null ? 43 : $situacaoLegal.hashCode());
        Boolean $parcelado = this.getParcelado();
        result = result * 59 + ($parcelado == null ? 43 : ((Object)$parcelado).hashCode());
        Boolean $calculaValorDesconto = this.getCalculaValorDesconto();
        result = result * 59 + ($calculaValorDesconto == null ? 43 : ((Object)$calculaValorDesconto).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AcrescimoDTO(valor=" + this.getValor() + ", valorOriginal=" + this.getValorOriginal() + ", valorCorrecao=" + this.getValorCorrecao() + ", valorMulta=" + this.getValorMulta() + ", valorJuros=" + this.getValorJuros() + ", valorDescontoPrincipal=" + this.getValorDescontoPrincipal() + ", valorDescontoCorrecao=" + this.getValorDescontoCorrecao() + ", valorDescontoMulta=" + this.getValorDescontoMulta() + ", valorDescontoJuros=" + this.getValorDescontoJuros() + ", valorDesconto=" + this.getValorDesconto() + ", valorTotal=" + this.getValorTotal() + ", descontoParcelamento=" + this.getDescontoParcelamento() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", dataReferencia=" + this.getDataReferencia() + ", dataLancamento=" + this.getDataLancamento() + ", dataVencimento=" + this.getDataVencimento() + ", dataPrimeiraParcela=" + this.getDataPrimeiraParcela() + ", dataVencimentoOriginal=" + this.getDataVencimentoOriginal() + ", divida=" + this.getDivida() + ", tributo=" + this.getTributo() + ", formaPagamento=" + this.getFormaPagamento() + ", formaCorrecao=" + this.getFormaCorrecao() + ", situacaoLegal=" + this.getSituacaoLegal() + ", parcelado=" + this.getParcelado() + ", calculaValorDesconto=" + this.getCalculaValorDesconto() + ")";
    }
}

