/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.Entidade;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;

public class EntidadeDTO {
    @NotNull
    private Long id;
    @Length(max=60)
    private @Length(max=60) String nome;
    @Length(max=100)
    private @Length(max=100) String logradouro;
    @Length(max=100)
    private @Length(max=100) String bairro;
    @Length(max=100)
    private @Length(max=100) String cidade;
    @Length(max=2)
    private @Length(max=2) String unidadeFederacao;
    @Length(max=10)
    private @Length(max=10) String numero;
    @Length(max=60)
    private @Length(max=60) String complemento;
    @Length(max=20)
    private @Length(max=20) String telefone;
    @Length(max=60)
    private @Length(max=60) String email;
    private Boolean principal;

    public EntidadeDTO(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getLogradouro() {
        return this.logradouro;
    }

    public void setLogradouro(String logradouro) {
        this.logradouro = logradouro;
    }

    public String getBairro() {
        return this.bairro;
    }

    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    public String getCidade() {
        return this.cidade;
    }

    public void setCidade(String cidade) {
        this.cidade = cidade;
    }

    public String getUnidadeFederacao() {
        return this.unidadeFederacao;
    }

    public void setUnidadeFederacao(String unidadeFederacao) {
        this.unidadeFederacao = unidadeFederacao;
    }

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Boolean getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Boolean principal) {
        this.principal = principal;
    }

    public EntidadeDTO atualizaBairro(String descricaoBairro) {
        this.bairro = descricaoBairro;
        return this;
    }

    public EntidadeDTO atualizaLogradouro(String descricaoLogradouro) {
        this.logradouro = descricaoLogradouro;
        return this;
    }

    public static EntidadeDTO from(Entidade entidade) {
        EntidadeDTO dto = new EntidadeDTO(entidade.getId());
        dto.nome = entidade.getNome();
        dto.unidadeFederacao = entidade.getUnidadeFederacao();
        dto.numero = entidade.getNumero();
        dto.complemento = entidade.getComplemento();
        dto.telefone = entidade.getTelefone();
        dto.email = entidade.getEmail();
        dto.principal = entidade.getPrincipal();
        Optional.ofNullable(entidade.getCidade()).ifPresent(c -> dto.setCidade(c.getDescricao()));
        return dto;
    }
}

