/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.SituacaoLegal;
import br.com.elotech.tributos.util.SituacaoDebitoUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;

public class DebitoEmAbertoDTO {
    private Long tipoCadastro;
    private Long cadastroGeral;
    private Long pessoa;
    private Long entidade;
    private Long exercicio;
    private Long divida;
    private String descricaoDivida;
    private String tributo;
    private LocalDate dataVencimento;
    private LocalDate dataLancamento;
    private LocalDate dataPrimeiraParcela;
    private Integer situacaoLegal;
    private BigDecimal valorCorrecao = BigDecimal.ZERO;
    private BigDecimal valorDescontoCorrecao = BigDecimal.ZERO;
    private BigDecimal valorDescontoJuros = BigDecimal.ZERO;
    private BigDecimal valorDescontoMulta = BigDecimal.ZERO;
    private BigDecimal valorDescontoPrincipal = BigDecimal.ZERO;
    private BigDecimal valorJuros = BigDecimal.ZERO;
    private BigDecimal valorMulta = BigDecimal.ZERO;
    private BigDecimal valorPrincipal = BigDecimal.ZERO;
    private Long formaCorrecao;
    private Long idDebito;
    private Long parcela;
    private Long idDebitoParcelaReceita;
    private Boolean parcelado;
    private Boolean reparcelado;
    private Boolean emiteBoleto;
    private Long tipoSituacaoParcela;
    private Long subDivida;
    private Long idProtesto;
    private String situacaoDebitoDescricao;
    private String situacaoDebitoSigla;
    private String noProcessoComumUnica;

    public BigDecimal getValorTotalDesconto() {
        return this.getValorDescontoPrincipal().add(this.getValorDescontoJuros()).add(this.getValorDescontoMulta()).add(this.getValorDescontoCorrecao());
    }

    public BigDecimal getValorAcrescimos() {
        return this.valorJuros.add(this.valorMulta).add(this.valorCorrecao);
    }

    public BigDecimal getValorDescontos() {
        return this.valorDescontoPrincipal.add(this.valorDescontoJuros).add(this.valorDescontoMulta).add(this.valorDescontoCorrecao);
    }

    public BigDecimal getValorTotal() {
        return this.valorPrincipal.add(this.getValorAcrescimos()).subtract(this.getValorDescontos());
    }

    public Boolean getVencido() {
        return Optional.ofNullable(this.dataVencimento).map(arg_0 -> this.isExpired(arg_0)).orElse(false);
    }

    private Boolean isExpired(LocalDate dataVencimento) {
        return LocalDate.now().isAfter(dataVencimento);
    }

    public Boolean getProtestado() {
        return Optional.ofNullable(this.idProtesto).map(arg_0 -> this.greaterThanZero(arg_0)).orElse(false);
    }

    public String getSituacao() {
        return SituacaoDebitoUtils.getDescricaoSituacao((String)this.situacaoDebitoDescricao, (SituacaoLegal)SituacaoLegal.fromValue((Integer)this.situacaoLegal), (Boolean)this.parcelado, (Boolean)this.reparcelado, (Boolean)this.getProtestado());
    }

    public String getSituacaoSigla() {
        return SituacaoDebitoUtils.getSiglaSituacao((String)this.situacaoDebitoSigla, (SituacaoLegal)SituacaoLegal.fromValue((Integer)this.situacaoLegal), (Boolean)this.parcelado, (Boolean)this.reparcelado, (Boolean)this.getProtestado());
    }

    public Boolean isAjuizadoEletronicamente() {
        return Optional.ofNullable(this.noProcessoComumUnica).map(numeroProcesso -> !numeroProcesso.isEmpty()).orElse(false);
    }

    private Boolean greaterThanZero(Long value) {
        return value > 0L;
    }

    @Generated
    public DebitoEmAbertoDTO() {
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getPessoa() {
        return this.pessoa;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getDivida() {
        return this.divida;
    }

    @Generated
    public String getDescricaoDivida() {
        return this.descricaoDivida;
    }

    @Generated
    public String getTributo() {
        return this.tributo;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public LocalDate getDataLancamento() {
        return this.dataLancamento;
    }

    @Generated
    public LocalDate getDataPrimeiraParcela() {
        return this.dataPrimeiraParcela;
    }

    @Generated
    public Integer getSituacaoLegal() {
        return this.situacaoLegal;
    }

    @Generated
    public BigDecimal getValorCorrecao() {
        return this.valorCorrecao;
    }

    @Generated
    public BigDecimal getValorDescontoCorrecao() {
        return this.valorDescontoCorrecao;
    }

    @Generated
    public BigDecimal getValorDescontoJuros() {
        return this.valorDescontoJuros;
    }

    @Generated
    public BigDecimal getValorDescontoMulta() {
        return this.valorDescontoMulta;
    }

    @Generated
    public BigDecimal getValorDescontoPrincipal() {
        return this.valorDescontoPrincipal;
    }

    @Generated
    public BigDecimal getValorJuros() {
        return this.valorJuros;
    }

    @Generated
    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    @Generated
    public BigDecimal getValorPrincipal() {
        return this.valorPrincipal;
    }

    @Generated
    public Long getFormaCorrecao() {
        return this.formaCorrecao;
    }

    @Generated
    public Long getIdDebito() {
        return this.idDebito;
    }

    @Generated
    public Long getParcela() {
        return this.parcela;
    }

    @Generated
    public Long getIdDebitoParcelaReceita() {
        return this.idDebitoParcelaReceita;
    }

    @Generated
    public Boolean getParcelado() {
        return this.parcelado;
    }

    @Generated
    public Boolean getReparcelado() {
        return this.reparcelado;
    }

    @Generated
    public Boolean getEmiteBoleto() {
        return this.emiteBoleto;
    }

    @Generated
    public Long getTipoSituacaoParcela() {
        return this.tipoSituacaoParcela;
    }

    @Generated
    public Long getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public Long getIdProtesto() {
        return this.idProtesto;
    }

    @Generated
    public String getSituacaoDebitoDescricao() {
        return this.situacaoDebitoDescricao;
    }

    @Generated
    public String getSituacaoDebitoSigla() {
        return this.situacaoDebitoSigla;
    }

    @Generated
    public String getNoProcessoComumUnica() {
        return this.noProcessoComumUnica;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setPessoa(Long pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setDivida(Long divida) {
        this.divida = divida;
    }

    @Generated
    public void setDescricaoDivida(String descricaoDivida) {
        this.descricaoDivida = descricaoDivida;
    }

    @Generated
    public void setTributo(String tributo) {
        this.tributo = tributo;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setDataLancamento(LocalDate dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    @Generated
    public void setDataPrimeiraParcela(LocalDate dataPrimeiraParcela) {
        this.dataPrimeiraParcela = dataPrimeiraParcela;
    }

    @Generated
    public void setSituacaoLegal(Integer situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    @Generated
    public void setValorDescontoCorrecao(BigDecimal valorDescontoCorrecao) {
        this.valorDescontoCorrecao = valorDescontoCorrecao;
    }

    @Generated
    public void setValorDescontoJuros(BigDecimal valorDescontoJuros) {
        this.valorDescontoJuros = valorDescontoJuros;
    }

    @Generated
    public void setValorDescontoMulta(BigDecimal valorDescontoMulta) {
        this.valorDescontoMulta = valorDescontoMulta;
    }

    @Generated
    public void setValorDescontoPrincipal(BigDecimal valorDescontoPrincipal) {
        this.valorDescontoPrincipal = valorDescontoPrincipal;
    }

    @Generated
    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    @Generated
    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    @Generated
    public void setValorPrincipal(BigDecimal valorPrincipal) {
        this.valorPrincipal = valorPrincipal;
    }

    @Generated
    public void setFormaCorrecao(Long formaCorrecao) {
        this.formaCorrecao = formaCorrecao;
    }

    @Generated
    public void setIdDebito(Long idDebito) {
        this.idDebito = idDebito;
    }

    @Generated
    public void setParcela(Long parcela) {
        this.parcela = parcela;
    }

    @Generated
    public void setIdDebitoParcelaReceita(Long idDebitoParcelaReceita) {
        this.idDebitoParcelaReceita = idDebitoParcelaReceita;
    }

    @Generated
    public void setParcelado(Boolean parcelado) {
        this.parcelado = parcelado;
    }

    @Generated
    public void setReparcelado(Boolean reparcelado) {
        this.reparcelado = reparcelado;
    }

    @Generated
    public void setEmiteBoleto(Boolean emiteBoleto) {
        this.emiteBoleto = emiteBoleto;
    }

    @Generated
    public void setTipoSituacaoParcela(Long tipoSituacaoParcela) {
        this.tipoSituacaoParcela = tipoSituacaoParcela;
    }

    @Generated
    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setIdProtesto(Long idProtesto) {
        this.idProtesto = idProtesto;
    }

    @Generated
    public void setSituacaoDebitoDescricao(String situacaoDebitoDescricao) {
        this.situacaoDebitoDescricao = situacaoDebitoDescricao;
    }

    @Generated
    public void setSituacaoDebitoSigla(String situacaoDebitoSigla) {
        this.situacaoDebitoSigla = situacaoDebitoSigla;
    }

    @Generated
    public void setNoProcessoComumUnica(String noProcessoComumUnica) {
        this.noProcessoComumUnica = noProcessoComumUnica;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebitoEmAbertoDTO)) {
            return false;
        }
        DebitoEmAbertoDTO other = (DebitoEmAbertoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$pessoa = this.getPessoa();
        Long other$pessoa = other.getPessoa();
        if (this$pessoa == null ? other$pessoa != null : !((Object)this$pessoa).equals(other$pessoa)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$divida = this.getDivida();
        Long other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !((Object)this$divida).equals(other$divida)) {
            return false;
        }
        String this$descricaoDivida = this.getDescricaoDivida();
        String other$descricaoDivida = other.getDescricaoDivida();
        if (this$descricaoDivida == null ? other$descricaoDivida != null : !this$descricaoDivida.equals(other$descricaoDivida)) {
            return false;
        }
        String this$tributo = this.getTributo();
        String other$tributo = other.getTributo();
        if (this$tributo == null ? other$tributo != null : !this$tributo.equals(other$tributo)) {
            return false;
        }
        LocalDate this$dataVencimento = this.getDataVencimento();
        LocalDate other$dataVencimento = other.getDataVencimento();
        if (this$dataVencimento == null ? other$dataVencimento != null : !((Object)this$dataVencimento).equals(other$dataVencimento)) {
            return false;
        }
        LocalDate this$dataLancamento = this.getDataLancamento();
        LocalDate other$dataLancamento = other.getDataLancamento();
        if (this$dataLancamento == null ? other$dataLancamento != null : !((Object)this$dataLancamento).equals(other$dataLancamento)) {
            return false;
        }
        LocalDate this$dataPrimeiraParcela = this.getDataPrimeiraParcela();
        LocalDate other$dataPrimeiraParcela = other.getDataPrimeiraParcela();
        if (this$dataPrimeiraParcela == null ? other$dataPrimeiraParcela != null : !((Object)this$dataPrimeiraParcela).equals(other$dataPrimeiraParcela)) {
            return false;
        }
        Integer this$situacaoLegal = this.getSituacaoLegal();
        Integer other$situacaoLegal = other.getSituacaoLegal();
        if (this$situacaoLegal == null ? other$situacaoLegal != null : !((Object)this$situacaoLegal).equals(other$situacaoLegal)) {
            return false;
        }
        BigDecimal this$valorCorrecao = this.getValorCorrecao();
        BigDecimal other$valorCorrecao = other.getValorCorrecao();
        if (this$valorCorrecao == null ? other$valorCorrecao != null : !((Object)this$valorCorrecao).equals(other$valorCorrecao)) {
            return false;
        }
        BigDecimal this$valorDescontoCorrecao = this.getValorDescontoCorrecao();
        BigDecimal other$valorDescontoCorrecao = other.getValorDescontoCorrecao();
        if (this$valorDescontoCorrecao == null ? other$valorDescontoCorrecao != null : !((Object)this$valorDescontoCorrecao).equals(other$valorDescontoCorrecao)) {
            return false;
        }
        BigDecimal this$valorDescontoJuros = this.getValorDescontoJuros();
        BigDecimal other$valorDescontoJuros = other.getValorDescontoJuros();
        if (this$valorDescontoJuros == null ? other$valorDescontoJuros != null : !((Object)this$valorDescontoJuros).equals(other$valorDescontoJuros)) {
            return false;
        }
        BigDecimal this$valorDescontoMulta = this.getValorDescontoMulta();
        BigDecimal other$valorDescontoMulta = other.getValorDescontoMulta();
        if (this$valorDescontoMulta == null ? other$valorDescontoMulta != null : !((Object)this$valorDescontoMulta).equals(other$valorDescontoMulta)) {
            return false;
        }
        BigDecimal this$valorDescontoPrincipal = this.getValorDescontoPrincipal();
        BigDecimal other$valorDescontoPrincipal = other.getValorDescontoPrincipal();
        if (this$valorDescontoPrincipal == null ? other$valorDescontoPrincipal != null : !((Object)this$valorDescontoPrincipal).equals(other$valorDescontoPrincipal)) {
            return false;
        }
        BigDecimal this$valorJuros = this.getValorJuros();
        BigDecimal other$valorJuros = other.getValorJuros();
        if (this$valorJuros == null ? other$valorJuros != null : !((Object)this$valorJuros).equals(other$valorJuros)) {
            return false;
        }
        BigDecimal this$valorMulta = this.getValorMulta();
        BigDecimal other$valorMulta = other.getValorMulta();
        if (this$valorMulta == null ? other$valorMulta != null : !((Object)this$valorMulta).equals(other$valorMulta)) {
            return false;
        }
        BigDecimal this$valorPrincipal = this.getValorPrincipal();
        BigDecimal other$valorPrincipal = other.getValorPrincipal();
        if (this$valorPrincipal == null ? other$valorPrincipal != null : !((Object)this$valorPrincipal).equals(other$valorPrincipal)) {
            return false;
        }
        Long this$formaCorrecao = this.getFormaCorrecao();
        Long other$formaCorrecao = other.getFormaCorrecao();
        if (this$formaCorrecao == null ? other$formaCorrecao != null : !((Object)this$formaCorrecao).equals(other$formaCorrecao)) {
            return false;
        }
        Long this$idDebito = this.getIdDebito();
        Long other$idDebito = other.getIdDebito();
        if (this$idDebito == null ? other$idDebito != null : !((Object)this$idDebito).equals(other$idDebito)) {
            return false;
        }
        Long this$parcela = this.getParcela();
        Long other$parcela = other.getParcela();
        if (this$parcela == null ? other$parcela != null : !((Object)this$parcela).equals(other$parcela)) {
            return false;
        }
        Long this$idDebitoParcelaReceita = this.getIdDebitoParcelaReceita();
        Long other$idDebitoParcelaReceita = other.getIdDebitoParcelaReceita();
        if (this$idDebitoParcelaReceita == null ? other$idDebitoParcelaReceita != null : !((Object)this$idDebitoParcelaReceita).equals(other$idDebitoParcelaReceita)) {
            return false;
        }
        Boolean this$parcelado = this.getParcelado();
        Boolean other$parcelado = other.getParcelado();
        if (this$parcelado == null ? other$parcelado != null : !((Object)this$parcelado).equals(other$parcelado)) {
            return false;
        }
        Boolean this$reparcelado = this.getReparcelado();
        Boolean other$reparcelado = other.getReparcelado();
        if (this$reparcelado == null ? other$reparcelado != null : !((Object)this$reparcelado).equals(other$reparcelado)) {
            return false;
        }
        Boolean this$emiteBoleto = this.getEmiteBoleto();
        Boolean other$emiteBoleto = other.getEmiteBoleto();
        if (this$emiteBoleto == null ? other$emiteBoleto != null : !((Object)this$emiteBoleto).equals(other$emiteBoleto)) {
            return false;
        }
        Long this$tipoSituacaoParcela = this.getTipoSituacaoParcela();
        Long other$tipoSituacaoParcela = other.getTipoSituacaoParcela();
        if (this$tipoSituacaoParcela == null ? other$tipoSituacaoParcela != null : !((Object)this$tipoSituacaoParcela).equals(other$tipoSituacaoParcela)) {
            return false;
        }
        Long this$subDivida = this.getSubDivida();
        Long other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !((Object)this$subDivida).equals(other$subDivida)) {
            return false;
        }
        Long this$idProtesto = this.getIdProtesto();
        Long other$idProtesto = other.getIdProtesto();
        if (this$idProtesto == null ? other$idProtesto != null : !((Object)this$idProtesto).equals(other$idProtesto)) {
            return false;
        }
        String this$situacaoDebitoDescricao = this.getSituacaoDebitoDescricao();
        String other$situacaoDebitoDescricao = other.getSituacaoDebitoDescricao();
        if (this$situacaoDebitoDescricao == null ? other$situacaoDebitoDescricao != null : !this$situacaoDebitoDescricao.equals(other$situacaoDebitoDescricao)) {
            return false;
        }
        String this$situacaoDebitoSigla = this.getSituacaoDebitoSigla();
        String other$situacaoDebitoSigla = other.getSituacaoDebitoSigla();
        if (this$situacaoDebitoSigla == null ? other$situacaoDebitoSigla != null : !this$situacaoDebitoSigla.equals(other$situacaoDebitoSigla)) {
            return false;
        }
        String this$noProcessoComumUnica = this.getNoProcessoComumUnica();
        String other$noProcessoComumUnica = other.getNoProcessoComumUnica();
        return !(this$noProcessoComumUnica == null ? other$noProcessoComumUnica != null : !this$noProcessoComumUnica.equals(other$noProcessoComumUnica));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DebitoEmAbertoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $pessoa = this.getPessoa();
        result = result * 59 + ($pessoa == null ? 43 : ((Object)$pessoa).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : ((Object)$divida).hashCode());
        String $descricaoDivida = this.getDescricaoDivida();
        result = result * 59 + ($descricaoDivida == null ? 43 : $descricaoDivida.hashCode());
        String $tributo = this.getTributo();
        result = result * 59 + ($tributo == null ? 43 : $tributo.hashCode());
        LocalDate $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : ((Object)$dataVencimento).hashCode());
        LocalDate $dataLancamento = this.getDataLancamento();
        result = result * 59 + ($dataLancamento == null ? 43 : ((Object)$dataLancamento).hashCode());
        LocalDate $dataPrimeiraParcela = this.getDataPrimeiraParcela();
        result = result * 59 + ($dataPrimeiraParcela == null ? 43 : ((Object)$dataPrimeiraParcela).hashCode());
        Integer $situacaoLegal = this.getSituacaoLegal();
        result = result * 59 + ($situacaoLegal == null ? 43 : ((Object)$situacaoLegal).hashCode());
        BigDecimal $valorCorrecao = this.getValorCorrecao();
        result = result * 59 + ($valorCorrecao == null ? 43 : ((Object)$valorCorrecao).hashCode());
        BigDecimal $valorDescontoCorrecao = this.getValorDescontoCorrecao();
        result = result * 59 + ($valorDescontoCorrecao == null ? 43 : ((Object)$valorDescontoCorrecao).hashCode());
        BigDecimal $valorDescontoJuros = this.getValorDescontoJuros();
        result = result * 59 + ($valorDescontoJuros == null ? 43 : ((Object)$valorDescontoJuros).hashCode());
        BigDecimal $valorDescontoMulta = this.getValorDescontoMulta();
        result = result * 59 + ($valorDescontoMulta == null ? 43 : ((Object)$valorDescontoMulta).hashCode());
        BigDecimal $valorDescontoPrincipal = this.getValorDescontoPrincipal();
        result = result * 59 + ($valorDescontoPrincipal == null ? 43 : ((Object)$valorDescontoPrincipal).hashCode());
        BigDecimal $valorJuros = this.getValorJuros();
        result = result * 59 + ($valorJuros == null ? 43 : ((Object)$valorJuros).hashCode());
        BigDecimal $valorMulta = this.getValorMulta();
        result = result * 59 + ($valorMulta == null ? 43 : ((Object)$valorMulta).hashCode());
        BigDecimal $valorPrincipal = this.getValorPrincipal();
        result = result * 59 + ($valorPrincipal == null ? 43 : ((Object)$valorPrincipal).hashCode());
        Long $formaCorrecao = this.getFormaCorrecao();
        result = result * 59 + ($formaCorrecao == null ? 43 : ((Object)$formaCorrecao).hashCode());
        Long $idDebito = this.getIdDebito();
        result = result * 59 + ($idDebito == null ? 43 : ((Object)$idDebito).hashCode());
        Long $parcela = this.getParcela();
        result = result * 59 + ($parcela == null ? 43 : ((Object)$parcela).hashCode());
        Long $idDebitoParcelaReceita = this.getIdDebitoParcelaReceita();
        result = result * 59 + ($idDebitoParcelaReceita == null ? 43 : ((Object)$idDebitoParcelaReceita).hashCode());
        Boolean $parcelado = this.getParcelado();
        result = result * 59 + ($parcelado == null ? 43 : ((Object)$parcelado).hashCode());
        Boolean $reparcelado = this.getReparcelado();
        result = result * 59 + ($reparcelado == null ? 43 : ((Object)$reparcelado).hashCode());
        Boolean $emiteBoleto = this.getEmiteBoleto();
        result = result * 59 + ($emiteBoleto == null ? 43 : ((Object)$emiteBoleto).hashCode());
        Long $tipoSituacaoParcela = this.getTipoSituacaoParcela();
        result = result * 59 + ($tipoSituacaoParcela == null ? 43 : ((Object)$tipoSituacaoParcela).hashCode());
        Long $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : ((Object)$subDivida).hashCode());
        Long $idProtesto = this.getIdProtesto();
        result = result * 59 + ($idProtesto == null ? 43 : ((Object)$idProtesto).hashCode());
        String $situacaoDebitoDescricao = this.getSituacaoDebitoDescricao();
        result = result * 59 + ($situacaoDebitoDescricao == null ? 43 : $situacaoDebitoDescricao.hashCode());
        String $situacaoDebitoSigla = this.getSituacaoDebitoSigla();
        result = result * 59 + ($situacaoDebitoSigla == null ? 43 : $situacaoDebitoSigla.hashCode());
        String $noProcessoComumUnica = this.getNoProcessoComumUnica();
        result = result * 59 + ($noProcessoComumUnica == null ? 43 : $noProcessoComumUnica.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DebitoEmAbertoDTO(tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", pessoa=" + this.getPessoa() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", divida=" + this.getDivida() + ", descricaoDivida=" + this.getDescricaoDivida() + ", tributo=" + this.getTributo() + ", dataVencimento=" + this.getDataVencimento() + ", dataLancamento=" + this.getDataLancamento() + ", dataPrimeiraParcela=" + this.getDataPrimeiraParcela() + ", situacaoLegal=" + this.getSituacaoLegal() + ", valorCorrecao=" + this.getValorCorrecao() + ", valorDescontoCorrecao=" + this.getValorDescontoCorrecao() + ", valorDescontoJuros=" + this.getValorDescontoJuros() + ", valorDescontoMulta=" + this.getValorDescontoMulta() + ", valorDescontoPrincipal=" + this.getValorDescontoPrincipal() + ", valorJuros=" + this.getValorJuros() + ", valorMulta=" + this.getValorMulta() + ", valorPrincipal=" + this.getValorPrincipal() + ", formaCorrecao=" + this.getFormaCorrecao() + ", idDebito=" + this.getIdDebito() + ", parcela=" + this.getParcela() + ", idDebitoParcelaReceita=" + this.getIdDebitoParcelaReceita() + ", parcelado=" + this.getParcelado() + ", reparcelado=" + this.getReparcelado() + ", emiteBoleto=" + this.getEmiteBoleto() + ", tipoSituacaoParcela=" + this.getTipoSituacaoParcela() + ", subDivida=" + this.getSubDivida() + ", idProtesto=" + this.getIdProtesto() + ", situacaoDebitoDescricao=" + this.getSituacaoDebitoDescricao() + ", situacaoDebitoSigla=" + this.getSituacaoDebitoSigla() + ", noProcessoComumUnica=" + this.getNoProcessoComumUnica() + ")";
    }
}

