/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Vinculo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;

@Entity
@Table(name="TRIBPROPRIETARIO")
@Audited
public class Proprietario
implements EloEntity<Long>,
Serializable {
    @Id
    @Column(name="idkey")
    @EloSequence(applyOnMerge=true, sequenceName="S_TRIBPROPRIETARIO_ID")
    private Long id;
    @ManyToOne
    @NotNull
    @NotAudited
    private Pessoa pessoa;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Principal")
    private Boolean principal = Boolean.FALSE;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROGERAL_IDKEY", referencedColumnName="idkey", insertable=false, updatable=false)
    @JsonIgnore
    @MetaModelIgnore
    private CadastroGeral cadastroGeral;
    @NotAudited
    @ManyToOne
    @NotNull
    private Vinculo vinculo;
    @Caption(value="Percentual")
    @Min(value=0L)
    @Max(value=100L)
    private @Min(value=0L) @Max(value=100L) BigDecimal percentual = BigDecimal.ZERO;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Co-Respons\u00e1vel Principal")
    private Boolean coResponsavelPrincipal = Boolean.FALSE;

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Proprietario)) {
            return false;
        }
        Proprietario other = (Proprietario)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Proprietario;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Proprietario(id=" + this.getId() + ", pessoa=" + this.getPessoa() + ", principal=" + this.getPrincipal() + ", cadastroGeral=" + this.getCadastroGeral() + ", vinculo=" + this.getVinculo() + ", percentual=" + this.getPercentual() + ", coResponsavelPrincipal=" + this.getCoResponsavelPrincipal() + ")";
    }

    @Generated
    public Proprietario() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public Boolean getPrincipal() {
        return this.principal;
    }

    @Generated
    public CadastroGeral getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Vinculo getVinculo() {
        return this.vinculo;
    }

    @Generated
    public BigDecimal getPercentual() {
        return this.percentual;
    }

    @Generated
    public Boolean getCoResponsavelPrincipal() {
        return this.coResponsavelPrincipal;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setPrincipal(Boolean principal) {
        this.principal = principal;
    }

    @Generated
    public void setCadastroGeral(CadastroGeral cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setVinculo(Vinculo vinculo) {
        this.vinculo = vinculo;
    }

    @Generated
    public void setPercentual(BigDecimal percentual) {
        this.percentual = percentual;
    }

    @Generated
    public void setCoResponsavelPrincipal(Boolean coResponsavelPrincipal) {
        this.coResponsavelPrincipal = coResponsavelPrincipal;
    }
}

