/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.DocumentoItemDividaAtivaId;
import br.com.elotech.tributos.domain.Livro;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.envers.AuditTable;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.envers.RelationTargetAuditMode;

@Audited
@AuditTable(value="tribdocitemdividaativa_aud")
@Entity
@Table(name="TRIBDOCUMENTOITEMDIVIDAATIVA")
public class DocumentoItemDividaAtiva
implements EloEntity<DocumentoItemDividaAtivaId>,
Serializable {
    @EmbeddedId
    private DocumentoItemDividaAtivaId id;
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @MapsId(value="entidade,exercicio,tipodocumento,documento")
    @JsonIgnore
    @MetaModelIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade"), @JoinColumn(name="exercicio", referencedColumnName="exercicio"), @JoinColumn(name="tipodocumento", referencedColumnName="tipodocumento"), @JoinColumn(name="documento", referencedColumnName="documento")})
    private Documento documento;
    private Long sequencia;
    private Long tipoCadastro;
    private Long cadastroGeral;
    @NotAudited
    @OneToOne
    @JsonIgnore
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="exercicioLivro", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="livro", referencedColumnName="livro"))})
    private Livro livro;
    private Long exercicioDebito;
    @NotAudited
    @JsonIgnore
    @MetaModelIgnore
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(formula=@JoinFormula(value="exercicioDebito", referencedColumnName="exercicio")), @JoinColumnOrFormula(formula=@JoinFormula(value="guiarecolhimento", referencedColumnName="guiarecolhimento"))})
    private Divida divida;
    @Column(name="guiarecolhimento")
    private Long codigoDivida;
    private Long subDivida;
    @Column(name="receita")
    private String tributo;
    private Long parcela;
    private BigDecimal valor = BigDecimal.ZERO;
    private BigDecimal valorJuros = BigDecimal.ZERO;
    private BigDecimal valorMulta = BigDecimal.ZERO;
    private BigDecimal valorCorrecao = BigDecimal.ZERO;
    private Long numeroInscricao;
    private Long numeroFolha;

    public BigDecimal getTotal() {
        return ((BigDecimal)ObjectUtils.defaultIfNull((Object)this.valor, (Object)BigDecimal.ZERO)).add((BigDecimal)ObjectUtils.defaultIfNull((Object)this.valorJuros, (Object)BigDecimal.ZERO)).add((BigDecimal)ObjectUtils.defaultIfNull((Object)this.valorMulta, (Object)BigDecimal.ZERO)).add((BigDecimal)ObjectUtils.defaultIfNull((Object)this.valorCorrecao, (Object)BigDecimal.ZERO));
    }

    public BigDecimal getTotalAcrescimos() {
        return ((BigDecimal)ObjectUtils.defaultIfNull((Object)this.valorJuros, (Object)BigDecimal.ZERO)).add((BigDecimal)ObjectUtils.defaultIfNull((Object)this.valorMulta, (Object)BigDecimal.ZERO)).add((BigDecimal)ObjectUtils.defaultIfNull((Object)this.valorCorrecao, (Object)BigDecimal.ZERO));
    }

    @Generated
    public DocumentoItemDividaAtiva() {
    }

    @Generated
    public DocumentoItemDividaAtivaId getId() {
        return this.id;
    }

    @Generated
    public Documento getDocumento() {
        return this.documento;
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Livro getLivro() {
        return this.livro;
    }

    @Generated
    public Long getExercicioDebito() {
        return this.exercicioDebito;
    }

    @Generated
    public Divida getDivida() {
        return this.divida;
    }

    @Generated
    public Long getCodigoDivida() {
        return this.codigoDivida;
    }

    @Generated
    public Long getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public String getTributo() {
        return this.tributo;
    }

    @Generated
    public Long getParcela() {
        return this.parcela;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public BigDecimal getValorJuros() {
        return this.valorJuros;
    }

    @Generated
    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    @Generated
    public BigDecimal getValorCorrecao() {
        return this.valorCorrecao;
    }

    @Generated
    public Long getNumeroInscricao() {
        return this.numeroInscricao;
    }

    @Generated
    public Long getNumeroFolha() {
        return this.numeroFolha;
    }

    @Generated
    public void setId(DocumentoItemDividaAtivaId id) {
        this.id = id;
    }

    @Generated
    public void setDocumento(Documento documento) {
        this.documento = documento;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setLivro(Livro livro) {
        this.livro = livro;
    }

    @Generated
    public void setExercicioDebito(Long exercicioDebito) {
        this.exercicioDebito = exercicioDebito;
    }

    @Generated
    public void setDivida(Divida divida) {
        this.divida = divida;
    }

    @Generated
    public void setCodigoDivida(Long codigoDivida) {
        this.codigoDivida = codigoDivida;
    }

    @Generated
    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setTributo(String tributo) {
        this.tributo = tributo;
    }

    @Generated
    public void setParcela(Long parcela) {
        this.parcela = parcela;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    @Generated
    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    @Generated
    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    @Generated
    public void setNumeroInscricao(Long numeroInscricao) {
        this.numeroInscricao = numeroInscricao;
    }

    @Generated
    public void setNumeroFolha(Long numeroFolha) {
        this.numeroFolha = numeroFolha;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentoItemDividaAtiva)) {
            return false;
        }
        DocumentoItemDividaAtiva other = (DocumentoItemDividaAtiva)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        DocumentoItemDividaAtivaId this$id = this.getId();
        DocumentoItemDividaAtivaId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DocumentoItemDividaAtiva;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DocumentoItemDividaAtivaId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DocumentoItemDividaAtiva(id=" + this.getId() + ")";
    }
}

