/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.converter.SituacaoCondominioConverter;
import br.com.elotech.tributos.converter.TipoCondominioConverter;
import br.com.elotech.tributos.converter.UtilizacaoCondominioConverter;
import br.com.elotech.tributos.domain.Distrito;
import br.com.elotech.tributos.domain.Setor;
import br.com.elotech.tributos.domain.SituacaoCondominio;
import br.com.elotech.tributos.domain.TipoCondominio;
import br.com.elotech.tributos.domain.UtilizacaoCondominio;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TribCondominio")
@Audited
public class Condominio
implements EloEntity<Long> {
    @Id
    @Column(name="idkey")
    @EloSequence(sequenceName="S_TRIBCONDOMINIO_ID")
    private Long id;
    @ManyToOne
    @NotNull
    @JoinColumn(name="TRIBSETOR_IDKEY")
    @NotAudited
    private Setor setor;
    @Column(name="condominio")
    @EloSequence(sequenceName="s05Condominio_#{setor.distrito.distrito}_#{setor.setor}")
    private Long condominio;
    @NotEmpty
    @Length(max=100)
    @Caption(value="Descri\u00e7\u00e3o")
    private @NotEmpty @Length(max=100) String descricao;
    @Column(name="tipo")
    @Convert(converter=TipoCondominioConverter.class)
    private TipoCondominio tipoCondominio = TipoCondominio.OUTROS;
    @Caption(value="\u00c1rea Terreno")
    @Column(scale=15, precision=2)
    private BigDecimal areaTerreno = BigDecimal.ZERO;
    @Caption(value="\u00c1rea Constru\u00edda")
    private BigDecimal areaConstruida = BigDecimal.ZERO;
    @Caption(value="\u00c1rea Privativa")
    private BigDecimal areaPrivativa = BigDecimal.ZERO;
    @Caption(value="\u00c1rea Comum")
    private BigDecimal areaComum = BigDecimal.ZERO;
    @Caption(value="N\u00famero Andares")
    private Long numeroAndares;
    @Caption(value="N\u00famero Garagem")
    private Long numeroGaragem;
    @Caption(value="N\u00famero Salas")
    private Long numeroSalas;
    @Caption(value="N\u00famero Aptos")
    private Long numeroAptos;
    @Caption(value="N\u00famero Unidades")
    private Long numeroUnidades;
    @Caption(value="N\u00famero")
    @Length(max=10)
    private @Length(max=10) String numero;
    @Caption(value="Observa\u00e7\u00e3o")
    @Length(max=1000)
    private @Length(max=1000) String observacao;
    @Caption(value="Quadra")
    @Length(max=15)
    private @Length(max=15) String quadra;
    @Caption(value="Lote")
    @Length(max=15)
    private @Length(max=15) String lote;
    @Column(name="utilizacao")
    @Convert(converter=UtilizacaoCondominioConverter.class)
    private UtilizacaoCondominio utilizacaoCondominio;
    @Caption(value="Numero Alvar\u00e1")
    @Length(max=15)
    private @Length(max=15) String numeroAlvara;
    @Caption(value="Ano Constru\u00e7\u00e3o")
    private Long anoConstrucao;
    private LocalDate dataAprovacao;
    @Caption(value="Habite-se")
    @Length(max=15)
    private @Length(max=15) String numeroHabitese;
    private LocalDate dataHabitese;
    @Column(name="situacao")
    @Convert(converter=SituacaoCondominioConverter.class)
    private SituacaoCondominio situacaoCondominio = SituacaoCondominio.NAODESMEMBRADO;
    private LocalDate dataDesmembramento;
    @Caption(value="\u00c1rea \u00c1lvara")
    private BigDecimal areaAlvara = BigDecimal.ZERO;
    @Caption(value="\u00c1rea Habitese Total")
    private BigDecimal areaHabiteseTot = BigDecimal.ZERO;
    @Caption(value="\u00c1rea Habitese Parcial")
    private BigDecimal areaHabitesePar = BigDecimal.ZERO;
    private LocalDate dataHabitesePar;
    @Caption(value="N\u00ba Habite-se Parcial")
    @Length(max=15)
    private @Length(max=15) String numeroHabitesePar;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Condominio withId(Long condominio) {
        this.setId(condominio);
        return this;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public BigDecimal getAreaTerreno() {
        return this.areaTerreno;
    }

    public void setAreaTerreno(BigDecimal areaTerreno) {
        this.areaTerreno = areaTerreno;
    }

    public BigDecimal getAreaConstruida() {
        return this.areaConstruida;
    }

    public void setAreaConstruida(BigDecimal areaConstruida) {
        this.areaConstruida = areaConstruida;
    }

    public BigDecimal getAreaPrivativa() {
        return this.areaPrivativa;
    }

    public void setAreaPrivativa(BigDecimal areaPrivativa) {
        this.areaPrivativa = areaPrivativa;
    }

    public BigDecimal getAreaComum() {
        return this.areaComum;
    }

    public void setAreaComum(BigDecimal areaComum) {
        this.areaComum = areaComum;
    }

    public Long getNumeroAndares() {
        return this.numeroAndares;
    }

    public void setNumeroAndares(Long numeroAndares) {
        this.numeroAndares = numeroAndares;
    }

    public Long getNumeroGaragem() {
        return this.numeroGaragem;
    }

    public void setNumeroGaragem(Long numeroGaragem) {
        this.numeroGaragem = numeroGaragem;
    }

    public Long getNumeroSalas() {
        return this.numeroSalas;
    }

    public void setNumeroSalas(Long numeroSalas) {
        this.numeroSalas = numeroSalas;
    }

    public Long getNumeroAptos() {
        return this.numeroAptos;
    }

    public void setNumeroAptos(Long numeroAptos) {
        this.numeroAptos = numeroAptos;
    }

    public Long getNumeroUnidades() {
        return this.numeroUnidades;
    }

    public void setNumeroUnidades(Long numeroUnidades) {
        this.numeroUnidades = numeroUnidades;
    }

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public String getQuadra() {
        return this.quadra;
    }

    public void setQuadra(String quadra) {
        this.quadra = quadra;
    }

    public String getLote() {
        return this.lote;
    }

    public void setLote(String lote) {
        this.lote = lote;
    }

    public String getNumeroAlvara() {
        return this.numeroAlvara;
    }

    public void setNumeroAlvara(String numeroAlvara) {
        this.numeroAlvara = numeroAlvara;
    }

    public Long getAnoConstrucao() {
        return this.anoConstrucao;
    }

    public void setAnoConstrucao(Long anoConstrucao) {
        this.anoConstrucao = anoConstrucao;
    }

    public LocalDate getDataAprovacao() {
        return this.dataAprovacao;
    }

    public void setDataAprovacao(LocalDate dataAprovacao) {
        this.dataAprovacao = dataAprovacao;
    }

    public String getNumeroHabitese() {
        return this.numeroHabitese;
    }

    public void setNumeroHabitese(String numeroHabitese) {
        this.numeroHabitese = numeroHabitese;
    }

    public LocalDate getDataHabitese() {
        return this.dataHabitese;
    }

    public void setDataHabitese(LocalDate dataHabitese) {
        this.dataHabitese = dataHabitese;
    }

    public LocalDate getDataDesmembramento() {
        return this.dataDesmembramento;
    }

    public void setDataDesmembramento(LocalDate dataDesmembramento) {
        this.dataDesmembramento = dataDesmembramento;
    }

    public BigDecimal getAreaAlvara() {
        return this.areaAlvara;
    }

    public void setAreaAlvara(BigDecimal areaAlvara) {
        this.areaAlvara = areaAlvara;
    }

    public BigDecimal getAreaHabiteseTot() {
        return this.areaHabiteseTot;
    }

    public void setAreaHabiteseTot(BigDecimal areaHabiteseTot) {
        this.areaHabiteseTot = areaHabiteseTot;
    }

    public BigDecimal getAreaHabitesePar() {
        return this.areaHabitesePar;
    }

    public void setAreaHabitesePar(BigDecimal areaHabitesePar) {
        this.areaHabitesePar = areaHabitesePar;
    }

    public LocalDate getDataHabitesePar() {
        return this.dataHabitesePar;
    }

    public void setDataHabitesePar(LocalDate dataHabitesePar) {
        this.dataHabitesePar = dataHabitesePar;
    }

    public String getNumeroHabitesePar() {
        return this.numeroHabitesePar;
    }

    public void setNumeroHabitesePar(String numeroHabitesePar) {
        this.numeroHabitesePar = numeroHabitesePar;
    }

    public TipoCondominio getTipoCondominio() {
        return this.tipoCondominio;
    }

    public void setTipoCondominio(TipoCondominio tipoCondominio) {
        this.tipoCondominio = tipoCondominio;
    }

    public UtilizacaoCondominio getUtilizacaoCondominio() {
        return this.utilizacaoCondominio;
    }

    public void setUtilizacaoCondominio(UtilizacaoCondominio utilizacaoCondominio) {
        this.utilizacaoCondominio = utilizacaoCondominio;
    }

    public SituacaoCondominio getSituacaoCondominio() {
        return this.situacaoCondominio;
    }

    public void setSituacaoCondominio(SituacaoCondominio situacaoCondominio) {
        this.situacaoCondominio = situacaoCondominio;
    }

    public Distrito getDistrito() {
        return this.getSetor().getDistrito();
    }

    public Setor getSetor() {
        return this.setor;
    }

    public Long getCondominio() {
        return this.condominio;
    }

    public void setSetor(Setor setor) {
        this.setor = setor;
    }

    public void setCondominio(Long condominio) {
        this.condominio = condominio;
    }

    public boolean isNew() {
        return Objects.nonNull(this.getId()) && Objects.nonNull(this.getSetor()) && Objects.nonNull(this.getCondominio());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Condominio)) {
            return false;
        }
        Condominio other = (Condominio)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Condominio;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

