/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.config;

import br.com.elotech.tributos.repository.BairroRepository;
import br.com.elotech.tributos.repository.CidadeRepository;
import br.com.elotech.tributos.repository.LogradouroRepository;
import br.com.elotech.tributos.repository.PessoaRepository;
import br.com.elotech.tributos.security.AuthenticationClientUnico;
import br.com.elotech.tributos.service.BairroService;
import br.com.elotech.tributos.service.CidadeService;
import br.com.elotech.tributos.service.LogradouroService;
import br.com.elotech.tributos.service.UnidadeFederacaoService;
import br.com.elotech.tributos.service.unico.BairroClientUnico;
import br.com.elotech.tributos.service.unico.BairroServiceUnico;
import br.com.elotech.tributos.service.unico.CidadeClientUnico;
import br.com.elotech.tributos.service.unico.CidadeServiceUnico;
import br.com.elotech.tributos.service.unico.LogradouroClientUnico;
import br.com.elotech.tributos.service.unico.LogradouroServiceUnico;
import br.com.elotech.tributos.service.unico.PessoaClientUnico;
import br.com.elotech.tributos.service.unico.PessoaServiceUnico;
import br.com.elotech.unico.client.AuthenticationClientUnicoFeign;
import br.com.elotech.unico.client.BairroFeignClient;
import br.com.elotech.unico.client.CidadeFeignClient;
import br.com.elotech.unico.client.LogradouroFeignClient;
import br.com.elotech.unico.client.PessoaFeignClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableFeignClients(value={"br.com.elotech.unico.client"})
@ConditionalOnProperty(value={"elotech.unico.enable"}, havingValue="true")
public class TributosUnicoConfiguration {
    @Bean
    public CidadeClientUnico cidadeClientUnico(CidadeFeignClient cidadeFeignClient, AuthenticationClientUnico authenticationClient) {
        return new CidadeClientUnico(cidadeFeignClient, authenticationClient);
    }

    @Bean
    public BairroClientUnico bairroClientUnico(BairroFeignClient bairroFeignClient, AuthenticationClientUnico authenticationClient) {
        return new BairroClientUnico(bairroFeignClient, authenticationClient);
    }

    @Bean
    public LogradouroClientUnico logradouroClientUnico(LogradouroFeignClient logradouroFeignClient, AuthenticationClientUnico authenticationClient) {
        return new LogradouroClientUnico(logradouroFeignClient, authenticationClient);
    }

    @Bean
    public PessoaClientUnico pessoaClientUnico(PessoaFeignClient pessoaFeignClient, AuthenticationClientUnico authenticationClient) {
        return new PessoaClientUnico(pessoaFeignClient, authenticationClient);
    }

    @Bean
    public AuthenticationClientUnico authenticationClientUnico(AuthenticationClientUnicoFeign authenticationClientUnico) {
        return new AuthenticationClientUnico(authenticationClientUnico);
    }

    @Bean
    public CidadeServiceUnico cidadeService(CidadeClientUnico cidadeClientUnico, CidadeRepository cidadeRepository, UnidadeFederacaoService unidadeFederacaoService) {
        return new CidadeServiceUnico(cidadeClientUnico, cidadeRepository, unidadeFederacaoService);
    }

    @Bean
    public BairroServiceUnico bairroService(BairroClientUnico bairroClientUnico, BairroRepository bairroRepository) {
        return new BairroServiceUnico(bairroRepository, bairroClientUnico);
    }

    @Bean
    public LogradouroServiceUnico logradouroService(LogradouroClientUnico logradouroClientUnico, LogradouroRepository logradouroRepository) {
        return new LogradouroServiceUnico(logradouroRepository, logradouroClientUnico);
    }

    @Bean
    public PessoaServiceUnico pessoaService(CidadeService cidadeService, LogradouroService logradouroService, BairroService bairroService, PessoaClientUnico pessoaClientUnico, PessoaRepository pessoaRepository) {
        return new PessoaServiceUnico(pessoaRepository, cidadeService, logradouroService, bairroService, pessoaClientUnico);
    }
}

