/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;

@Configuration
public class KeycloakClientConfiguration {
    @Value(value="${keycloak.configurationFile}")
    private Resource keycloakConfigurationFile;

    @Bean
    public Keycloak keycloakAdminClient(KeycloakDeployment deployment) {
        ResteasyClient restEasy = new ResteasyClientBuilder().connectionPoolSize(20).socketTimeout(30L, TimeUnit.SECONDS).establishConnectionTimeout(1L, TimeUnit.MINUTES).connectionCheckoutTimeout(30L, TimeUnit.SECONDS).build();
        return KeycloakBuilder.builder().clientId(deployment.getResourceName()).clientSecret(deployment.getResourceCredentials().get("secret").toString()).realm(deployment.getRealm()).grantType("client_credentials").serverUrl(deployment.getAuthServerBaseUrl()).resteasyClient(restEasy).build();
    }

    @Bean
    public KeycloakDeployment keycloakDeployment() throws IOException {
        return KeycloakDeploymentBuilder.build((InputStream)this.keycloakConfigurationFile.getInputStream());
    }
}

