/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.Set;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.configuration.ListableJobLocator;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.explore.support.JobExplorerFactoryBean;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.batch.core.launch.support.SimpleJobOperator;
import org.springframework.batch.core.repository.ExecutionContextSerializer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.dao.Jackson2ExecutionContextStringSerializer;
import org.springframework.batch.core.repository.support.JobRepositoryFactoryBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableBatchProcessing
public class BatchConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchConfiguration.class);

    @Bean
    public JobLauncher jobLauncher(JobRepository jobRepository, TaskExecutor taskExecutor) {
        SimpleJobLauncher jobLauncher = new SimpleJobLauncher();
        jobLauncher.setJobRepository(jobRepository);
        jobLauncher.setTaskExecutor(taskExecutor);
        return jobLauncher;
    }

    @Bean
    public TaskExecutor taskExecutor() {
        SimpleAsyncTaskExecutor taskExecutor = new SimpleAsyncTaskExecutor();
        taskExecutor.setDaemon(true);
        taskExecutor.setThreadPriority(1);
        return taskExecutor;
    }

    @Bean
    public JobRepository jobRepository(ObjectMapper objectMapper, DataSource dataSource, PlatformTransactionManager transactionManager) throws Exception {
        Jackson2ExecutionContextStringSerializer serializer = new Jackson2ExecutionContextStringSerializer();
        serializer.setObjectMapper(objectMapper);
        JobRepositoryFactoryBean jobRepositoryFactoryBean = new JobRepositoryFactoryBean();
        jobRepositoryFactoryBean.setSerializer((ExecutionContextSerializer)serializer);
        jobRepositoryFactoryBean.setDataSource(dataSource);
        jobRepositoryFactoryBean.setIsolationLevelForCreate("ISOLATION_READ_COMMITTED");
        jobRepositoryFactoryBean.setTransactionManager(transactionManager);
        jobRepositoryFactoryBean.afterPropertiesSet();
        return jobRepositoryFactoryBean.getObject();
    }

    @Bean
    public JobExplorer jobExplorer(ObjectMapper objectMapper, DataSource dataSource) throws Exception {
        JobExplorerFactoryBean factoryBean = new JobExplorerFactoryBean();
        Jackson2ExecutionContextStringSerializer serializer = new Jackson2ExecutionContextStringSerializer();
        serializer.setObjectMapper(objectMapper);
        factoryBean.setDataSource(dataSource);
        factoryBean.setSerializer((ExecutionContextSerializer)serializer);
        factoryBean.afterPropertiesSet();
        return factoryBean.getObject();
    }

    @Bean
    public JobOperator jobOperator(JobLauncher jobLauncher, JobRepository jobRepository, JobRegistry jobRegistry, JobExplorer jobExplorer) {
        SimpleJobOperator jobOperator = new SimpleJobOperator();
        jobOperator.setJobLauncher(jobLauncher);
        jobOperator.setJobRepository(jobRepository);
        jobOperator.setJobRegistry((ListableJobLocator)jobRegistry);
        jobOperator.setJobExplorer(jobExplorer);
        return jobOperator;
    }

    @Bean
    @ConditionalOnProperty(value={"elotech.batch.stop-running-jobs-on-start"}, havingValue="true")
    public ApplicationListener<ContextRefreshedEvent> invalidateRunningJobsListener(JobRepository jobRepository, JobExplorer jobExplorer) {
        return event -> jobExplorer.getJobNames().forEach(jobName -> {
            Set runningJobExecutions = jobExplorer.findRunningJobExecutions(jobName);
            if (!runningJobExecutions.isEmpty()) {
                LOGGER.info("Foram encontrados {} job executions pendentes para o job {}.", (Object)runningJobExecutions.size(), jobName);
            }
            runningJobExecutions.forEach(jobExecution -> {
                if (BatchStatus.STARTED.equals((Object)jobExecution.getStatus())) {
                    jobExecution.setEndTime(new Date());
                    jobExecution.setStatus(BatchStatus.FAILED);
                    jobExecution.setExitStatus(ExitStatus.FAILED);
                    jobExecution.getStepExecutions().forEach(stepExecution -> {
                        if (BatchStatus.STARTED.equals((Object)stepExecution.getStatus())) {
                            stepExecution.setEndTime(new Date());
                            stepExecution.setStatus(BatchStatus.FAILED);
                            stepExecution.setExitStatus(ExitStatus.FAILED);
                            jobRepository.update(stepExecution);
                        }
                    });
                    LOGGER.info("Setando o job execution {} para FAILED pois ele n\u00e3o foi finalizado anteriormente.", (Object)jobExecution.getId());
                    jobRepository.update(jobExecution);
                }
            });
        });
    }
}

