/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.createlivrodividaativa;

import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.Livro;
import br.com.elotech.tributos.domain.LivroRegistro;
import br.com.elotech.tributos.dto.dividaativa.FiltroGeraLivroDTO;
import br.com.elotech.tributos.dto.dividaativa.GeraLivroDebitoParcelaTributoDTO;
import br.com.elotech.tributos.dto.dividaativa.LivroExistenteSequenciadoresDTO;
import br.com.elotech.tributos.repository.GeraLivroRepository;
import br.com.elotech.tributos.repository.LivroRegistroRepository;
import br.com.elotech.tributos.service.GeraLivroDividaAtivaBatchService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class LivroDividaAtivaBatchProcessor
implements ItemProcessor<Long, Map<LivroRegistro, List<GeraLivroDebitoParcelaTributoDTO>>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LivroDividaAtivaBatchProcessor.class);
    private StepExecution stepExecution;
    private final GeraLivroDividaAtivaBatchService geraLivroDividaAtivaBatchService;
    private final GeraLivroRepository geraLivroRepository;
    private final LivroRegistroRepository livroRegistroRepository;

    public LivroDividaAtivaBatchProcessor(GeraLivroDividaAtivaBatchService geraLivroDividaAtivaBatchService, GeraLivroRepository geraLivroRepository, LivroRegistroRepository livroRegistroRepository) {
        this.geraLivroDividaAtivaBatchService = geraLivroDividaAtivaBatchService;
        this.geraLivroRepository = geraLivroRepository;
        this.livroRegistroRepository = livroRegistroRepository;
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public Map<LivroRegistro, List<GeraLivroDebitoParcelaTributoDTO>> process(Long idDebito) {
        LOGGER.info("Read Count: {}. idDebito: {}. Job ID {}.", new Object[]{this.stepExecution.getReadCount(), idDebito, this.stepExecution.getJobExecution().getId()});
        ExecutionContext executionContext = this.stepExecution.getJobExecution().getExecutionContext();
        Livro livro = (Livro)executionContext.get("livro");
        LOGGER.info("Livro {}", (Object)livro.getId().getLivro());
        FiltroGeraLivroDTO filtro = (FiltroGeraLivroDTO)executionContext.get("filtro");
        Boolean inscricaoPorParcela = (Boolean)executionContext.get("inscricaoPorParcela");
        Boolean englobaDebitos = (Boolean)executionContext.get("englobaDebitos");
        FormaPagamento formaPagamentoPadrao = (FormaPagamento)executionContext.get("formaPagamentoPadrao");
        String filtroComIDDebito = String.format(" and (td.iddebito = %d) %s", idDebito, filtro.getFiltro(inscricaoPorParcela));
        List parcelaTributos = this.geraLivroRepository.getParcelaTributos(filtroComIDDebito);
        this.geraLivroDividaAtivaBatchService.calculaAcrescimo(parcelaTributos, englobaDebitos, livro.getDataInclusao(), formaPagamentoPadrao);
        LivroExistenteSequenciadoresDTO sequenciadores = this.geraLivroRepository.getLastLivroExistenteSequenciadores(livro.getId());
        Long numeroRegistroFolha = livro.getNumeroRegistroFolha();
        HashMap<LivroRegistro, List<GeraLivroDebitoParcelaTributoDTO>> parcelasToUpdate = new HashMap<LivroRegistro, List<GeraLivroDebitoParcelaTributoDTO>>();
        List livroRegistros = inscricaoPorParcela != false ? this.geraLivroDividaAtivaBatchService.getRegistrosByInscricaoPorParcela(livro, parcelaTributos, numeroRegistroFolha, parcelasToUpdate, sequenciadores) : this.geraLivroDividaAtivaBatchService.getRegistrosByInscricaoPorDebito(livro, parcelaTributos, numeroRegistroFolha, parcelasToUpdate, sequenciadores, formaPagamentoPadrao, englobaDebitos);
        this.livroRegistroRepository.saveAll((Iterable)livroRegistros);
        LOGGER.info("Read Count: {}. {} registros adicionados no livro {}.", new Object[]{this.stepExecution.getReadCount(), livroRegistros.size(), livro.getId().getLivro()});
        return parcelasToUpdate;
    }
}

