/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.baixaautomatica;

import br.com.elotech.tributos.batch.DefaultItemFailureListener;
import br.com.elotech.tributos.batch.baixaautomatica.BaixaAutomaticaBatchProcessor;
import br.com.elotech.tributos.batch.baixaautomatica.BaixaAutomaticaBatchReader;
import br.com.elotech.tributos.batch.baixaautomatica.BaixaAutomaticaBatchWriter;
import br.com.elotech.tributos.batch.baixaautomatica.BaixaAutomaticaJobListener;
import br.com.elotech.tributos.domain.JobType;
import org.springframework.batch.core.ItemProcessListener;
import org.springframework.batch.core.ItemReadListener;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.JobParametersValidator;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.DuplicateJobException;
import org.springframework.batch.core.configuration.JobFactory;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.configuration.support.ReferenceJobFactory;
import org.springframework.batch.core.job.DefaultJobParametersValidator;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BaixaAutomaticaBatchConfig {
    @Qualifier(value="baixaAutomaticaBatchJob")
    @Bean
    public Job baixaAutomaticaBatchJob(JobBuilderFactory jobBuilderFactory, JobRegistry jobRegistry, BaixaAutomaticaJobListener listener, Step baixaAutomaticaStep) throws DuplicateJobException {
        DefaultJobParametersValidator validator = new DefaultJobParametersValidator();
        validator.setRequiredKeys(new String[]{"entidade", "exercicio", "lote", "user-aise", "user-id"});
        Job baixaAutomaticaJob = ((JobBuilder)((JobBuilder)((JobBuilder)jobBuilderFactory.get(JobType.BAIXA_AUTOMATICA.getTipo()).validator((JobParametersValidator)validator)).listener((JobExecutionListener)listener)).incrementer((JobParametersIncrementer)new RunIdIncrementer())).start(baixaAutomaticaStep).build();
        ReferenceJobFactory referenceJobFactory = new ReferenceJobFactory(baixaAutomaticaJob);
        jobRegistry.register((JobFactory)referenceJobFactory);
        return baixaAutomaticaJob;
    }

    @Bean
    public Step baixaAutomaticaStep(StepBuilderFactory stepBuilderFactory, BaixaAutomaticaBatchProcessor processor, BaixaAutomaticaBatchReader reader, BaixaAutomaticaBatchWriter writer) {
        DefaultItemFailureListener defaultItemFailureListener = new DefaultItemFailureListener();
        return stepBuilderFactory.get("baixaAutomaticaStep").chunk(1).reader((ItemReader)reader).processor((ItemProcessor)processor).writer((ItemWriter)writer).listener((ItemReadListener)defaultItemFailureListener).listener((ItemProcessListener)defaultItemFailureListener).listener((ItemWriteListener)defaultItemFailureListener).build();
    }
}

