/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.ws.function;

import br.com.elotech.tributos.params.CertidaoParams;
import br.com.elotech.tributos.ws.domain.GeraCertidaoEnvio;
import java.util.function.Function;

public class CertidaoParamsToGeraCertidaoEnvio
implements Function<CertidaoParams, GeraCertidaoEnvio> {
    private static final String SOMENTE_DIGITOS = "\\D+";
    private static final String PESSOA_FISICA = "F";
    private static final String PESSOA_JURIDICA = "J";

    @Override
    public GeraCertidaoEnvio apply(CertidaoParams params) {
        GeraCertidaoEnvio wsParams = new GeraCertidaoEnvio();
        wsParams.setTipoCadastro(params.getTipoCadastro());
        wsParams.setCadastroGeral(params.getCadastroGeral());
        this.setCnpjCpf(params, wsParams);
        this.setCpfRequerente(params, wsParams);
        wsParams.setTipoRequerente(params.getTipoPessoaRequerente());
        wsParams.setRequerente(params.getNomeRequerente());
        wsParams.setFinalidade(params.getFinalidade().getSequencia());
        wsParams.setFinalidadeOutros(params.getFinalidadeOutros());
        wsParams.setExercicio(params.getFinalidade().getExercicio());
        wsParams.setTipoDocumento(params.getFinalidade().getTipoDocumento());
        wsParams.setDocumento(params.getDocumento());
        return wsParams;
    }

    private void setCpfRequerente(CertidaoParams params, GeraCertidaoEnvio wsParams) {
        if (PESSOA_FISICA.equals(params.getTipoPessoaRequerente())) {
            wsParams.setCpfRequerente(params.getCpfRequerente().replaceAll(SOMENTE_DIGITOS, ""));
        } else if (PESSOA_JURIDICA.equals(params.getTipoPessoaRequerente())) {
            wsParams.setCpfRequerente(params.getCnpjRequerente().replaceAll(SOMENTE_DIGITOS, ""));
        }
    }

    private void setCnpjCpf(CertidaoParams params, GeraCertidaoEnvio wsParams) {
        if (PESSOA_FISICA.equals(params.getTipoPessoa()) && params.getCpf() != null) {
            wsParams.setCnpjCpf(params.getCpf().replaceAll(SOMENTE_DIGITOS, ""));
        } else if (PESSOA_JURIDICA.equals(params.getTipoPessoa()) && params.getCnpj() != null) {
            wsParams.setCnpjCpf(params.getCnpj().replaceAll(SOMENTE_DIGITOS, ""));
        } else {
            wsParams.setCnpjCpf(" ");
        }
    }
}

