/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.validator;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.validation.CustomValidator;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.EntidadeTributacaoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class SetorValidator
implements CustomValidator<CadastroImobiliario> {
    private final ParametroGeralService parametroGeralService;
    private final EntidadeTributacaoService entidadeTributacaoService;
    private final ContextService contextService;

    public SetorValidator(ParametroGeralService parametroGeralService, EntidadeTributacaoService entidadeTributacaoService, ContextService contextService) {
        this.parametroGeralService = parametroGeralService;
        this.entidadeTributacaoService = entidadeTributacaoService;
        this.contextService = contextService;
    }

    public boolean supports(Class<?> clazz) {
        return CadastroImobiliario.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        if (this.validaZonaCadastro().booleanValue()) {
            CadastroImobiliario cadastroImobiliario = (CadastroImobiliario)target;
            String setorDoCadastroGeral = this.extractSetorByCadastroGeral(cadastroImobiliario.getCadastroGeral());
            String setorInformado = cadastroImobiliario.getSetorInscricaoCadastral().getSetor();
            if (!setorInformado.equals(setorDoCadastroGeral)) {
                errors.reject("Setor diferente", "A Zona informada " + setorInformado + ", difere do in\u00edcio do cadastro " + setorDoCadastroGeral);
            }
        }
    }

    private String extractSetorByCadastroGeral(Long cadastroGeral) {
        return String.format("%0".concat(this.tamanhoCadastroImob()).concat("d"), cadastroGeral).substring(0, this.tamanhoSetor());
    }

    private Integer tamanhoSetor() {
        return this.entidadeTributacaoService.findTamanhoSetorByEntidadeAndExercicio(this.contextService.getEntidadePrincipal(), this.contextService.getExercicioAtual()).intValue();
    }

    private Boolean validaZonaCadastro() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VALIDA_ZONA_CADASTRO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    private String tamanhoCadastroImob() {
        return this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.TAMANHO_CAD_IMOBILIARIO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }
}

