/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.validator;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.core.validation.CustomValidator;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.repository.PessoaRepository;
import br.com.elotech.tributos.service.ParametroGeralService;
import com.google.common.base.Strings;
import java.util.Objects;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class PessoaValidator
implements CustomValidator<CadastroImobiliario> {
    private final ParametroGeralService parametroGeralService;
    private final PessoaRepository pessoaRepository;

    public PessoaValidator(ParametroGeralService parametroGeralService, PessoaRepository pessoaRepository) {
        this.parametroGeralService = parametroGeralService;
        this.pessoaRepository = pessoaRepository;
    }

    public boolean supports(Class<?> clazz) {
        return CadastroImobiliario.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        if (this.validaProprietarioImobiliario().booleanValue()) {
            CadastroImobiliario cadastroImobiliario = (CadastroImobiliario)target;
            Pessoa pessoa = (Pessoa)this.pessoaRepository.findOne((Object)cadastroImobiliario.getPessoa().getId());
            this.validaTipoEndereco(errors, pessoa);
            this.validaCidade(errors, pessoa);
            this.validaLogradouro(errors, pessoa);
            this.validaBairro(errors, pessoa);
            this.validaNumero(errors, pessoa);
            this.validaCnpjCpf(errors, pessoa);
            this.validaRG(errors, pessoa);
        }
    }

    private void validaRG(Errors errors, Pessoa pessoa) {
        if (pessoa.getTipoPessoa() == TipoPessoa.FISICA && Strings.isNullOrEmpty((String)pessoa.getRg())) {
            errors.reject("RG inv\u00e1lido", "O RG do Contribuinte deve ser informado");
        }
    }

    private void validaCnpjCpf(Errors errors, Pessoa pessoa) {
        if (Strings.isNullOrEmpty((String)pessoa.getCnpjCpf())) {
            errors.reject("CNPJ_CPF inv\u00e1lido", "O CNPJ_CPF do Contribuinte deve ser informado");
        }
    }

    private void validaNumero(Errors errors, Pessoa pessoa) {
        if (Strings.isNullOrEmpty((String)pessoa.getEnderecoPrincipal().getNumero())) {
            errors.reject("N\u00famero do Endereco inv\u00e1lido", "O N\u00famero do Endere\u00e7o do Contribuinte deve ser informado");
        }
    }

    private void validaBairro(Errors errors, Pessoa pessoa) {
        if (Objects.isNull(pessoa.getEnderecoPrincipal().getBairro()) || pessoa.getEnderecoPrincipal().getBairro().getBairro() <= 0L) {
            errors.reject("Bairro inv\u00e1lido", "O Bairro do Endere\u00e7o do Contribuinte deve ser informado");
        }
    }

    private void validaLogradouro(Errors errors, Pessoa pessoa) {
        if (Objects.isNull(pessoa.getEnderecoPrincipal().getLogradouro()) || pessoa.getEnderecoPrincipal().getLogradouro().getLogradouro() <= 0L) {
            errors.reject("Logradouro inv\u00e1lido", "O Logradouro do Endere\u00e7o do Contribuinte deve ser informado");
        }
    }

    private void validaCidade(Errors errors, Pessoa pessoa) {
        if (Objects.isNull(pessoa.getEnderecoPrincipal().getCidade()) || pessoa.getEnderecoPrincipal().getCidade().getId() <= 0L) {
            errors.reject("Cidade inv\u00e1lida", "A Cidade do Endere\u00e7o do Contribuinte deve ser informado");
        }
    }

    private void validaTipoEndereco(Errors errors, Pessoa pessoa) {
        if (Objects.isNull(pessoa.getEnderecoPrincipal().getTipoEndereco()) || pessoa.getEnderecoPrincipal().getTipoEndereco().getValue() <= 0L) {
            errors.reject("Tipo Endere\u00e7o inv\u00e1lido", "O Tipo de Endere\u00e7o do Contribuinte deve ser informado");
        }
    }

    private Boolean validaProprietarioImobiliario() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VALIDA_PROPRIETARIO_IMOBILIARIO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }
}

