/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.validator;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.validation.CustomValidator;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioAreaVerde;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.validator.CadastroGeralValidator;
import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class CadastroImobiliarioValidator
implements CustomValidator<CadastroImobiliario> {
    private static final String LATITUDE_INVALIDA = "Latitude Inv\u00e1lida";
    private static final String LONGITUDE_INVALIDA = "Longitude Inv\u00e1lida";
    private static final String COORDENADA_INVALIDA = "Coordenada inv\u00e1lida. Preencha todos os campos";
    private static final int MAXIMA_LONGITUDE = 180;
    private static final int MAXIMA_LATITUDE = 90;
    private final ParametroGeralService parametroGeralService;

    public CadastroImobiliarioValidator(ParametroGeralService parametroGeralService) {
        this.parametroGeralService = parametroGeralService;
    }

    public boolean supports(Class<?> clazz) {
        return CadastroImobiliario.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        CadastroImobiliario cadastroImobiliario = (CadastroImobiliario)target;
        if (cadastroImobiliario.getBoletinsImobiliarioTerreno().isEmpty()) {
            errors.reject("Boletim Terreno sem respostas", "Dados do terreno n\u00e3o fornecidos. \u00c9 obrigat\u00f3rio informar os dados do terreno");
        }
        if (this.parametroValidaAreaCondominio()) {
            this.validaAreaLote(errors, cadastroImobiliario);
        }
        this.validaLongitude(errors, cadastroImobiliario);
        this.validaLatitude(errors, cadastroImobiliario);
        this.validaTerrenoAndExistsBoletimResposta(errors, cadastroImobiliario);
        this.validaCadastroGeral(errors, cadastroImobiliario);
    }

    private void validaLongitude(Errors errors, CadastroImobiliario cadastroImobiliario) {
        Character direcao;
        String longitude = cadastroImobiliario.getLongitude();
        if (Strings.isNullOrEmpty((String)longitude) || longitude.indexOf(34) < 0) {
            errors.reject(LONGITUDE_INVALIDA, COORDENADA_INVALIDA);
            return;
        }
        int grau = 0;
        if (!longitude.substring(0, longitude.indexOf(186)).isEmpty()) {
            grau = Integer.parseInt(longitude.substring(0, longitude.indexOf(186)));
        }
        if (grau < 0 || grau > 180) {
            errors.reject(LONGITUDE_INVALIDA, "A longitude deve estar entre 0 (zero) e 180 (cento e oitenta) graus e foi informado " + grau);
        }
        if (!(direcao = Character.valueOf(longitude.charAt(longitude.length() - 1))).equals(Character.valueOf('E')) && !direcao.equals(Character.valueOf('W'))) {
            errors.reject(LONGITUDE_INVALIDA, "A dire\u00e7\u00e3o informada \u00e9 inv\u00e1lida. S\u00e3o aceitos 'E' (Leste/Este) e 'W' (Oeste) ");
        }
    }

    private void validaLatitude(Errors errors, CadastroImobiliario cadastroImobiliario) {
        Character direcao;
        String latitude = cadastroImobiliario.getLatitude();
        if (Strings.isNullOrEmpty((String)latitude) || latitude.indexOf(34) < 0) {
            errors.reject(LATITUDE_INVALIDA, COORDENADA_INVALIDA);
            return;
        }
        int grau = 0;
        if (!latitude.substring(0, latitude.indexOf(186)).isEmpty()) {
            grau = Integer.parseInt(latitude.substring(0, latitude.indexOf(186)));
        }
        if (grau < 0 || grau > 90) {
            errors.reject(LATITUDE_INVALIDA, "A latitude deve estar entre 0 (zero) e 90 (noventa) graus e foi informado " + grau);
        }
        if (!(direcao = Character.valueOf(latitude.charAt(latitude.length() - 1))).equals(Character.valueOf('N')) && !direcao.equals(Character.valueOf('S'))) {
            errors.reject(LATITUDE_INVALIDA, "A dire\u00e7\u00e3o informada \u00e9 inv\u00e1lida. S\u00e3o aceitos 'N' (Norte) e 'S' (Sul) ");
        }
    }

    private void validaAreaLote(Errors errors, CadastroImobiliario cadastroImobiliario) {
        BigDecimal areaVerde = cadastroImobiliario.getCadastroImobiliarioAreasVerde().stream().map(CadastroImobiliarioAreaVerde::getArea).reduce(BigDecimal::add).get();
        BigDecimal somaArea = areaVerde.add(cadastroImobiliario.getAreaUtilLote());
        if (!somaArea.equals(cadastroImobiliario.getAreaLote())) {
            errors.reject("\u00c1rea Lote divergente", "A soma dos valores para Area \u00datil (" + cadastroImobiliario.getAreaUtilLote().toString() + ") + \u00c1rea Verde (" + areaVerde.toString() + ") deve ser igual ao valor informado como \u00c1rea do Lote (" + cadastroImobiliario.getAreaLote() + ").");
        }
    }

    private void validaTerrenoAndExistsBoletimResposta(Errors errors, CadastroImobiliario cadastroImobiliario) {
        if (cadastroImobiliario.getTipoImovel().isTerritorial().booleanValue() && this.existsBoletimSegmento(cadastroImobiliario)) {
            errors.reject("Segmento com respostas inv\u00e1lidas", "Caso o Tipo de im\u00f3vel for 'Territorial', n\u00e3o pode existir respostas para os segmentos");
        }
    }

    private boolean existsBoletimSegmento(CadastroImobiliario cadastroImobiliario) {
        return cadastroImobiliario.getCadastroImobiliarioSegmentos().stream().filter(segmento -> segmento.getBoletinsImobiliarioSegmento().size() > 0).findFirst().isPresent();
    }

    private void validaCadastroGeral(Errors errors, CadastroImobiliario cadastroGeral) {
        CadastroGeralValidator.validaCepCadastro((Errors)errors, (Long)cadastroGeral.getCep(), (Boolean)this.validaCepCadastro());
        CadastroGeralValidator.validaEnderecoEntregaCarneAnual((Errors)errors, (CadastroGeral)cadastroGeral);
        CadastroGeralValidator.validaPessoaIgualProprietarioPrincipal((Errors)errors, (CadastroGeral)cadastroGeral);
        CadastroGeralValidator.validaProprietarioPrincipal((Errors)errors, (List)cadastroGeral.getProprietarios());
        CadastroGeralValidator.validaTamanhoCadastroGeral((Errors)errors, (Long)cadastroGeral.getCadastroGeral(), (Long)this.tamanhoCadastroGeral());
    }

    private Long tamanhoCadastroGeral() {
        return this.parametroGeralService.getParamValueAsLong(ParametroGeralEnum.TAMANHO_CAD_IMOBILIARIO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    private Boolean validaCepCadastro() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VALIDA_CEP_CADASTRO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    private boolean parametroValidaAreaCondominio() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VALIDA_AREA_CONDOMINIO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }
}

