/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.specs;

import br.com.elotech.tributos.domain.Documento;
import java.io.Serializable;
import java.time.LocalDate;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import org.springframework.data.jpa.domain.Specification;

public final class DocumentoSpecifications {
    private static final String CNPJ_CPF = "cnpjCpf";
    private static final String POR_CADASTRO_GERAL = "porCadastroGeral";
    private static final String DATA_VALIDADE = "dataValidade";
    private static final String IMPRESSAO_WEB = "impressaoWeb";
    private static final String PESSOA = "pessoa";
    private static final String PROPRIETARIOS = "proprietarios";
    private static final String CADASTRO_GERAL = "cadastroGeral";
    private static final String TIPO_DOCUMENTO = "tipoDocumento";
    private static final String CANCELADO = "cancelado";

    private DocumentoSpecifications() {
    }

    public static Specification<Documento> byImprimeWebAndCpfCnpjAndDataValidade(String cpfCnpj, LocalDate dataValidade) {
        return (Specification & Serializable)(root, query, criteriaBuilder) -> {
            Join tipoDocumento = root.join(TIPO_DOCUMENTO, JoinType.LEFT);
            Join cadastroGeral = root.join(CADASTRO_GERAL, JoinType.LEFT);
            Join proprietarios = cadastroGeral.join(PROPRIETARIOS, JoinType.LEFT);
            Join pessoaProprietario = proprietarios.join(PESSOA, JoinType.LEFT);
            return criteriaBuilder.and(new Predicate[]{criteriaBuilder.isFalse((Expression)root.get(CANCELADO)), criteriaBuilder.isTrue((Expression)tipoDocumento.get(IMPRESSAO_WEB)), criteriaBuilder.or((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(DATA_VALIDADE), (Comparable)dataValidade)}), (Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.isNull((Expression)root.get(DATA_VALIDADE))})), criteriaBuilder.or((Expression)criteriaBuilder.and((Expression)criteriaBuilder.isTrue((Expression)tipoDocumento.get(POR_CADASTRO_GERAL)), (Expression)criteriaBuilder.equal((Expression)pessoaProprietario.get(CNPJ_CPF), (Object)cpfCnpj)), (Expression)criteriaBuilder.and((Expression)criteriaBuilder.isFalse((Expression)tipoDocumento.get(POR_CADASTRO_GERAL)), (Expression)criteriaBuilder.equal((Expression)root.get(CNPJ_CPF), (Object)cpfCnpj)))});
        };
    }
}

