/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.rest;

import br.com.elotech.tributos.config.TributosProperties;
import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.dto.DebitoHandler;
import br.com.elotech.tributos.service.DebitoCpfService;
import br.com.elotech.tributos.service.ws.rest.AiseLoginServiceRest;
import br.com.elotech.tributos.ws.domain.LoginRespostaRest;
import br.com.elotech.tributos.ws.rest.dto.DebitoMapper;
import br.com.elotech.tributos.ws.rest.dto.DebitoTransportDTO;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AiseDebitoCpfServiceRest
implements DebitoCpfService {
    private final RestTemplate restTemplate;
    private final TributosProperties tributosProperties;
    private final AiseLoginServiceRest aiseLoginServiceRest;
    private final DebitoMapper debitoMapper;

    public AiseDebitoCpfServiceRest(RestTemplate restTemplate, TributosProperties tributosProperties, AiseLoginServiceRest aiseLoginServiceRest, DebitoMapper debitoMapper) {
        this.restTemplate = restTemplate;
        this.tributosProperties = tributosProperties;
        this.aiseLoginServiceRest = aiseLoginServiceRest;
        this.debitoMapper = debitoMapper;
    }

    public List<DebitoDTO> getDebitosCpf(String cpf) {
        DebitoTransportDTO delphiDTO = this.getDebitosEmAbertoPorCpf(cpf);
        return delphiDTO.getList().getItems().stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoDTO(arg_0)).collect(Collectors.toList());
    }

    private DebitoTransportDTO getDebitosEmAbertoPorCpf(String cpf) {
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + loginResposta.getIdToken());
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(this.tributosProperties.getAise().getBaseUrl() + "/datasnap/rest/tdebitos/emabertoporcpf/" + cpf, HttpMethod.GET, entity, DebitoTransportDTO.class, new Object[0]);
        return (DebitoTransportDTO)response.getBody();
    }

    public List<DebitoDTO> getDebitosAgrupadosCpf(String cpf) {
        DebitoTransportDTO delphiDTO = this.getDebitosEmAbertoPorCpf(cpf);
        return DebitoHandler.agrupaContratoParcela(delphiDTO.getList().getItems().stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoDTO(arg_0)).collect(Collectors.toList()));
    }
}

