/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.rest;

import br.com.elotech.tributos.config.TributosProperties;
import br.com.elotech.tributos.params.CadastroGeralParams;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.DebitoCarneService;
import br.com.elotech.tributos.service.ws.AiseDebitosCarneService;
import br.com.elotech.tributos.service.ws.rest.AiseLoginServiceRest;
import br.com.elotech.tributos.ws.domain.LoginRespostaRest;
import br.com.elotech.tributos.ws.rest.dto.DebitoCarneDTO;
import br.com.elotech.tributos.ws.rest.dto.DebitoCarneTransportDTO;
import br.com.elotech.tributos.ws.rest.dto.DebitoMapper;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AiseDebitoCarneServiceRest
implements DebitoCarneService,
AiseDebitosCarneService {
    private final RestTemplate restTemplate;
    private final AiseLoginServiceRest aiseLoginServiceRest;
    private final CadastroGeralService cadastroGeralService;
    private final TributosProperties tributosProperties;
    private final DebitoMapper debitoMapper;

    public AiseDebitoCarneServiceRest(RestTemplate restTemplate, AiseLoginServiceRest aiseLoginServiceRest, CadastroGeralService cadastroGeralService, TributosProperties tributosProperties, DebitoMapper debitoMapper) {
        this.restTemplate = restTemplate;
        this.aiseLoginServiceRest = aiseLoginServiceRest;
        this.cadastroGeralService = cadastroGeralService;
        this.tributosProperties = tributosProperties;
        this.debitoMapper = debitoMapper;
    }

    public List<DebitoCarneDTO> getDebitosCarne(CadastroGeralParams params) {
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        this.cadastroGeralService.validaCadastroGeral(params.getTipoCadastro(), params.getCadastroGeral());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + loginResposta.getIdToken());
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(this.tributosProperties.getAise().getBaseUrl() + "/datasnap/rest/tdebitos/emabertocarne/" + params.getTipoCadastro().getValue().toString() + "/" + params.getCadastroGeral().toString(), HttpMethod.GET, entity, DebitoCarneTransportDTO.class, new Object[0]);
        DebitoCarneTransportDTO delphiDTO = (DebitoCarneTransportDTO)response.getBody();
        return delphiDTO.getList().getItems().stream().map(arg_0 -> ((DebitoMapper)this.debitoMapper).toDebitoCarneDTO(arg_0)).collect(Collectors.toList());
    }
}

