/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.mobile;

import br.com.elotech.tributos.dto.mobile.PropriedadeMobileDTO;
import br.com.elotech.tributos.dto.mobile.TipoCadastroMobileDTO;
import br.com.elotech.tributos.repository.mobile.PropriedadeMobileRepository;
import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class PropriedadeMobileService {
    private final PropriedadeMobileRepository propriedadeRepository;

    public PropriedadeMobileService(PropriedadeMobileRepository propriedadeRepository) {
        this.propriedadeRepository = propriedadeRepository;
    }

    public List<PropriedadeMobileDTO> findPropriedades(String cpfCnpj) {
        return this.propriedadeRepository.findPropriedadesDebitoEmAberto(cpfCnpj);
    }

    public PropriedadeMobileDTO findPropriedadeByTipoAndCodigo(Integer tipoCadastro, Long cadastroGeral) {
        return this.propriedadeRepository.findPropriedadeByTipoAndCodigo(tipoCadastro, cadastroGeral);
    }

    public List<TipoCadastroMobileDTO> findTipoCadastroByCpfCnpj(String cpfCnpj) {
        return this.propriedadeRepository.findTipoCadastroByCpfCnpj(cpfCnpj);
    }

    public List<PropriedadeMobileDTO> findPropriedadesByCpfCnpjAndTipoCadastro(String cpfCnpj, Long tipoCadastro) {
        return this.propriedadeRepository.findPropriedadesByCpfCnpjAndTipoCadastro(cpfCnpj, tipoCadastro);
    }

    public List<PropriedadeMobileDTO> findPropriedadesByCpfCnpj(String cpfCnpj) {
        return this.propriedadeRepository.findPropriedadesByCpfCnpj(cpfCnpj);
    }

    public List<PropriedadeMobileDTO> findPropriedadesByListCpfCnpjAndDataVencimento(List<String> inscricoes, Integer quantidadeDias) {
        ArrayList<PropriedadeMobileDTO> propriedades = new ArrayList<PropriedadeMobileDTO>();
        inscricoes.forEach(cpfCnpj -> propriedades.addAll(this.findPropriedadesByCpfCnpjAndDataVencimento(cpfCnpj, quantidadeDias)));
        return propriedades;
    }

    public List<PropriedadeMobileDTO> findPropriedadesByCpfCnpjAndDataVencimento(String cpfCnpj, Integer quantidadeDias) {
        LocalDate dataReferencia = LocalDate.now();
        LocalDate dataReferenciaPlusDays = LocalDate.now().plusDays(quantidadeDias.intValue());
        return this.agregatePropriedadeByTipoAndCodigoAndCpfCnpj(this.propriedadeRepository.findPropriedadesDebitoEmAbertoByCpfCnpjAndDataVencimento(cpfCnpj, new Date[]{Date.valueOf(dataReferencia), Date.valueOf(dataReferenciaPlusDays)}));
    }

    protected List<PropriedadeMobileDTO> agregatePropriedadeByTipoAndCodigoAndCpfCnpj(List<PropriedadeMobileDTO> propriedades) {
        ArrayList<PropriedadeMobileDTO> result = new ArrayList<PropriedadeMobileDTO>();
        propriedades.forEach(propriedade -> {
            Integer indexPropriedadeAdicionada = result.indexOf(propriedade);
            if (indexPropriedadeAdicionada >= 0) {
                PropriedadeMobileDTO propriedadeResult = (PropriedadeMobileDTO)result.get(indexPropriedadeAdicionada);
                propriedadeResult.addAllDebitoMobileDTO(propriedade.getDebitos());
            } else {
                result.add((PropriedadeMobileDTO)propriedade);
            }
        });
        return result;
    }
}

