/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.config.TributosProperties;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.dto.PessoaDTO;
import br.com.elotech.tributos.repository.PessoaRepository;
import br.com.elotech.tributos.service.exception.PessoaNotFoundException;
import br.com.elotech.tributos.service.ws.rest.AiseLoginServiceRest;
import br.com.elotech.tributos.ws.domain.LoginRespostaRest;
import br.com.elotech.tributos.ws.rest.dto.pessoa.AlterarEnderecoPessoaRequestDTO;
import br.com.elotech.tributos.ws.rest.dto.pessoa.IncluirPessoaRequestDTO;
import br.com.elotech.tributos.ws.rest.dto.pessoa.IncluirPessoaResponseDTO;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class PessoaService
extends CrudService<Pessoa, Long> {
    private final PessoaRepository pessoaRepository;
    private final AiseLoginServiceRest aiseLoginServiceRest;
    private final RestTemplate restTemplate;
    private final String urlIncluirPessoa;
    private final String urlAlterarEnderecoPessoa;

    @Autowired
    public PessoaService(PessoaRepository pessoaRepository, AiseLoginServiceRest aiseLoginServiceRest, RestTemplate restTemplate, TributosProperties tributosProperties) {
        this.pessoaRepository = pessoaRepository;
        this.aiseLoginServiceRest = aiseLoginServiceRest;
        this.restTemplate = restTemplate;
        this.urlIncluirPessoa = tributosProperties.getAise().getBaseUrl() + "/datasnap/rest/tpessoa/gerar";
        this.urlAlterarEnderecoPessoa = tributosProperties.getAise().getBaseUrl() + "/datasnap/rest/tpessoa/alterarendereco";
    }

    public Pessoa findByCnpjCpf(String cnpjCpf) {
        return this.pessoaRepository.findByCnpjCpfAndInativo(cnpjCpf, Boolean.valueOf(false)).stream().findFirst().orElse(null);
    }

    public IncluirPessoaResponseDTO incluirPessoa(IncluirPessoaRequestDTO incluirPessoaRequestDTO) {
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + loginResposta.getIdToken());
        incluirPessoaRequestDTO.convertToUpperCase();
        HttpEntity entity = new HttpEntity((Object)incluirPessoaRequestDTO, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(this.urlIncluirPessoa, HttpMethod.POST, entity, IncluirPessoaResponseDTO.class, new Object[0]);
        return (IncluirPessoaResponseDTO)response.getBody();
    }

    public void alterarEnderecoPessoa(PessoaDTO pessoaDTO) {
        Pessoa pessoa = this.findByCnpjCpf(pessoaDTO.getCnpjCpf());
        if (Objects.isNull(pessoa)) {
            throw new PessoaNotFoundException(pessoaDTO.getCnpjCpf());
        }
        AlterarEnderecoPessoaRequestDTO alterarEnderecoPessoaRequestDTO = AlterarEnderecoPessoaRequestDTO.from((Long)pessoa.getId(), (PessoaDTO)pessoaDTO);
        alterarEnderecoPessoaRequestDTO.setActiveFormOrigem(pessoaDTO.getActiveFormOrigem());
        LoginRespostaRest loginResposta = this.aiseLoginServiceRest.login();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + loginResposta.getIdToken());
        alterarEnderecoPessoaRequestDTO.convertToUpperCase();
        HttpEntity entity = new HttpEntity((Object)alterarEnderecoPessoaRequestDTO, (MultiValueMap)headers);
        this.restTemplate.exchange(this.urlAlterarEnderecoPessoa, HttpMethod.POST, entity, Void.class, new Object[0]);
    }
}

