/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamento;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoDescontoParcelaId;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoEntradaId;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class ParamParcelamentoService
extends CrudService<ParamParcelamento, Long> {
    protected void beforeSave(ParamParcelamento entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        entity.getEntradas().forEach(entrada -> {
            if (entrada.getId() == null) {
                ParamParcelamentoEntradaId id = new ParamParcelamentoEntradaId();
                entrada.setId(id);
            }
            entrada.getId().setParametroParcelamento(entity);
            if (entrada.getId().getEntrada() == null) {
                entrada.getId().setEntrada(entity.getNumeroProximaEntrada());
            }
            entrada.getJuros().stream().forEach(juros -> juros.setEntrada(entrada));
        });
        entity.getParcelasSituacao().forEach(parcela -> {
            if (parcela.getId().getParametroParcelamento() == null) {
                parcela.getId().setParametroParcelamento(entity);
            }
        });
        entity.getParcelasPorValor().forEach(parcela -> {
            if (parcela.getId().getParametroParcelamento() == null) {
                parcela.getId().setParametroParcelamento(entity);
            }
        });
        entity.getDescontosPorParcela().forEach(desconto -> {
            if (desconto.getId() == null) {
                ParamParcelamentoDescontoParcelaId id = new ParamParcelamentoDescontoParcelaId();
                desconto.setId(id);
            }
            desconto.getId().setParametroParcelamento(entity);
            if (desconto.getId().getSequencia() == null) {
                desconto.getId().setSequencia(entity.getSequenciaProximoDescontoPorParcela());
            }
        });
        entity.getDescontosPorDivida().forEach(desconto -> {
            desconto.setParametroParcelamento(entity);
            desconto.getReceitas().stream().forEach(tributo -> tributo.setParametroParcelamentoDescontoGuia(desconto));
        });
    }
}

