/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.fluent.dataset.loader.DatasetLoaders;
import br.com.elotech.fluent.dataset.loader.ReportDataLoader;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.report.EloReportFactory;
import br.com.elotech.report.file.ReportFileResolverFactory;
import br.com.elotech.tributos.params.CadastroGeralParams;
import br.com.elotech.tributos.report.RelatorioTributos;
import br.com.elotech.tributos.report.loader.CabecalhoParamLoader;
import br.com.elotech.tributos.service.ExercicioService;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.stereotype.Service;

@Service
public class MobiliarioCompletoRelatorioService {
    private static final String CONSULTA = "sql/consulta.sql";
    private static final String ATIVIDADE = "sql/atividade.sql";
    private static final String BOLETIMMOBILIARIO = "sql/boletimmobiliario.sql";
    private static final String CNAE = "sql/cnae.sql";
    private static final String ISENCAO = "sql/isencaoMobiliario.sql";
    private static final String OBSERVACAO = "sql/observacao.sql";
    private static final String SERVICO = "sql/servico.sql";
    private static final String SOCIO = "sql/socio.sql";
    public static final String DATASET_CABECALHO = "Cabecalho";
    public static final String DATASET_CONSULTA = "Consulta";
    public static final String DATASET_BOLETIMMOBILIARIO = "BoletimMobiliario";
    public static final String DATASET_ATIVIDADE = "Atividade";
    public static final String DATASET_CNAE = "CNAE";
    public static final String DATASET_SOCIO = "Socio";
    public static final String DATASET_SERVICO = "Servico";
    public static final String DATASET_ISENCAO = "ISENCAO";
    public static final String DATASET_OBSERVACAO = "Observacao";
    private final DataSource dataSource;
    private final ExercicioService exercicioService;
    private final CabecalhoParamLoader cabecalhoParamLoader;
    private final ReportFileResolverFactory reportFileResolverFactory;

    public MobiliarioCompletoRelatorioService(DataSource dataSource, ExercicioService exercicioService, CabecalhoParamLoader cabecalhoParamLoader, ReportFileResolverFactory reportFileResolverFactory) {
        this.dataSource = dataSource;
        this.exercicioService = exercicioService;
        this.cabecalhoParamLoader = cabecalhoParamLoader;
        this.reportFileResolverFactory = reportFileResolverFactory;
    }

    public byte[] createMobiliarioCompletoPdfReport(CadastroGeralParams params) {
        Map paramsServico = params.toMapParams();
        paramsServico.put("exercicio", this.exercicioService.getExercicio());
        ReportDatasource reportDatasource = ReportDatasource.builder().add(DATASET_CABECALHO, (ReportDataLoader)this.cabecalhoParamLoader.datasetLoader(this.dataSource)).add(DATASET_CONSULTA, (ReportDataLoader)DatasetLoaders.jdbc((String)FileUtils.readResourceAsString((String)CONSULTA), (Map)params.toMapParams(), (DataSource)this.dataSource)).add(DATASET_ATIVIDADE, (ReportDataLoader)DatasetLoaders.jdbc((String)FileUtils.readResourceAsString((String)ATIVIDADE), (Map)params.toMapParams(), (DataSource)this.dataSource)).add(DATASET_BOLETIMMOBILIARIO, (ReportDataLoader)DatasetLoaders.jdbc((String)FileUtils.readResourceAsString((String)BOLETIMMOBILIARIO), (Map)params.toMapParams(), (DataSource)this.dataSource)).add(DATASET_CNAE, (ReportDataLoader)DatasetLoaders.jdbc((String)FileUtils.readResourceAsString((String)CNAE), (Map)params.toMapParams(), (DataSource)this.dataSource)).add(DATASET_ISENCAO, (ReportDataLoader)DatasetLoaders.jdbc((String)FileUtils.readResourceAsString((String)ISENCAO), (Map)params.toMapParams(), (DataSource)this.dataSource)).add(DATASET_OBSERVACAO, (ReportDataLoader)DatasetLoaders.jdbc((String)FileUtils.readResourceAsString((String)OBSERVACAO), (Map)params.toMapParams(), (DataSource)this.dataSource)).add(DATASET_SERVICO, (ReportDataLoader)DatasetLoaders.jdbc((String)FileUtils.readResourceAsString((String)SERVICO), (Map)paramsServico, (DataSource)this.dataSource)).add(DATASET_SOCIO, (ReportDataLoader)DatasetLoaders.jdbc((String)FileUtils.readResourceAsString((String)SOCIO), (Map)params.toMapParams(), (DataSource)this.dataSource)).params((ParamLoader)this.cabecalhoParamLoader).build();
        return EloReportFactory.crystal().reportFile(this.reportFileResolverFactory.fromFile(RelatorioTributos.CADASTRO_MOBILIARIO_COMPLETO.getDefaultRpt())).setReportDatasource(reportDatasource).build().exportToPdf();
    }
}

