/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.EntidadeCorrecao;
import br.com.elotech.tributos.domain.EntidadeCorrecaoId;
import br.com.elotech.tributos.repository.EntidadeCorrecaoRepository;
import br.com.elotech.tributos.service.EntidadeCorrecaoDividaService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class EntidadeCorrecaoService
extends CrudService<EntidadeCorrecao, EntidadeCorrecaoId> {
    private final EntidadeCorrecaoRepository entidadeCorrecaoRepository;
    private final EntidadeCorrecaoDividaService entidadeCorrecaoGuiaService;

    public EntidadeCorrecaoService(EntidadeCorrecaoRepository entidadeCorrecaoRepository, EntidadeCorrecaoDividaService entidadeCorrecaoGuiaService) {
        this.entidadeCorrecaoRepository = entidadeCorrecaoRepository;
        this.entidadeCorrecaoGuiaService = entidadeCorrecaoGuiaService;
    }

    public void setPrincipal(Long idEntidade, Long exercicio, Long sequencia) {
        List listEntidadeCorrecao = this.entidadeCorrecaoRepository.findByIdEntidadeAndIdExercicio(idEntidade, exercicio);
        List entidadeCorrecaoCorrigida = listEntidadeCorrecao.stream().map(entidade -> {
            entidade.setPrincipal(Boolean.valueOf(entidade.getId().getEntidade().equals(idEntidade) && entidade.getId().getExercicio().equals(exercicio) && entidade.getId().getSequencia().equals(sequencia)));
            return entidade;
        }).collect(Collectors.toList());
        this.entidadeCorrecaoRepository.saveAll(entidadeCorrecaoCorrigida);
    }

    public void deleteEntidadeCorrecao(Long idEntidade, Long exercicio, Long sequencia) {
        EntidadeCorrecaoId entidadeCorrecaoId = new EntidadeCorrecaoId();
        entidadeCorrecaoId.setSequencia(sequencia);
        entidadeCorrecaoId.setExercicio(exercicio);
        entidadeCorrecaoId.setEntidade(idEntidade);
        EntidadeCorrecao entidadeCorrecao = (EntidadeCorrecao)this.entidadeCorrecaoRepository.findOne((Object)entidadeCorrecaoId);
        this.entidadeCorrecaoRepository.delete((Object)entidadeCorrecao);
    }

    private void validate(EntidadeCorrecao entidadeCorrecao) {
        List idsDivida = entidadeCorrecao.getEntidadeCorrecaoDivida().stream().map(entidadeCorrecaoDivida -> entidadeCorrecaoDivida.getDivida().getDivida()).collect(Collectors.toList());
        this.entidadeCorrecaoGuiaService.verificaDividasJaParametrizadas(entidadeCorrecao.getId().getEntidade(), entidadeCorrecao.getId().getExercicio(), idsDivida, entidadeCorrecao.getId().getSequencia());
    }

    protected void beforeSave(EntidadeCorrecao entidadeCorrecao, Authentication authentication) {
        super.beforeSave((EloEntity)entidadeCorrecao, authentication);
        if (entidadeCorrecao.getId().getSequencia() == null) {
            Long lastSequence = this.entidadeCorrecaoRepository.lastSequence(entidadeCorrecao.getId().getEntidade(), entidadeCorrecao.getId().getExercicio()) + 1L;
            entidadeCorrecao.getId().setSequencia(lastSequence);
        }
        this.validate(entidadeCorrecao);
        entidadeCorrecao.setCorrecaoMultaId();
        entidadeCorrecao.setEntidadeCorrecaoMultaEspecialId();
        entidadeCorrecao.setEntidadeCorrecaoDividaId();
        entidadeCorrecao.setEntidadeCorrecaoIndiceCorrecaoId();
        entidadeCorrecao.setEntidadeCorrecaoIndiceJurosId();
        entidadeCorrecao.setEntidadeCorrecaoIndiceMultaId();
    }

    public EntidadeCorrecao getEntidadeCorrecao(Long idEntidade, Long exercicio, Optional<Long> divida) {
        return (EntidadeCorrecao)this.findByIdEntidadeAndIdExercicioAndIdDivida(idEntidade, exercicio, divida).orElse(this.getEntidadeCorrecaoPrincipal(idEntidade, exercicio).orElseThrow(() -> this.mountErrorMessage(idEntidade, exercicio, divida)));
    }

    public Optional<EntidadeCorrecao> findByIdEntidadeAndIdExercicioAndIdDivida(Long idEntidade, Long exercicio, Optional<Long> divida) {
        return divida.map(codigoDivida -> {
            List listEntidadeCorrecao = this.entidadeCorrecaoRepository.findByIdEntidadeAndIdExercicioAndIdDivida(idEntidade, exercicio, codigoDivida);
            if (listEntidadeCorrecao.size() > 1) {
                throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, String.format("Existe mais de uma entidade corre\u00e7\u00e3o configurada para mesma guia. Entidade %d e Exerc\u00edcio %d e Divida %d ", idEntidade, exercicio, codigoDivida));
            }
            return listEntidadeCorrecao.stream().findFirst().orElse(null);
        });
    }

    private ResponseStatusException mountErrorMessage(Long idEntidade, Long exercicio, Optional<Long> divida) {
        String mensagemErro = String.format("N\u00e3o foi encontrado entidade de corre\u00e7\u00e3o principal para o exercicio %d e entidade %d. ", exercicio, idEntidade);
        if (divida.isPresent()) {
            mensagemErro = mensagemErro.concat(String.format("Tamb\u00e9m n\u00e3o foi encontrado entidade de corre\u00e7\u00e3o para a divida %d. ", divida.get()));
        }
        return new ResponseStatusException(HttpStatus.NOT_FOUND, mensagemErro);
    }

    public Optional<EntidadeCorrecao> getEntidadeCorrecaoPrincipal(Long idEntidade, Long exercicio) {
        return this.entidadeCorrecaoRepository.findByIdEntidadeAndIdExercicioAndPrincipalIsTrue(idEntidade, exercicio);
    }
}

