/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.mobile.DocumentoMobileDTO;
import br.com.elotech.tributos.repository.CadastroGeralRepository;
import br.com.elotech.tributos.repository.DocumentoRepository;
import br.com.elotech.tributos.repository.imobiliario.CadastroImobiliarioRepository;
import br.com.elotech.tributos.repository.projections.DocumentoProjection;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import br.com.elotech.tributos.service.ws.AisePdfService;
import br.com.elotech.tributos.specs.DocumentoSpecifications;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DocumentoService {
    private final DocumentoRepository documentoRepository;
    private final CadastroGeralRepository cadastroGeralRepository;
    private final AisePdfService aisePdfService;
    private final CadastroImobiliarioRepository cadastroImobiliarioRepository;
    private final EntityManager em;

    @Autowired
    public DocumentoService(DocumentoRepository documentoRepository, CadastroGeralRepository cadastroGeralRepository, AisePdfService aisePdfService, CadastroImobiliarioRepository cadastroImobiliarioRepository, EntityManager em) {
        this.documentoRepository = documentoRepository;
        this.cadastroGeralRepository = cadastroGeralRepository;
        this.aisePdfService = aisePdfService;
        this.cadastroImobiliarioRepository = cadastroImobiliarioRepository;
        this.em = em;
    }

    public DocumentoProjection getDTO(String codigoValidacao) {
        return this.documentoRepository.findByCodigoValidacao(codigoValidacao);
    }

    public DocumentoMobileDTO getDocumentoMobileDTO(Long entidade, Long exercicio, Long tipoDocumento, Long documento) {
        Documento documentoEntity = this.documentoRepository.findByEntidadeTributacaoEntidadeIdAndEntidadeTributacaoExercicioAndTipoDocumentoIdAndDocumento(entidade, exercicio, tipoDocumento, documento);
        String urlImpressao = this.aisePdfService.fetchDocumento(documento, Integer.valueOf(tipoDocumento.intValue()), Integer.valueOf(exercicio.intValue()));
        DocumentoMobileDTO dto = new DocumentoMobileDTO(documentoEntity, urlImpressao);
        if (Optional.ofNullable(documentoEntity.getCadastroGeral()).isPresent() && documentoEntity.getCadastroGeral().getTipoCadastro().isImobiliario().booleanValue()) {
            Optional.ofNullable(this.cadastroImobiliarioRepository.findByTipoCadastroAndCadastroGeral(documentoEntity.getCadastroGeral().getTipoCadastro(), documentoEntity.getCadastroGeral().getCadastroGeral())).ifPresent(arg_0 -> ((DocumentoMobileDTO)dto).setCadastroImobiliarioEntity(arg_0));
        }
        return dto.from();
    }

    public DocumentoDTO getDocumentoDTO(Long entidade, Long exercicio, Long tipoDocumento, Long documento) {
        Documento documentoEntity = this.documentoRepository.findByEntidadeTributacaoEntidadeIdAndEntidadeTributacaoExercicioAndTipoDocumentoIdAndDocumento(entidade, exercicio, tipoDocumento, documento);
        String urlImpressao = this.aisePdfService.fetchDocumento(documento, Integer.valueOf(tipoDocumento.intValue()), Integer.valueOf(exercicio.intValue()));
        return DocumentoDTO.from((Documento)documentoEntity, (String)urlImpressao);
    }

    public List<DocumentoProjection> getListDocumentoDTO(TipoCadastro tipoCadastro, Long cadastroGeral) {
        CadastroGeral cadastroGeralEntity = (CadastroGeral)this.cadastroGeralRepository.findOneByTipoCadastroAndCadastroGeral(tipoCadastro, cadastroGeral).orElseThrow(() -> new CadastroNaoEncontradoException(tipoCadastro, cadastroGeral));
        return this.documentoRepository.findByCadastroGeral(cadastroGeralEntity, LocalDate.now());
    }

    public Page<DocumentoDTO> findAllDocumentoByCpfCnpj(String cpfCnpj, LocalDate dataValidade, Optional<String> search, Pageable pageable) {
        Specification specification = DocumentoSpecifications.byImprimeWebAndCpfCnpjAndDataValidade((String)cpfCnpj, (LocalDate)dataValidade);
        if (search.isPresent()) {
            specification = specification.and(RsqlUtils.createSpecFrom((EntityManager)this.em, Documento.class, (String)search.get(), Optional.empty()));
        }
        return this.documentoRepository.findAll(specification, pageable).map(DocumentoDTO::from).map(dto -> {
            dto.setUrl(this.aisePdfService.fetchDocumento(dto.getDocumento(), dto.getTipoDocumento(), dto.getExercicio()));
            return dto;
        });
    }
}

