/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.tributos.domain.parcelamento.Parcelamento;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.ParcelamentoDebitoDTO;
import br.com.elotech.tributos.dto.parcelamento.AiseDebitoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.BuscarNumeroParcelasImpressaoBoletoDTO;
import br.com.elotech.tributos.dto.parcelamento.EstornoParcelamentoRowDTO;
import br.com.elotech.tributos.dto.parcelamento.ImpressaoBoletoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.NumeroParcelasImpressaoBoletoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelaParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoPassivelQuitacaoDTO;
import br.com.elotech.tributos.dto.parcelamento.RequestSimularQuitarContratoDTO;
import br.com.elotech.tributos.dto.parcelamento.ResumoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.SimulacaoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.SimularQuitarContratoDTO;
import br.com.elotech.tributos.resource.RelatorioResource;
import br.com.elotech.tributos.service.EstornoParcelamentoService;
import br.com.elotech.tributos.service.ParcelamentoService;
import br.com.elotech.tributos.service.ws.AiseParcelamentoService;
import br.com.elotech.tributos.ws.rest.dto.BloquetoDTO;
import br.com.elotech.tributos.ws.rest.dto.ParamDebitosPassiveisParcelamentoDTO;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/parcelamentos"})
public class ParcelamentoResource
extends CrudResource<Parcelamento, Long> {
    private static final String ARQUIVO_IMPRESSAO_BOLETO = "BoletoParcelamento.pdf";
    private static final String ARQUIVO_SIMULACAO_QUITACAO = "SimulacaoQuitacao.pdf";
    private final ParcelamentoService parcelamentoService;
    private final AiseParcelamentoService aiseParcelamentoService;
    private final RelatorioResource relatorioResource;
    private final EstornoParcelamentoService estornoParcelamentoService;

    public ParcelamentoResource(ParcelamentoService parcelamentoService, AiseParcelamentoService aiseParcelamentoService, RelatorioResource relatorioResource, EstornoParcelamentoService estornoParcelamentoService) {
        this.parcelamentoService = parcelamentoService;
        this.aiseParcelamentoService = aiseParcelamentoService;
        this.relatorioResource = relatorioResource;
        this.estornoParcelamentoService = estornoParcelamentoService;
    }

    @GetMapping(value={"/{idParcelamento}/novo"})
    public ResponseEntity<List<ParcelamentoDebitoDTO>> findParcelamentoDebitoNovo(@PathVariable Long idParcelamento) {
        return ResponseEntity.ok((Object)this.parcelamentoService.findParcelamentoDebitoNovo(idParcelamento));
    }

    @GetMapping(value={"/{idParcelamento}/origem"})
    public ResponseEntity<List<ParcelamentoDebitoDTO>> findParcelamentoDebitoOrigem(@PathVariable Long idParcelamento) {
        return ResponseEntity.ok((Object)this.parcelamentoService.findParcelamentoDebitoOrigem(idParcelamento));
    }

    @GetMapping(value={"/debitos-passiveis-parcelamento"}, params={"tipoCadastro", "cadastroGeral", "dataCorrecao", "idParametroParcelamento"})
    public ResponseEntity<List<AiseDebitoParcelamentoDTO>> findDebitosPassiveisParcelamento(ParamDebitosPassiveisParcelamentoDTO param) {
        return ResponseEntity.ok((Object)this.aiseParcelamentoService.findDebitosPassiveisParcelamento(param));
    }

    @PostMapping(value={"/simular"})
    public ResponseEntity<SimulacaoParcelamentoDTO> simularParcelamento(@Valid @RequestBody SimulacaoParcelamentoDTO param) {
        return ResponseEntity.ok((Object)this.aiseParcelamentoService.simularParcelamento(param));
    }

    @PostMapping(value={"/gerar"})
    public ResponseEntity<ResumoParcelamentoDTO> gerarParcelamento(@Valid @RequestBody SimulacaoParcelamentoDTO param) {
        return ResponseEntity.ok((Object)this.aiseParcelamentoService.gerarParcelamento(param));
    }

    @GetMapping(value={"/{idParcelamento}/parcelas"})
    public ResponseEntity<List<ParcelaParcelamentoDTO>> findParcelamentoDebitoParcelas(@PathVariable Long idParcelamento) {
        return ResponseEntity.ok((Object)this.parcelamentoService.findParcelamentoDebitoParcelas(idParcelamento));
    }

    @GetMapping(value={"/{idParcelamento}/parcelamentos-compativeis"})
    public ResponseEntity<List<ParcelamentoPassivelQuitacaoDTO>> findParcelamentosCompativeis(@PathVariable Long idParcelamento) {
        return ResponseEntity.ok((Object)this.aiseParcelamentoService.findParcelamentosCompativeis(idParcelamento));
    }

    @PostMapping(value={"/simular-quitar-contrato"})
    public ResponseEntity<SimularQuitarContratoDTO> simularQuitarContrato(@RequestBody RequestSimularQuitarContratoDTO request) {
        return ResponseEntity.ok((Object)this.aiseParcelamentoService.simularQuitarContrato(request));
    }

    @PostMapping(value={"/imprimir-simulacao-quitar-contrato"})
    public void imprimirSimulacaoQuitarContrato(@RequestBody SimularQuitarContratoDTO request, HttpServletResponse response) throws IOException {
        byte[] arquivo = this.aiseParcelamentoService.imprimirSimulacaoQuitarContrato(request);
        if (arquivo == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "O relat\u00f3rio est\u00e1 inv\u00e1lido");
        }
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])arquivo, (String)ARQUIVO_SIMULACAO_QUITACAO);
    }

    @PostMapping(value={"/quitar-contrato"})
    public ResponseEntity<BloquetoDTO> quitarContrato(@RequestBody RequestSimularQuitarContratoDTO request) {
        return ResponseEntity.ok((Object)this.aiseParcelamentoService.quitarContrato(request));
    }

    @PostMapping(value={"/imprimir-boleto"})
    public void imprimirBoleto(@Valid @RequestBody ImpressaoBoletoParcelamentoDTO request, HttpServletResponse response) throws IOException {
        byte[] arquivo = this.aiseParcelamentoService.imprimirBoleto(request);
        if (arquivo == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel gerar o boleto.");
        }
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])arquivo, (String)ARQUIVO_IMPRESSAO_BOLETO);
    }

    @PostMapping(value={"/numero-parcelas-boleto"})
    public ResponseEntity<NumeroParcelasImpressaoBoletoDTO> getNumeroParcelasImpressaoBoleto(@Valid @RequestBody BuscarNumeroParcelasImpressaoBoletoDTO request) {
        return ResponseEntity.ok((Object)this.aiseParcelamentoService.buscarNumeroParcelasImpressaoBoleto(request));
    }

    @GetMapping(value={"{idParcelamento}/imprimir-contrato"})
    public void imprimirContrato(@PathVariable Long idParcelamento, HttpServletResponse response) throws IOException {
        ImprimirRelatorioDTO dto = this.parcelamentoService.getImprimirContratoDTO(idParcelamento);
        this.relatorioResource.imprimirRelatorioGenerico(dto, response);
    }

    @GetMapping(value={"{idParcelamento}/imprimir-situacao-contrato"})
    public void imprimirSituacaoContrato(@PathVariable Long idParcelamento, HttpServletResponse response) throws IOException {
        ImprimirRelatorioDTO dto = this.parcelamentoService.getImprimirSituacaoContratoDTO(idParcelamento);
        this.relatorioResource.imprimirRelatorioGenerico(dto, response);
    }

    @GetMapping(value={"{idParcelamento}/estornos"})
    public ResponseEntity<List<EstornoParcelamentoRowDTO>> getEstornos(@PathVariable Long idParcelamento) {
        return ResponseEntity.ok(this.estornoParcelamentoService.findByIdParcelamento(idParcelamento).stream().map(EstornoParcelamentoRowDTO::from).sorted(Comparator.comparing(EstornoParcelamentoRowDTO::getId).reversed()).collect(Collectors.toList()));
    }
}

