/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.dto.DebitoCotaUnicaDTO;
import br.com.elotech.tributos.params.CadastroGeralParams;
import br.com.elotech.tributos.service.DebitoCarneService;
import br.com.elotech.tributos.service.DebitoCotaUnicaService;
import br.com.elotech.tributos.ws.rest.dto.DebitoCarneDTO;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/debitoscarne"})
public class DebitosCarneResource {
    private final DebitoCarneService debitoCarneService;
    private final DebitoCotaUnicaService debitoCotaUnicaService;

    public DebitosCarneResource(DebitoCarneService debitoCarneService, DebitoCotaUnicaService debitoCotaUnicaService) {
        this.debitoCarneService = debitoCarneService;
        this.debitoCotaUnicaService = debitoCotaUnicaService;
    }

    @GetMapping(params={"tipoCadastro", "cadastroGeral"})
    public ResponseEntity<List<DebitoCarneDTO>> getDebitosCarne(CadastroGeralParams params) {
        return ResponseEntity.ok().body((Object)this.debitoCarneService.getDebitosCarne(params));
    }

    @GetMapping(value={"/agrupado-forma-pagamento"}, params={"tipo-cadastro", "cadastro-geral"})
    public ResponseEntity<List<DebitoCotaUnicaDTO>> findAllAgrupadoFormaPagamento(@RequestParam(value="tipo-cadastro") Long tipoCadastro, @RequestParam(value="cadastro-geral") Long cadastroGeral) {
        return ResponseEntity.ok((Object)this.debitoCotaUnicaService.findAllDebitoAgrupadoPorFormaPagamentoDisponivelWeb(tipoCadastro, cadastroGeral));
    }
}

