/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.dto.GeraBoletoPorFormaPagamentoDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.params.GeraBloquetoParams;
import br.com.elotech.tributos.service.AiseBloquetoService;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.ws.AisePdfService;
import br.com.elotech.tributos.ws.rest.dto.BloquetoDTO;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/bloqueto"})
public class BloquetoResource
extends ReadOnlyResource<Bloqueto, Long> {
    private final AiseBloquetoService aiseBloquetoService;
    private final AisePdfService aisePdfService;
    private final BloquetoService bloquetoService;

    public BloquetoResource(AiseBloquetoService aiseBloquetoService, AisePdfService aisePdfService, BloquetoService bloquetoService) {
        this.aiseBloquetoService = aiseBloquetoService;
        this.aisePdfService = aisePdfService;
        this.bloquetoService = bloquetoService;
    }

    @GetMapping(params={"bloqueto"})
    public ResponseEntity<Bloqueto> findByBloqueto(Long bloqueto) {
        Bloqueto bloquetoResult = this.findByIdBloqueto(bloqueto);
        return ResponseEntity.ok().body((Object)bloquetoResult);
    }

    @PostMapping(path={"/gera/imprime"})
    public ImpressaoDTO geraBloquetoEImprime(@RequestBody List<DebitoDTO> params) {
        return ImpressaoDTO.from((String)this.aisePdfService.fetchBloqueto(this.aiseBloquetoService.geraBloqueto(params).getBloqueto()));
    }

    @PostMapping(path={"/gera"})
    public ResponseEntity<BloquetoDTO> geraBloqueto(@RequestBody List<DebitoDTO> params, HttpServletResponse response) throws IOException {
        BloquetoDTO bloquetoDTO = this.aiseBloquetoService.geraBloqueto(params);
        return ResponseEntity.ok().body((Object)bloquetoDTO.setCadastroPessoaDTO());
    }

    @PostMapping(path={"/gera-por-data-pagamento"})
    public ResponseEntity<BloquetoDTO> geraBloquetoPorDataPagamento(@RequestBody GeraBloquetoParams params, HttpServletResponse response) throws IOException {
        BloquetoDTO bloquetoDTO = this.aiseBloquetoService.geraBloquetoPorDataPagamento(params.getDebitos(), params.getDataReferencia());
        return ResponseEntity.ok().body((Object)bloquetoDTO);
    }

    @PostMapping(path={"/gera-por-forma-pagamento"})
    public ResponseEntity<BloquetoDTO> geraBloquetoPorFormaPagamento(@RequestBody GeraBoletoPorFormaPagamentoDTO params, HttpServletResponse response) {
        BloquetoDTO bloquetoDTO = this.aiseBloquetoService.geraBoletoPorFormaPagamento(params);
        return ResponseEntity.ok().body((Object)bloquetoDTO);
    }

    @GetMapping(path={"/imprime"}, params={"bloqueto"})
    public ImpressaoDTO imprimirBloqueto(@RequestParam(value="bloqueto") Long bloqueto) {
        return ImpressaoDTO.from((String)this.aisePdfService.fetchBloqueto(bloqueto));
    }

    private Bloqueto findByIdBloqueto(Long idBloqueto) {
        Bloqueto bloqueto = this.bloquetoService.findByBloqueto(idBloqueto);
        return Optional.ofNullable(bloqueto).orElseThrow(() -> RestException.notFound((String)"Verificar se o banco est\u00e1 configurado para o mesmo que o do webservices"));
    }
}

