/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.parcelamento.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.ParcelamentoDebitoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelaParcelamentoDTO;
import br.com.elotech.tributos.repository.parcelamento.ParcelamentoRepositoryCustom;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class ParcelamentoRepositoryImpl
implements ParcelamentoRepositoryCustom {
    private static final String DEBITO_ORIGEM = "br/com/elotech/tributos/repository/parcelamento-debito-origem.sql";
    private static final String DEBITO_NOVO = "br/com/elotech/tributos/repository/parcelamento-debito-novo.sql";
    private static final String DEBITO_PARCELAS = "br/com/elotech/tributos/repository/parcelamento-debito-parcelas.sql";
    private final JdbcTemplate jdbcTemplate;

    public ParcelamentoRepositoryImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<ParcelamentoDebitoDTO> findParcelamentoDebitoOrigem(Long idParcelamento) {
        String sql = FileUtils.readResourceAsString((String)DEBITO_ORIGEM);
        return this.jdbcTemplate.query(sql, new Object[]{idParcelamento}, (RowMapper)new ElotechBeanPropertyRowMapper(ParcelamentoDebitoDTO.class));
    }

    public List<ParcelamentoDebitoDTO> findParcelamentoDebitoNovo(Long idParcelamento) {
        String sql = FileUtils.readResourceAsString((String)DEBITO_NOVO);
        return this.jdbcTemplate.query(sql, new Object[]{idParcelamento}, (RowMapper)new ElotechBeanPropertyRowMapper(ParcelamentoDebitoDTO.class));
    }

    public List<ParcelaParcelamentoDTO> findParcelamentoDebitoParcelas(Long idParcelamento) {
        String sql = FileUtils.readResourceAsString((String)DEBITO_PARCELAS);
        return this.jdbcTemplate.query(sql, new Object[]{idParcelamento}, (RowMapper)new ElotechBeanPropertyRowMapper(ParcelaParcelamentoDTO.class));
    }
}

