/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.impl;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.repository.DebitoCustomRepository;
import java.util.Date;
import java.util.List;
import org.springframework.data.repository.query.Param;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DebitoRepositoryImpl
implements DebitoCustomRepository {
    private static final String SQL_EXISTS_DEBITO_ABERTO = "br/com/elotech/tributos/repository/mobile/existsDebitoEmAberto.sql";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public DebitoRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public Boolean possuiDebitosVencidos(String cpfCnpj) {
        String sql = FileUtils.readResourceAsString((String)SQL_EXISTS_DEBITO_ABERTO);
        MapSqlParameterSource params = new MapSqlParameterSource("cnpjCpf", (Object)cpfCnpj);
        params.addValue("dataBase", (Object)new Date());
        List result = this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)params, (rs, rowNum) -> rs.getInt(1));
        return !result.isEmpty() && (Integer)result.get(0) > 0;
    }

    public List<Long> findPagos(@Param(value="ids") List<Long> ids) {
        String sql = "select td.iddebito      from tribdebito td     where td.iddebito in (:ids)       and not exists (select 1                         from tribdebitoparcela tdp                        inner join tribsituacaoparcela tsp      on tdp.situacaodebito = tsp.situacaoparcela                        inner join tribtiposituacaoparcela ttsp on tsp.tiposituacaoparcela = ttsp.tiposituacaoparcela                        where td.entidade = tdp.entidade                          and td.exercicio = tdp.exercicio                          and td.tipocadastro = tdp.tipocadastro                          and td.cadastrogeral = tdp.cadastrogeral                          and td.guiarecolhimento = tdp.guiarecolhimento                          and td.subdivida = tdp.subdivida                          and ttsp.tipo = 'A') ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("ids", ids);
        return this.namedParameterJdbcTemplate.queryForList(sql, (SqlParameterSource)parameters, Long.class);
    }

    public List<DebitoDTO> findDebitoComParcelaEmAberto(@Param(value="idParcelamento") Long idParcelamento) {
        String sql = "select TribDebito.Entidade,           TribDebito.Exercicio,           TribDebito.TipoCadastro,           TribDebito.CadastroGeral,           TribDebito.GuiaRecolhimento,           TribDebito.SubDivida,           Count(dp.parcela) as NumeroParcelas      from Tribparcelamentodebitoorigem Tribparcelamentodebitoorigem      left outer join TribDebito TribDebito on TribDebito.Iddebito = Tribparcelamentodebitoorigem.Iddebitonovo      left outer join TribDebitoParcela dp on TribDebito.Entidade = dp.Entidade                                          and TribDebito.Exercicio = dp.Exercicio                                          and TribDebito.Tipocadastro = dp.Tipocadastro                                          and TribDebito.Cadastrogeral = dp.Cadastrogeral                                          and TribDebito.Guiarecolhimento = dp.Guiarecolhimento                                          and TribDebito.Subdivida = dp.Subdivida      left outer join tribSituacaoParcela tsp on dp.Situacaodebito = tsp.SituacaoParcela      left outer join tribTipoSituacaoParcela ttsp on tsp.Tiposituacaoparcela = ttsp.Tiposituacaoparcela     Where Tribparcelamentodebitoorigem.Idparcelamento = :idParcelamento       and ttsp.Tipo = 'A'     Group by TribDebito.Entidade,              TribDebito.Exercicio,              TribDebito.TipoCadastro,              TribDebito.CadastroGeral,              TribDebito.GuiaRecolhimento,              TribDebito.SubDivida     Order by TribDebito.Entidade,              TribDebito.Exercicio,              TribDebito.TipoCadastro,              TribDebito.CadastroGeral,              TribDebito.GuiaRecolhimento,              TribDebito.SubDivida ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("idParcelamento", (Object)idParcelamento);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (rs, rowNum) -> {
            DebitoDTO debitoDTO = new DebitoDTO();
            debitoDTO.setEntidade(Integer.valueOf(rs.getInt("entidade")));
            debitoDTO.setExercicio(Integer.valueOf(rs.getInt("exercicio")));
            debitoDTO.setTipoCadastro(Integer.valueOf(rs.getInt("tipocadastro")));
            debitoDTO.setCadastroGeral(Integer.valueOf(rs.getInt("cadastrogeral")));
            debitoDTO.setGuiaRecolhimento(Integer.valueOf(rs.getInt("guiarecolhimento")));
            debitoDTO.setSubDivida(Integer.valueOf(rs.getInt("subdivida")));
            debitoDTO.setNumeroParcelas(Integer.valueOf(rs.getInt("numeroparcelas")));
            return debitoDTO;
        });
    }
}

