/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.service.mobile.DebitoParcelaReceitaDTO;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class DebitoParcelaReceitaRepository {
    private static final String SQL = "br/com/elotech/tributos/repository/findDebitoParcelaReceita.sql";
    private final JdbcTemplate jdbcTemplate;

    public DebitoParcelaReceitaRepository(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<DebitoParcelaReceitaDTO> findDebitoParcelaReceita(DebitoDTO debito) {
        String sql = FileUtils.readResourceAsString((String)SQL);
        return this.jdbcTemplate.query(sql, new Object[]{debito.getEntidade(), debito.getExercicio(), debito.getTipoCadastro(), debito.getCadastroGeral(), debito.getGuiaRecolhimento(), debito.getSubDivida()}, (rs, rowNum) -> {
            DebitoParcelaReceitaDTO debitoParcelaReceita = new DebitoParcelaReceitaDTO();
            debitoParcelaReceita.setEntidade(Integer.valueOf(rs.getInt("entidade")));
            debitoParcelaReceita.setExercicio(Integer.valueOf(rs.getInt("exercicio")));
            debitoParcelaReceita.setTipoCadastro(Integer.valueOf(rs.getInt("tipocadastro")));
            debitoParcelaReceita.setCadastroGeral(Integer.valueOf(rs.getInt("cadastrogeral")));
            debitoParcelaReceita.setGuiaRecolhimento(Integer.valueOf(rs.getInt("guiarecolhimento")));
            debitoParcelaReceita.setSubDivida(Integer.valueOf(rs.getInt("subdivida")));
            debitoParcelaReceita.setReceita(rs.getString("receita"));
            debitoParcelaReceita.setParcela(Integer.valueOf(rs.getInt("parcela")));
            debitoParcelaReceita.setValor(rs.getBigDecimal("valor"));
            debitoParcelaReceita.setValorJuros(rs.getBigDecimal("valorjuros"));
            debitoParcelaReceita.setValorMulta(rs.getBigDecimal("valormulta"));
            debitoParcelaReceita.setValorCorrecao(rs.getBigDecimal("valorcorrecao"));
            debitoParcelaReceita.setValorDesconto(rs.getBigDecimal("valordesconto"));
            return debitoParcelaReceita;
        });
    }
}

