/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.acrescimo;

import br.com.elotech.tributos.dto.acrescimo.ResultadoAcrescimoDTO;
import java.math.BigDecimal;
import java.util.Objects;

public class ResultadoAcrescimoDTO {
    private BigDecimal principal = BigDecimal.ZERO;
    private BigDecimal correcao = BigDecimal.ZERO;
    private BigDecimal multa = BigDecimal.ZERO;
    private BigDecimal juros = BigDecimal.ZERO;
    private BigDecimal desconto = BigDecimal.ZERO;
    private BigDecimal total = BigDecimal.ZERO;

    public BigDecimal getTotal() {
        this.total = this.principal.add(this.correcao).add(this.multa).add(this.juros).subtract(this.desconto);
        return this.total;
    }

    public static Builder builder() {
        return new Builder(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultadoAcrescimoDTO that = (ResultadoAcrescimoDTO)o;
        return this.principal.compareTo(that.principal) == 0 && this.correcao.compareTo(that.correcao) == 0 && this.multa.compareTo(that.multa) == 0 && this.juros.compareTo(that.juros) == 0 && this.desconto.compareTo(that.desconto) == 0 && this.total.compareTo(that.total) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.principal, this.correcao, this.multa, this.juros, this.desconto, this.total);
    }

    public String toString() {
        return "ResultadoAcrescimoDTO{principal=" + this.principal + ", correcao=" + this.correcao + ", multa=" + this.multa + ", juros=" + this.juros + ", desconto=" + this.desconto + ", total=" + this.total + '}';
    }

    public BigDecimal getPrincipal() {
        return this.principal;
    }

    public BigDecimal getCorrecao() {
        return this.correcao;
    }

    public BigDecimal getMulta() {
        return this.multa;
    }

    public BigDecimal getJuros() {
        return this.juros;
    }

    public BigDecimal getDesconto() {
        return this.desconto;
    }

    public void setPrincipal(BigDecimal principal) {
        this.principal = principal;
    }

    public void setCorrecao(BigDecimal correcao) {
        this.correcao = correcao;
    }

    public void setMulta(BigDecimal multa) {
        this.multa = multa;
    }

    public void setJuros(BigDecimal juros) {
        this.juros = juros;
    }

    public void setDesconto(BigDecimal desconto) {
        this.desconto = desconto;
    }

    public void setTotal(BigDecimal total) {
        this.total = total;
    }
}

