/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.tributos.domain.TipoSocio;
import br.com.elotech.tributos.domain.mobiliario.ContratoSocialPessoa;
import java.math.BigDecimal;
import java.util.Optional;

public class ContratoSocialPessoaDTO {
    private Long pessoa;
    private String nome;
    private TipoPessoa tipoPessoa;
    private String cpfCnpj;
    private TipoSocio tipoSocio;
    private Boolean responsavel;
    private BigDecimal percentualCapital = BigDecimal.ZERO;

    public static final ContratoSocialPessoaDTO from(ContratoSocialPessoa contratoSocialPessoa) {
        ContratoSocialPessoaDTO dto = new ContratoSocialPessoaDTO();
        if (Optional.ofNullable(contratoSocialPessoa.getPessoa()).isPresent()) {
            dto.setPessoa(contratoSocialPessoa.getPessoa().getId());
            dto.setNome(contratoSocialPessoa.getPessoa().getNome());
            dto.setCpfCnpj(contratoSocialPessoa.getPessoa().getCnpjCpf());
            dto.setTipoPessoa(contratoSocialPessoa.getPessoa().getTipoPessoa());
        }
        dto.setPercentualCapital(contratoSocialPessoa.getPercentualCapital());
        dto.setTipoSocio(contratoSocialPessoa.getTipoSocio());
        dto.setResponsavel(Boolean.valueOf("S".equals(contratoSocialPessoa.getResponsavel())));
        return dto;
    }

    public Long getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Long pessoa) {
        this.pessoa = pessoa;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public TipoPessoa getTipoPessoa() {
        return this.tipoPessoa;
    }

    public void setTipoPessoa(TipoPessoa tipoPessoa) {
        this.tipoPessoa = tipoPessoa;
    }

    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    public TipoSocio getTipoSocio() {
        return this.tipoSocio;
    }

    public void setTipoSocio(TipoSocio tipoSocio) {
        this.tipoSocio = tipoSocio;
    }

    public Boolean getResponsavel() {
        return this.responsavel;
    }

    public void setResponsavel(Boolean responsavel) {
        this.responsavel = responsavel;
    }

    public BigDecimal getPercentualCapital() {
        return this.percentualCapital;
    }

    public void setPercentualCapital(BigDecimal percentualCapital) {
        this.percentualCapital = percentualCapital;
    }
}

