/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.parcelamento;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.converter.TipoParcelamentoConverter;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.SituacaoParcelamento;
import br.com.elotech.tributos.domain.parcelamento.TipoParcelamento;
import br.com.elotech.tributos.dto.CadastroGeralResumidoDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="tribparcelamento")
public class Parcelamento
implements EloEntity<Long>,
Serializable {
    private static final long serialVersionUID = 4789269775384604027L;
    @Id
    @Column(name="idparcelamento")
    @EloSequence(sequenceName="S05IDPARCELAMENTO")
    private Long id;
    private Long entidade;
    @Convert(converter=TipoParcelamentoConverter.class)
    private TipoParcelamento tipo;
    private Long anoContrato;
    private Long numeroContrato;
    private LocalDate dataParcelamento;
    private LocalDate dataInclusao;
    private LocalDate dataEntrada;
    private Long numeroParcela;
    @Length(max=1000)
    private @Length(max=1000) String observacao;
    private BigDecimal valorEntrada = BigDecimal.ZERO;
    private String usuario;
    private Long anoProcessoPrazo;
    private Long numeroProcessoPrazo;
    private Long idParametroParcelamento;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean estornado;
    @ManyToOne
    @JoinColumn(name="REQUERENTE")
    private Pessoa requerente;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="tipoCadastro", referencedColumnName="tipoCadastro"), @JoinColumn(name="cadastroGeral", referencedColumnName="cadastroGeral")})
    @JsonIgnore
    @MetaModelIgnore
    private CadastroGeral cadastroGeral;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean conversao;
    @ManyToOne
    private SituacaoParcelamento situacao;
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinTable(name="tribparcelamentodebito", joinColumns={@JoinColumn(name="idparcelamento", insertable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="idparcelamento")})
    private List<Debito> debitos;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    public TipoParcelamento getTipo() {
        return this.tipo;
    }

    public void setTipo(TipoParcelamento tipo) {
        this.tipo = tipo;
    }

    public Long getAnoContrato() {
        return this.anoContrato;
    }

    public void setAnoContrato(Long anoContrato) {
        this.anoContrato = anoContrato;
    }

    public Long getNumeroContrato() {
        return this.numeroContrato;
    }

    public void setNumeroContrato(Long numeroContrato) {
        this.numeroContrato = numeroContrato;
    }

    public LocalDate getDataParcelamento() {
        return this.dataParcelamento;
    }

    public void setDataParcelamento(LocalDate dataParcelamento) {
        this.dataParcelamento = dataParcelamento;
    }

    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    public LocalDate getDataEntrada() {
        return this.dataEntrada;
    }

    public void setDataEntrada(LocalDate dataEntrada) {
        this.dataEntrada = dataEntrada;
    }

    public Long getNumeroParcela() {
        return this.numeroParcela;
    }

    public void setNumeroParcela(Long numeroParcela) {
        this.numeroParcela = numeroParcela;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public BigDecimal getValorEntrada() {
        return this.valorEntrada;
    }

    public void setValorEntrada(BigDecimal valorEntrada) {
        this.valorEntrada = valorEntrada;
    }

    public String getUsuario() {
        return this.usuario;
    }

    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    public Long getAnoProcessoPrazo() {
        return this.anoProcessoPrazo;
    }

    public void setAnoProcessoPrazo(Long anoProcessoPrazo) {
        this.anoProcessoPrazo = anoProcessoPrazo;
    }

    public Long getNumeroProcessoPrazo() {
        return this.numeroProcessoPrazo;
    }

    public void setNumeroProcessoPrazo(Long numeroProcessoPrazo) {
        this.numeroProcessoPrazo = numeroProcessoPrazo;
    }

    public Long getIdParametroParcelamento() {
        return this.idParametroParcelamento;
    }

    public void setIdParametroParcelamento(Long idParametroParcelamento) {
        this.idParametroParcelamento = idParametroParcelamento;
    }

    public Boolean getEstornado() {
        return this.estornado;
    }

    public void setEstornado(Boolean estornado) {
        this.estornado = estornado;
    }

    public Pessoa getRequerente() {
        return this.requerente;
    }

    public void setRequerente(Pessoa requerente) {
        this.requerente = requerente;
    }

    public CadastroGeral getCadastroGeral() {
        return this.cadastroGeral;
    }

    public void setCadastroGeral(CadastroGeral cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    public Boolean getConversao() {
        return this.conversao;
    }

    public void setConversao(Boolean conversao) {
        this.conversao = conversao;
    }

    public SituacaoParcelamento getSituacao() {
        return this.situacao;
    }

    public void setSituacao(SituacaoParcelamento situacao) {
        this.situacao = situacao;
    }

    public CadastroGeralResumidoDTO getCadastroGeralResumido() {
        return CadastroGeralResumidoDTO.from((CadastroGeral)this.cadastroGeral);
    }
}

