/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.parcelamento;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.Ato;
import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.MotivoDesconto;
import br.com.elotech.tributos.domain.SituacaoParcelamento;
import br.com.elotech.tributos.domain.Tributo;
import br.com.elotech.tributos.domain.parcelamento.FormaCobrancaJurosParcelamento;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoDescontoDivida;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoDescontoParcela;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoEntrada;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoParcelaPorValor;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoParcelaSituacao;
import br.com.elotech.tributos.domain.parcelamento.ParcelamentoTipoDesconto;
import br.com.elotech.tributos.domain.parcelamento.TipoParcelamento;
import br.com.elotech.tributos.domain.relatorio.Relatorio;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TRIBPARAMPARCELAMENTO")
public class ParamParcelamento
implements EloEntity<Long>,
Serializable {
    private static final Long ACRESCIMO_DE_SEQUENCIA = 1L;
    @Id
    @EloSequence(sequenceName="S05IDPARAMETROPARCELAMENTO")
    @Column(name="IDPARAMETROPARCELAMENTO")
    private Long id;
    private TipoParcelamento tipo = TipoParcelamento.PARCELAMENTO;
    @Column(name="descricao")
    @Length(max=250)
    @NotNull
    private @Length(max=250) @NotNull String descricao;
    @ManyToOne
    @JoinColumn
    private MotivoDesconto motivoDesconto;
    @ManyToOne
    @JoinColumn
    private FormaCorrecao formaCorrecao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="fundamentolegal", referencedColumnName="idato"))})
    private Ato ato;
    private Long numeroParcela;
    private Long numeroParcelaRequerimento;
    @Column(name="numeroparcelaporsituacao")
    private Boolean numeroParcelaSituacao;
    @Column(name="numeroparcelaporvalor")
    private Boolean numeroParcelaValor;
    private Boolean cobraExpediente;
    private Long entidade;
    private Long exercicio;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(formula=@JoinFormula(value="exercicio", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="receitaexpediente", referencedColumnName="receita"))})
    private Tributo taxaExpediente;
    private BigDecimal valorExpediente = BigDecimal.ZERO;
    private BigDecimal valorMinimoParcela = BigDecimal.ZERO;
    private ParcelamentoTipoDesconto tipoDesconto;
    private FormaCobrancaJurosParcelamento tipoJurosFinanciamento;
    @NotBlank
    @Length(max=4000)
    private @NotBlank @Length(max=4000) String filtroDebito;
    @Column(name="jurosFinanSobreCorrecao")
    private Boolean jurosFinanciamentoSobreCorrecao;
    @Column(name="jurosFinanSobreJuros")
    private Boolean jurosFinanciamentoSobreJuros;
    @Column(name="jurosFinanSobreMulta")
    private Boolean jurosFinanciamentoSobreMulta;
    @Column(name="jurosFinanSobrePrincipal")
    private Boolean jurosFinanciamentoSobrePrincipal;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(formula=@JoinFormula(value="exercicio", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="receitaJurosFinan", referencedColumnName="receita"))})
    private Tributo tributoJurosFinanciamento;
    @Column(name="taxaUnicaJurosFinan")
    private BigDecimal taxaUnicaJurosFinanciamento = BigDecimal.ZERO;
    private Boolean entradaValorIgual;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="modulo", referencedColumnName="modulo"), @JoinColumn(name="tiporelatorio", referencedColumnName="tiporelatorio"), @JoinColumn(name="relatorio", referencedColumnName="relatorio")})
    private Relatorio relatorio;
    @Column(name="sequenciaemissao")
    private Long sequenciaEmissaoRelatorio;
    private BigDecimal descontoPrincipal = BigDecimal.ZERO;
    private BigDecimal descontoJuros = BigDecimal.ZERO;
    private BigDecimal descontoMulta = BigDecimal.ZERO;
    private BigDecimal descontoCorrecao = BigDecimal.ZERO;
    private Boolean desativado;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(formula=@JoinFormula(value="exercicio", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="receitaDesconto", referencedColumnName="receita"))})
    private Tributo tributoDesconto;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(formula=@JoinFormula(value="exercicio", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="receitaDescontoJuros", referencedColumnName="receita"))})
    private Tributo tributoDescontoJuros;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(formula=@JoinFormula(value="exercicio", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="receitaDescontoMulta", referencedColumnName="receita"))})
    private Tributo tributoDescontoMulta;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(formula=@JoinFormula(value="exercicio", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="receitaDescontoCorrecao", referencedColumnName="receita"))})
    private Tributo tributoDescontoCorrecao;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="modulo", referencedColumnName="modulo")), @JoinColumnOrFormula(column=@JoinColumn(name="tipoRelatorioBloqueto", referencedColumnName="tiporelatorio")), @JoinColumnOrFormula(column=@JoinColumn(name="relatorioBloqueto", referencedColumnName="relatorio"))})
    private Relatorio relatorioBoleto;
    private Boolean parcelamentoIndividual;
    @Column(name="descontopagtoavista")
    private BigDecimal descontoPagamVista = BigDecimal.ZERO;
    @ManyToOne
    @JoinColumn
    private MotivoDesconto motivoDescontoQuitacao;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="modulo", referencedColumnName="modulo")), @JoinColumnOrFormula(column=@JoinColumn(name="tipoRelatorioBloquetoCarne", referencedColumnName="tiporelatorio")), @JoinColumnOrFormula(column=@JoinColumn(name="relatorioBloquetoCarne", referencedColumnName="relatorio"))})
    private Relatorio relatorioCarne;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="modulo", referencedColumnName="modulo")), @JoinColumnOrFormula(column=@JoinColumn(name="tipoRelatorioSimulacao", referencedColumnName="tiporelatorio")), @JoinColumnOrFormula(column=@JoinColumn(name="relatorioSimulacao", referencedColumnName="relatorio"))})
    private Relatorio relatorioSimulacao;
    private Boolean utilizaSac;
    @ManyToOne
    @JoinColumn
    private MotivoDesconto motivoEstorno;
    private Long numeroParcelasVencidas;
    @ManyToOne
    @JoinColumn
    private FormaPagamento formaPagamento;
    private Boolean utilizaExercicioLogado;
    @ManyToOne
    @JoinColumn(name="motivoDescontoFinan")
    private MotivoDesconto motivoDescontoFinanciamento;
    private Boolean bloqueioJudicial;
    @ManyToOne
    @JoinColumn
    private SituacaoParcelamento situacao;
    @ManyToOne
    @JoinColumn(name="modelobloqueto")
    private ModeloBoleto modeloBoleto;
    private Long dataVencimento;
    @OneToMany(mappedBy="id.parametroParcelamento", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ParamParcelamentoEntrada> entradas = new ArrayList();
    @OneToMany(mappedBy="id.parametroParcelamento", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ParamParcelamentoParcelaSituacao> parcelasSituacao = new ArrayList();
    @OneToMany(mappedBy="id.parametroParcelamento", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ParamParcelamentoParcelaPorValor> parcelasPorValor = new ArrayList();
    @OneToMany(mappedBy="id.parametroParcelamento", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ParamParcelamentoDescontoParcela> descontosPorParcela = new ArrayList();
    @OneToMany(mappedBy="parametroParcelamento", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ParamParcelamentoDescontoDivida> descontosPorDivida = new ArrayList();

    public Long getNumeroProximaEntrada() {
        return this.getEntradas().stream().map(entrada -> {
            if (entrada.getId() == null || entrada.getId() != null && entrada.getId().getEntrada() == null) {
                return 0L;
            }
            return entrada.getId().getEntrada();
        }).reduce(Long::max).orElse(0L) + ACRESCIMO_DE_SEQUENCIA;
    }

    public Long getSequenciaProximoDescontoPorParcela() {
        return this.getDescontosPorParcela().stream().map(desconto -> {
            if (desconto.getId() == null || desconto.getId() != null && desconto.getId().getSequencia() == null) {
                return 0L;
            }
            return desconto.getId().getSequencia();
        }).reduce(Long::max).orElse(0L) + ACRESCIMO_DE_SEQUENCIA;
    }

    public Long getId() {
        return this.id;
    }

    public TipoParcelamento getTipo() {
        return this.tipo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public MotivoDesconto getMotivoDesconto() {
        return this.motivoDesconto;
    }

    public FormaCorrecao getFormaCorrecao() {
        return this.formaCorrecao;
    }

    public Ato getAto() {
        return this.ato;
    }

    public Long getNumeroParcela() {
        return this.numeroParcela;
    }

    public Long getNumeroParcelaRequerimento() {
        return this.numeroParcelaRequerimento;
    }

    public Boolean getNumeroParcelaSituacao() {
        return this.numeroParcelaSituacao;
    }

    public Boolean getNumeroParcelaValor() {
        return this.numeroParcelaValor;
    }

    public Boolean getCobraExpediente() {
        return this.cobraExpediente;
    }

    public Long getEntidade() {
        return this.entidade;
    }

    public Long getExercicio() {
        return this.exercicio;
    }

    public Tributo getTaxaExpediente() {
        return this.taxaExpediente;
    }

    public BigDecimal getValorExpediente() {
        return this.valorExpediente;
    }

    public BigDecimal getValorMinimoParcela() {
        return this.valorMinimoParcela;
    }

    public ParcelamentoTipoDesconto getTipoDesconto() {
        return this.tipoDesconto;
    }

    public FormaCobrancaJurosParcelamento getTipoJurosFinanciamento() {
        return this.tipoJurosFinanciamento;
    }

    public String getFiltroDebito() {
        return this.filtroDebito;
    }

    public Boolean getJurosFinanciamentoSobreCorrecao() {
        return this.jurosFinanciamentoSobreCorrecao;
    }

    public Boolean getJurosFinanciamentoSobreJuros() {
        return this.jurosFinanciamentoSobreJuros;
    }

    public Boolean getJurosFinanciamentoSobreMulta() {
        return this.jurosFinanciamentoSobreMulta;
    }

    public Boolean getJurosFinanciamentoSobrePrincipal() {
        return this.jurosFinanciamentoSobrePrincipal;
    }

    public Tributo getTributoJurosFinanciamento() {
        return this.tributoJurosFinanciamento;
    }

    public BigDecimal getTaxaUnicaJurosFinanciamento() {
        return this.taxaUnicaJurosFinanciamento;
    }

    public Boolean getEntradaValorIgual() {
        return this.entradaValorIgual;
    }

    public Relatorio getRelatorio() {
        return this.relatorio;
    }

    public Long getSequenciaEmissaoRelatorio() {
        return this.sequenciaEmissaoRelatorio;
    }

    public BigDecimal getDescontoPrincipal() {
        return this.descontoPrincipal;
    }

    public BigDecimal getDescontoJuros() {
        return this.descontoJuros;
    }

    public BigDecimal getDescontoMulta() {
        return this.descontoMulta;
    }

    public BigDecimal getDescontoCorrecao() {
        return this.descontoCorrecao;
    }

    public Boolean getDesativado() {
        return this.desativado;
    }

    public Tributo getTributoDesconto() {
        return this.tributoDesconto;
    }

    public Tributo getTributoDescontoJuros() {
        return this.tributoDescontoJuros;
    }

    public Tributo getTributoDescontoMulta() {
        return this.tributoDescontoMulta;
    }

    public Tributo getTributoDescontoCorrecao() {
        return this.tributoDescontoCorrecao;
    }

    public Relatorio getRelatorioBoleto() {
        return this.relatorioBoleto;
    }

    public Boolean getParcelamentoIndividual() {
        return this.parcelamentoIndividual;
    }

    public BigDecimal getDescontoPagamVista() {
        return this.descontoPagamVista;
    }

    public MotivoDesconto getMotivoDescontoQuitacao() {
        return this.motivoDescontoQuitacao;
    }

    public Relatorio getRelatorioCarne() {
        return this.relatorioCarne;
    }

    public Relatorio getRelatorioSimulacao() {
        return this.relatorioSimulacao;
    }

    public Boolean getUtilizaSac() {
        return this.utilizaSac;
    }

    public MotivoDesconto getMotivoEstorno() {
        return this.motivoEstorno;
    }

    public Long getNumeroParcelasVencidas() {
        return this.numeroParcelasVencidas;
    }

    public FormaPagamento getFormaPagamento() {
        return this.formaPagamento;
    }

    public Boolean getUtilizaExercicioLogado() {
        return this.utilizaExercicioLogado;
    }

    public MotivoDesconto getMotivoDescontoFinanciamento() {
        return this.motivoDescontoFinanciamento;
    }

    public Boolean getBloqueioJudicial() {
        return this.bloqueioJudicial;
    }

    public SituacaoParcelamento getSituacao() {
        return this.situacao;
    }

    public ModeloBoleto getModeloBoleto() {
        return this.modeloBoleto;
    }

    public Long getDataVencimento() {
        return this.dataVencimento;
    }

    public List<ParamParcelamentoEntrada> getEntradas() {
        return this.entradas;
    }

    public List<ParamParcelamentoParcelaSituacao> getParcelasSituacao() {
        return this.parcelasSituacao;
    }

    public List<ParamParcelamentoParcelaPorValor> getParcelasPorValor() {
        return this.parcelasPorValor;
    }

    public List<ParamParcelamentoDescontoParcela> getDescontosPorParcela() {
        return this.descontosPorParcela;
    }

    public List<ParamParcelamentoDescontoDivida> getDescontosPorDivida() {
        return this.descontosPorDivida;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTipo(TipoParcelamento tipo) {
        this.tipo = tipo;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public void setMotivoDesconto(MotivoDesconto motivoDesconto) {
        this.motivoDesconto = motivoDesconto;
    }

    public void setFormaCorrecao(FormaCorrecao formaCorrecao) {
        this.formaCorrecao = formaCorrecao;
    }

    public void setAto(Ato ato) {
        this.ato = ato;
    }

    public void setNumeroParcela(Long numeroParcela) {
        this.numeroParcela = numeroParcela;
    }

    public void setNumeroParcelaRequerimento(Long numeroParcelaRequerimento) {
        this.numeroParcelaRequerimento = numeroParcelaRequerimento;
    }

    public void setNumeroParcelaSituacao(Boolean numeroParcelaSituacao) {
        this.numeroParcelaSituacao = numeroParcelaSituacao;
    }

    public void setNumeroParcelaValor(Boolean numeroParcelaValor) {
        this.numeroParcelaValor = numeroParcelaValor;
    }

    public void setCobraExpediente(Boolean cobraExpediente) {
        this.cobraExpediente = cobraExpediente;
    }

    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    public void setTaxaExpediente(Tributo taxaExpediente) {
        this.taxaExpediente = taxaExpediente;
    }

    public void setValorExpediente(BigDecimal valorExpediente) {
        this.valorExpediente = valorExpediente;
    }

    public void setValorMinimoParcela(BigDecimal valorMinimoParcela) {
        this.valorMinimoParcela = valorMinimoParcela;
    }

    public void setTipoDesconto(ParcelamentoTipoDesconto tipoDesconto) {
        this.tipoDesconto = tipoDesconto;
    }

    public void setTipoJurosFinanciamento(FormaCobrancaJurosParcelamento tipoJurosFinanciamento) {
        this.tipoJurosFinanciamento = tipoJurosFinanciamento;
    }

    public void setFiltroDebito(String filtroDebito) {
        this.filtroDebito = filtroDebito;
    }

    public void setJurosFinanciamentoSobreCorrecao(Boolean jurosFinanciamentoSobreCorrecao) {
        this.jurosFinanciamentoSobreCorrecao = jurosFinanciamentoSobreCorrecao;
    }

    public void setJurosFinanciamentoSobreJuros(Boolean jurosFinanciamentoSobreJuros) {
        this.jurosFinanciamentoSobreJuros = jurosFinanciamentoSobreJuros;
    }

    public void setJurosFinanciamentoSobreMulta(Boolean jurosFinanciamentoSobreMulta) {
        this.jurosFinanciamentoSobreMulta = jurosFinanciamentoSobreMulta;
    }

    public void setJurosFinanciamentoSobrePrincipal(Boolean jurosFinanciamentoSobrePrincipal) {
        this.jurosFinanciamentoSobrePrincipal = jurosFinanciamentoSobrePrincipal;
    }

    public void setTributoJurosFinanciamento(Tributo tributoJurosFinanciamento) {
        this.tributoJurosFinanciamento = tributoJurosFinanciamento;
    }

    public void setTaxaUnicaJurosFinanciamento(BigDecimal taxaUnicaJurosFinanciamento) {
        this.taxaUnicaJurosFinanciamento = taxaUnicaJurosFinanciamento;
    }

    public void setEntradaValorIgual(Boolean entradaValorIgual) {
        this.entradaValorIgual = entradaValorIgual;
    }

    public void setRelatorio(Relatorio relatorio) {
        this.relatorio = relatorio;
    }

    public void setSequenciaEmissaoRelatorio(Long sequenciaEmissaoRelatorio) {
        this.sequenciaEmissaoRelatorio = sequenciaEmissaoRelatorio;
    }

    public void setDescontoPrincipal(BigDecimal descontoPrincipal) {
        this.descontoPrincipal = descontoPrincipal;
    }

    public void setDescontoJuros(BigDecimal descontoJuros) {
        this.descontoJuros = descontoJuros;
    }

    public void setDescontoMulta(BigDecimal descontoMulta) {
        this.descontoMulta = descontoMulta;
    }

    public void setDescontoCorrecao(BigDecimal descontoCorrecao) {
        this.descontoCorrecao = descontoCorrecao;
    }

    public void setDesativado(Boolean desativado) {
        this.desativado = desativado;
    }

    public void setTributoDesconto(Tributo tributoDesconto) {
        this.tributoDesconto = tributoDesconto;
    }

    public void setTributoDescontoJuros(Tributo tributoDescontoJuros) {
        this.tributoDescontoJuros = tributoDescontoJuros;
    }

    public void setTributoDescontoMulta(Tributo tributoDescontoMulta) {
        this.tributoDescontoMulta = tributoDescontoMulta;
    }

    public void setTributoDescontoCorrecao(Tributo tributoDescontoCorrecao) {
        this.tributoDescontoCorrecao = tributoDescontoCorrecao;
    }

    public void setRelatorioBoleto(Relatorio relatorioBoleto) {
        this.relatorioBoleto = relatorioBoleto;
    }

    public void setParcelamentoIndividual(Boolean parcelamentoIndividual) {
        this.parcelamentoIndividual = parcelamentoIndividual;
    }

    public void setDescontoPagamVista(BigDecimal descontoPagamVista) {
        this.descontoPagamVista = descontoPagamVista;
    }

    public void setMotivoDescontoQuitacao(MotivoDesconto motivoDescontoQuitacao) {
        this.motivoDescontoQuitacao = motivoDescontoQuitacao;
    }

    public void setRelatorioCarne(Relatorio relatorioCarne) {
        this.relatorioCarne = relatorioCarne;
    }

    public void setRelatorioSimulacao(Relatorio relatorioSimulacao) {
        this.relatorioSimulacao = relatorioSimulacao;
    }

    public void setUtilizaSac(Boolean utilizaSac) {
        this.utilizaSac = utilizaSac;
    }

    public void setMotivoEstorno(MotivoDesconto motivoEstorno) {
        this.motivoEstorno = motivoEstorno;
    }

    public void setNumeroParcelasVencidas(Long numeroParcelasVencidas) {
        this.numeroParcelasVencidas = numeroParcelasVencidas;
    }

    public void setFormaPagamento(FormaPagamento formaPagamento) {
        this.formaPagamento = formaPagamento;
    }

    public void setUtilizaExercicioLogado(Boolean utilizaExercicioLogado) {
        this.utilizaExercicioLogado = utilizaExercicioLogado;
    }

    public void setMotivoDescontoFinanciamento(MotivoDesconto motivoDescontoFinanciamento) {
        this.motivoDescontoFinanciamento = motivoDescontoFinanciamento;
    }

    public void setBloqueioJudicial(Boolean bloqueioJudicial) {
        this.bloqueioJudicial = bloqueioJudicial;
    }

    public void setSituacao(SituacaoParcelamento situacao) {
        this.situacao = situacao;
    }

    public void setModeloBoleto(ModeloBoleto modeloBoleto) {
        this.modeloBoleto = modeloBoleto;
    }

    public void setDataVencimento(Long dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    public void setEntradas(List<ParamParcelamentoEntrada> entradas) {
        this.entradas = entradas;
    }

    public void setParcelasSituacao(List<ParamParcelamentoParcelaSituacao> parcelasSituacao) {
        this.parcelasSituacao = parcelasSituacao;
    }

    public void setParcelasPorValor(List<ParamParcelamentoParcelaPorValor> parcelasPorValor) {
        this.parcelasPorValor = parcelasPorValor;
    }

    public void setDescontosPorParcela(List<ParamParcelamentoDescontoParcela> descontosPorParcela) {
        this.descontosPorParcela = descontosPorParcela;
    }

    public void setDescontosPorDivida(List<ParamParcelamentoDescontoDivida> descontosPorDivida) {
        this.descontosPorDivida = descontosPorDivida;
    }

    public String toString() {
        return "ParamParcelamento(id=" + this.getId() + ", tipo=" + this.getTipo() + ", descricao=" + this.getDescricao() + ", exercicio=" + this.getExercicio() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParamParcelamento)) {
            return false;
        }
        ParamParcelamento other = (ParamParcelamento)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParamParcelamento;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

