/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.mobiliario;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.CategoriaMobiliario;
import br.com.elotech.tributos.domain.ClassificacaoMobiliario;
import br.com.elotech.tributos.domain.NaturezaJuridica;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.PessoaMobiliario;
import br.com.elotech.tributos.domain.RamoAtividade;
import br.com.elotech.tributos.domain.SituacaoMobiliario;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.mobiliario.BoletimMobiliario;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioAtividade;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioCnae;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioHorarioEspecial;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioListaServico;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioProfissional;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioRegimeFiscal;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioServico;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioSituacao;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioVeiculo;
import br.com.elotech.tributos.domain.mobiliario.ContratoSocial;
import br.com.elotech.tributos.dto.CadastroMobiliarioDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

@Entity
@Table(name="TRIBCADASTROMOBILIARIO")
@PrimaryKeyJoinColumn(name="TRIBCADASTROGERAL_IDKEY")
@DynamicInsert
@DynamicUpdate
public class CadastroMobiliario
extends CadastroGeral {
    @ManyToOne
    @JoinColumn
    private Pessoa pessoaEmpresa;
    @Column(length=20)
    @Caption(value="Registro Federal")
    private String registroFederal;
    @Column(length=20)
    @Caption(value="Junta Comercial")
    private String juntaComercial;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Inscri\u00e7\u00e3o Estadual")
    private Boolean inscricaoEstadual = Boolean.FALSE;
    @Column(length=10)
    @Caption(value="N\u00famero Registro")
    private String numeroRegistro;
    @Column(length=60)
    @Caption(value="Gerente")
    private String gerente;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Micro Empresa")
    private Boolean microEmpresa = Boolean.FALSE;
    @Caption(value="\u00c1rea Utilizada")
    private BigDecimal areaUtilizada = BigDecimal.ZERO;
    private LocalDate dataAbertura;
    private LocalDate dataValidadeAlvara;
    private LocalDate dataEncerramento;
    private LocalDate dataUltimaFiscalizacao;
    @ManyToOne
    private PessoaMobiliario pessoaMobiliario;
    @ManyToOne
    private CategoriaMobiliario categoriaMobiliario;
    @ManyToOne
    private ClassificacaoMobiliario classificacaoMobiliario;
    private LocalDate dataAlvara;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Super Simples")
    private Boolean superSimples = Boolean.FALSE;
    private Long superSimplesAnexo;
    private Long tipoCadastroImobiliario;
    private Long cadastroGeralImobiliario;
    private Long exercicioAlvara;
    private Long entidade;
    @Column(name="exercProcessoAbertura")
    private Long exercicioProcessoAbertura;
    private Long idProcessoAbertura;
    @Column(name="exercProcessoEncerramento")
    private Long exercicioProcessoEncerramento;
    private Long idProcessoEncerramento;
    private Long numeroAlvara;
    private Long qtdeFuncionario;
    private Long cmcResponsavel;
    @Column(length=4000)
    @Caption(value="Observa\u00e7\u00e3o alvar\u00e1")
    private String observacaoAlvara;
    @Caption(value="\u00c1rea Publicidade 1")
    private BigDecimal areaPublicidade1 = BigDecimal.ZERO;
    @Caption(value="\u00c1rea Publicidade 2")
    private BigDecimal areaPublicidade2 = BigDecimal.ZERO;
    private LocalDate dataAuditoriaInicio;
    private LocalDate dataAuditoriaFim;
    private LocalDate dataHomologacao;
    @ManyToOne
    private RamoAtividade ramoAtividade;
    @Caption(value="\u00c1rea Bombeiro")
    private BigDecimal areaBombeiro = BigDecimal.ZERO;
    private Long idNotificacaoFiscalizacao;
    @Column(length=3000)
    @Caption(value="Atividade Principal")
    private String atividadePrincipal;
    @Column(length=20)
    @Caption(value="Telefone")
    private String telefone;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Dispensa Nota Fiscal")
    private Boolean dispensaNotaFiscal = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Substitui\u00e7\u00e3o Tribut\u00e1ria")
    private Boolean substituicaoTributaria = Boolean.FALSE;
    private Long laudo;
    private Long exercicioLaudo;
    @ManyToOne
    @JoinColumn(name="idNaturezaJuridica", referencedColumnName="idNaturezaJuridica")
    private NaturezaJuridica naturezaJuridica;
    private Long idCadastroMobiliarioISS;
    @Transient
    private Long solicitacao;
    @Transient
    private Long exercicioSolicitacao;
    @Caption(value="\u00c1rea P\u00e1tio")
    private BigDecimal areaPatio = BigDecimal.ZERO;
    @Caption(value="\u00c1rea Contru\u00edda")
    private BigDecimal areaConstruida = BigDecimal.ZERO;
    private Long setorVistoria;
    private Long lotacaoVistoria;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROGERAL_IDKEY", updatable=false, nullable=false)
    @Caption(value="Situa\u00e7\u00f5es")
    private final List<CadastroMobiliarioSituacao> cadastroMobiliarioSituacoes = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROMOBILIARIO_IDKEY", updatable=false, nullable=false)
    @Caption(value="Atividades")
    private final List<CadastroMobiliarioAtividade> cadastroMobiliarioAtividades = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROMOBILIARIO_IDKEY", updatable=false, nullable=false)
    @Caption(value="Cnaes")
    private List<CadastroMobiliarioCnae> cadastroMobiliarioCnaes = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROMOBILIARIO_IDKEY", updatable=false, nullable=false)
    @Caption(value="Hor\u00e1rios Especiais")
    private final List<CadastroMobiliarioHorarioEspecial> cadastroMobiliarioHorariosEspeciais = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROMOBILIARIO_IDKEY", updatable=false, nullable=false)
    @Caption(value="Listas Servi\u00e7o")
    private final List<CadastroMobiliarioListaServico> cadastroMobiliarioListasServicos = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROMOBILIARIO_IDKEY", updatable=false, nullable=false)
    @Caption(value="Servi\u00e7os")
    private final List<CadastroMobiliarioServico> cadastroMobiliarioServicos = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROMOBILIARIO_IDKEY", updatable=false, nullable=false)
    @Caption(value="Ve\u00edculos")
    private final List<CadastroMobiliarioVeiculo> cadastroMobiliarioVeiculos = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROGERAL_IDKEY", updatable=false, nullable=false)
    @Caption(value="Regimes Fiscais")
    private final List<CadastroMobiliarioRegimeFiscal> cadastroMobiliarioRegimesFiscais = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROMOBILIARIO_IDKEY", updatable=false, nullable=false)
    @Caption(value="Boletim Imobili\u00e1rio")
    private final List<BoletimMobiliario> boletinsMobiliario = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROMOBILIARIO_IDKEY", updatable=false, nullable=false)
    @Caption(value="Profissionais")
    private final List<CadastroMobiliarioProfissional> cadastroMobiliarioProfissionais = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROMOBILIARIO_IDKEY", updatable=false, nullable=false)
    @Caption(value="Contratos Social")
    private final List<ContratoSocial> contratosSocial = new ArrayList();

    public Pessoa getPessoaEmpresa() {
        return this.pessoaEmpresa;
    }

    public String getRegistroFederal() {
        return this.registroFederal;
    }

    public String getJuntaComercial() {
        return this.juntaComercial;
    }

    public Boolean getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    public String getNumeroRegistro() {
        return this.numeroRegistro;
    }

    public String getGerente() {
        return this.gerente;
    }

    public Boolean getMicroEmpresa() {
        return this.microEmpresa;
    }

    public BigDecimal getAreaUtilizada() {
        return this.areaUtilizada;
    }

    public LocalDate getDataAbertura() {
        return this.dataAbertura;
    }

    public LocalDate getDataValidadeAlvara() {
        return this.dataValidadeAlvara;
    }

    public LocalDate getDataEncerramento() {
        return this.dataEncerramento;
    }

    public LocalDate getDataUltimaFiscalizacao() {
        return this.dataUltimaFiscalizacao;
    }

    public PessoaMobiliario getPessoaMobiliario() {
        return this.pessoaMobiliario;
    }

    public CategoriaMobiliario getCategoriaMobiliario() {
        return this.categoriaMobiliario;
    }

    public ClassificacaoMobiliario getClassificacaoMobiliario() {
        return this.classificacaoMobiliario;
    }

    public LocalDate getDataAlvara() {
        return this.dataAlvara;
    }

    public Boolean getSuperSimples() {
        return this.superSimples;
    }

    public Long getSuperSimplesAnexo() {
        return this.superSimplesAnexo;
    }

    public Long getExercicioAlvara() {
        return this.exercicioAlvara;
    }

    public Long getEntidade() {
        return this.entidade;
    }

    public Long getExercicioProcessoAbertura() {
        return this.exercicioProcessoAbertura;
    }

    public Long getIdProcessoAbertura() {
        return this.idProcessoAbertura;
    }

    public Long getExercicioProcessoEncerramento() {
        return this.exercicioProcessoEncerramento;
    }

    public Long getIdProcessoEncerramento() {
        return this.idProcessoEncerramento;
    }

    public Long getNumeroAlvara() {
        return this.numeroAlvara;
    }

    public Long getQtdeFuncionario() {
        return this.qtdeFuncionario;
    }

    public Long getCmcResponsavel() {
        return this.cmcResponsavel;
    }

    public String getObservacaoAlvara() {
        return this.observacaoAlvara;
    }

    public BigDecimal getAreaPublicidade1() {
        return this.areaPublicidade1;
    }

    public BigDecimal getAreaPublicidade2() {
        return this.areaPublicidade2;
    }

    public LocalDate getDataAuditoriaInicio() {
        return this.dataAuditoriaInicio;
    }

    public LocalDate getDataAuditoriaFim() {
        return this.dataAuditoriaFim;
    }

    public LocalDate getDataHomologacao() {
        return this.dataHomologacao;
    }

    public RamoAtividade getRamoAtividade() {
        return this.ramoAtividade;
    }

    public BigDecimal getAreaBombeiro() {
        return this.areaBombeiro;
    }

    public Long getIdNotificacaoFiscalizacao() {
        return this.idNotificacaoFiscalizacao;
    }

    public String getAtividadePrincipal() {
        return this.atividadePrincipal;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public Boolean getDispensaNotaFiscal() {
        return this.dispensaNotaFiscal;
    }

    public Boolean getSubstituicaoTributaria() {
        return this.substituicaoTributaria;
    }

    public Long getLaudo() {
        return this.laudo;
    }

    public Long getExercicioLaudo() {
        return this.exercicioLaudo;
    }

    public NaturezaJuridica getNaturezaJuridica() {
        return this.naturezaJuridica;
    }

    public Long getIdCadastroMobiliarioISS() {
        return this.idCadastroMobiliarioISS;
    }

    public Long getSolicitacao() {
        return this.solicitacao;
    }

    public Long getExercicioSolicitacao() {
        return this.exercicioSolicitacao;
    }

    public BigDecimal getAreaPatio() {
        return this.areaPatio;
    }

    public BigDecimal getAreaConstruida() {
        return this.areaConstruida;
    }

    public Long getSetorVistoria() {
        return this.setorVistoria;
    }

    public Long getLotacaoVistoria() {
        return this.lotacaoVistoria;
    }

    public void setPessoaEmpresa(Pessoa pessoaEmpresa) {
        this.pessoaEmpresa = pessoaEmpresa;
    }

    public void setRegistroFederal(String registroFederal) {
        this.registroFederal = registroFederal;
    }

    public void setJuntaComercial(String juntaComercial) {
        this.juntaComercial = juntaComercial;
    }

    public void setInscricaoEstadual(Boolean inscricaoEstadual) {
        this.inscricaoEstadual = inscricaoEstadual;
    }

    public void setNumeroRegistro(String numeroRegistro) {
        this.numeroRegistro = numeroRegistro;
    }

    public void setGerente(String gerente) {
        this.gerente = gerente;
    }

    public void setMicroEmpresa(Boolean microEmpresa) {
        this.microEmpresa = microEmpresa;
    }

    public void setAreaUtilizada(BigDecimal areaUtilizada) {
        this.areaUtilizada = areaUtilizada;
    }

    public void setDataAbertura(LocalDate dataAbertura) {
        this.dataAbertura = dataAbertura;
    }

    public void setDataValidadeAlvara(LocalDate dataValidadeAlvara) {
        this.dataValidadeAlvara = dataValidadeAlvara;
    }

    public void setDataEncerramento(LocalDate dataEncerramento) {
        this.dataEncerramento = dataEncerramento;
    }

    public void setDataUltimaFiscalizacao(LocalDate dataUltimaFiscalizacao) {
        this.dataUltimaFiscalizacao = dataUltimaFiscalizacao;
    }

    public void setPessoaMobiliario(PessoaMobiliario pessoaMobiliario) {
        this.pessoaMobiliario = pessoaMobiliario;
    }

    public void setCategoriaMobiliario(CategoriaMobiliario categoriaMobiliario) {
        this.categoriaMobiliario = categoriaMobiliario;
    }

    public void setClassificacaoMobiliario(ClassificacaoMobiliario classificacaoMobiliario) {
        this.classificacaoMobiliario = classificacaoMobiliario;
    }

    public void setDataAlvara(LocalDate dataAlvara) {
        this.dataAlvara = dataAlvara;
    }

    public void setSuperSimples(Boolean superSimples) {
        this.superSimples = superSimples;
    }

    public void setSuperSimplesAnexo(Long superSimplesAnexo) {
        this.superSimplesAnexo = superSimplesAnexo;
    }

    public void setExercicioAlvara(Long exercicioAlvara) {
        this.exercicioAlvara = exercicioAlvara;
    }

    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    public void setExercicioProcessoAbertura(Long exercicioProcessoAbertura) {
        this.exercicioProcessoAbertura = exercicioProcessoAbertura;
    }

    public void setIdProcessoAbertura(Long idProcessoAbertura) {
        this.idProcessoAbertura = idProcessoAbertura;
    }

    public void setExercicioProcessoEncerramento(Long exercicioProcessoEncerramento) {
        this.exercicioProcessoEncerramento = exercicioProcessoEncerramento;
    }

    public void setIdProcessoEncerramento(Long idProcessoEncerramento) {
        this.idProcessoEncerramento = idProcessoEncerramento;
    }

    public void setNumeroAlvara(Long numeroAlvara) {
        this.numeroAlvara = numeroAlvara;
    }

    public void setQtdeFuncionario(Long qtdeFuncionario) {
        this.qtdeFuncionario = qtdeFuncionario;
    }

    public void setCmcResponsavel(Long cmcResponsavel) {
        this.cmcResponsavel = cmcResponsavel;
    }

    public void setObservacaoAlvara(String observacaoAlvara) {
        this.observacaoAlvara = observacaoAlvara;
    }

    public void setAreaPublicidade1(BigDecimal areaPublicidade1) {
        this.areaPublicidade1 = areaPublicidade1;
    }

    public void setAreaPublicidade2(BigDecimal areaPublicidade2) {
        this.areaPublicidade2 = areaPublicidade2;
    }

    public void setDataAuditoriaInicio(LocalDate dataAuditoriaInicio) {
        this.dataAuditoriaInicio = dataAuditoriaInicio;
    }

    public void setDataAuditoriaFim(LocalDate dataAuditoriaFim) {
        this.dataAuditoriaFim = dataAuditoriaFim;
    }

    public void setDataHomologacao(LocalDate dataHomologacao) {
        this.dataHomologacao = dataHomologacao;
    }

    public void setRamoAtividade(RamoAtividade ramoAtividade) {
        this.ramoAtividade = ramoAtividade;
    }

    public void setAreaBombeiro(BigDecimal areaBombeiro) {
        this.areaBombeiro = areaBombeiro;
    }

    public void setIdNotificacaoFiscalizacao(Long idNotificacaoFiscalizacao) {
        this.idNotificacaoFiscalizacao = idNotificacaoFiscalizacao;
    }

    public void setAtividadePrincipal(String atividadePrincipal) {
        this.atividadePrincipal = atividadePrincipal;
    }

    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    public void setDispensaNotaFiscal(Boolean dispensaNotaFiscal) {
        this.dispensaNotaFiscal = dispensaNotaFiscal;
    }

    public void setSubstituicaoTributaria(Boolean substituicaoTributaria) {
        this.substituicaoTributaria = substituicaoTributaria;
    }

    public void setLaudo(Long laudo) {
        this.laudo = laudo;
    }

    public void setExercicioLaudo(Long exercicioLaudo) {
        this.exercicioLaudo = exercicioLaudo;
    }

    public void setNaturezaJuridica(NaturezaJuridica naturezaJuridica) {
        this.naturezaJuridica = naturezaJuridica;
    }

    public void setIdCadastroMobiliarioISS(Long idCadastroMobiliarioISS) {
        this.idCadastroMobiliarioISS = idCadastroMobiliarioISS;
    }

    public void setSolicitacao(Long solicitacao) {
        this.solicitacao = solicitacao;
    }

    public void setExercicioSolicitacao(Long exercicioSolicitacao) {
        this.exercicioSolicitacao = exercicioSolicitacao;
    }

    public void setAreaPatio(BigDecimal areaPatio) {
        this.areaPatio = areaPatio;
    }

    public void setSetorVistoria(Long setorVistoria) {
        this.setorVistoria = setorVistoria;
    }

    public void setLotacaoVistoria(Long lotacaoVistoria) {
        this.lotacaoVistoria = lotacaoVistoria;
    }

    public Long getTipoCadastroImobiliario() {
        return this.tipoCadastroImobiliario;
    }

    public Long getCadastroGeralImobiliario() {
        return this.cadastroGeralImobiliario;
    }

    public void setTipoCadastroImobiliario(Long tipoCadastroImobiliario) {
        this.tipoCadastroImobiliario = tipoCadastroImobiliario;
    }

    public void setCadastroGeralImobiliario(Long cadastroGeralImobiliario) {
        this.cadastroGeralImobiliario = cadastroGeralImobiliario;
    }

    public void setAreaConstruida(BigDecimal areaConstruida) {
        this.areaConstruida = areaConstruida;
    }

    public List<CadastroMobiliarioSituacao> getCadastroMobiliarioSituacoes() {
        return this.cadastroMobiliarioSituacoes;
    }

    public SituacaoMobiliario getSituacaoAtual() {
        for (CadastroMobiliarioSituacao situacao : this.cadastroMobiliarioSituacoes) {
            if (!situacao.getAtual().booleanValue()) continue;
            return situacao.getSituacaoMobiliario();
        }
        return null;
    }

    public List<CadastroMobiliarioAtividade> getCadastroMobiliarioAtividades() {
        return this.cadastroMobiliarioAtividades;
    }

    public List<CadastroMobiliarioCnae> getCadastroMobiliarioCnaes() {
        return this.cadastroMobiliarioCnaes;
    }

    public List<CadastroMobiliarioHorarioEspecial> getCadastroMobiliarioHorariosEspeciais() {
        return this.cadastroMobiliarioHorariosEspeciais;
    }

    public List<CadastroMobiliarioListaServico> getCadastroMobiliarioListasServicos() {
        return this.cadastroMobiliarioListasServicos;
    }

    public List<CadastroMobiliarioServico> getCadastroMobiliarioServicos() {
        return this.cadastroMobiliarioServicos;
    }

    public List<CadastroMobiliarioVeiculo> getCadastroMobiliarioVeiculos() {
        return this.cadastroMobiliarioVeiculos;
    }

    public List<CadastroMobiliarioRegimeFiscal> getCadastroMobiliarioRegimesFiscais() {
        return this.cadastroMobiliarioRegimesFiscais;
    }

    public List<BoletimMobiliario> getBoletinsMobiliario() {
        return this.boletinsMobiliario;
    }

    public List<CadastroMobiliarioProfissional> getCadastroMobiliarioProfissionais() {
        return this.cadastroMobiliarioProfissionais;
    }

    public List<ContratoSocial> getContratosSocial() {
        return this.contratosSocial;
    }

    public void setCadastroMobiliarioCnaes(List<CadastroMobiliarioCnae> cadastroMobiliarioCnaes) {
        this.cadastroMobiliarioCnaes = cadastroMobiliarioCnaes;
    }

    public CadastroMobiliario set(CadastroMobiliarioDTO dto) {
        Optional.ofNullable(TipoCadastro.fromValue((Long)dto.getTipoCadastro())).ifPresent(arg_0 -> ((CadastroMobiliario)this).setTipoCadastro(arg_0));
        Optional.ofNullable(dto.getCadastroGeral()).ifPresent(arg_0 -> ((CadastroMobiliario)this).setCadastroGeral(arg_0));
        Optional.ofNullable(dto.getDataAbertura()).ifPresent(arg_0 -> this.setDataAbertura(arg_0));
        Optional.ofNullable(dto.getDataEncerramento()).ifPresent(arg_0 -> this.setDataEncerramento(arg_0));
        Optional.ofNullable(dto.getCmcResponsavel()).ifPresent(arg_0 -> this.setCmcResponsavel(arg_0));
        Optional.ofNullable(dto.getDataValidadeAlvara()).ifPresent(arg_0 -> this.setDataValidadeAlvara(arg_0));
        Optional.ofNullable(dto.getDataUltimaFiscalizacao()).ifPresent(arg_0 -> this.setDataUltimaFiscalizacao(arg_0));
        Optional.ofNullable(dto.getAreaUtilizada()).ifPresent(arg_0 -> this.setAreaUtilizada(arg_0));
        Optional.ofNullable(dto.getAreaConstruida()).ifPresent(arg_0 -> this.setAreaConstruida(arg_0));
        Optional.ofNullable(dto.getExercicioAlvara()).ifPresent(arg_0 -> this.setExercicioAlvara(arg_0));
        Optional.ofNullable(dto.getExercicioProcessoAbertura()).ifPresent(arg_0 -> this.setExercicioProcessoAbertura(arg_0));
        Optional.ofNullable(dto.getExercicioProcessoEncerramento()).ifPresent(arg_0 -> this.setExercicioProcessoEncerramento(arg_0));
        Optional.ofNullable(dto.getNumeroAlvara()).ifPresent(arg_0 -> this.setNumeroAlvara(arg_0));
        Optional.ofNullable(dto.getNumeroRegistro()).ifPresent(arg_0 -> this.setNumeroRegistro(arg_0));
        return this;
    }

    public String toString() {
        return "CadastroMobiliario(super=" + super.toString() + ", pessoaEmpresa=" + this.getPessoaEmpresa() + ", registroFederal=" + this.getRegistroFederal() + ", juntaComercial=" + this.getJuntaComercial() + ", inscricaoEstadual=" + this.getInscricaoEstadual() + ", numeroRegistro=" + this.getNumeroRegistro() + ", gerente=" + this.getGerente() + ", microEmpresa=" + this.getMicroEmpresa() + ", areaUtilizada=" + this.getAreaUtilizada() + ", dataAbertura=" + this.getDataAbertura() + ", dataValidadeAlvara=" + this.getDataValidadeAlvara() + ", dataEncerramento=" + this.getDataEncerramento() + ", dataUltimaFiscalizacao=" + this.getDataUltimaFiscalizacao() + ", pessoaMobiliario=" + this.getPessoaMobiliario() + ", categoriaMobiliario=" + this.getCategoriaMobiliario() + ", classificacaoMobiliario=" + this.getClassificacaoMobiliario() + ", dataAlvara=" + this.getDataAlvara() + ", superSimples=" + this.getSuperSimples() + ", superSimplesAnexo=" + this.getSuperSimplesAnexo() + ", tipoCadastroImobiliario=" + this.getTipoCadastroImobiliario() + ", cadastroGeralImobiliario=" + this.getCadastroGeralImobiliario() + ", exercicioAlvara=" + this.getExercicioAlvara() + ", entidade=" + this.getEntidade() + ", exercicioProcessoAbertura=" + this.getExercicioProcessoAbertura() + ", idProcessoAbertura=" + this.getIdProcessoAbertura() + ", exercicioProcessoEncerramento=" + this.getExercicioProcessoEncerramento() + ", idProcessoEncerramento=" + this.getIdProcessoEncerramento() + ", numeroAlvara=" + this.getNumeroAlvara() + ", qtdeFuncionario=" + this.getQtdeFuncionario() + ", cmcResponsavel=" + this.getCmcResponsavel() + ", observacaoAlvara=" + this.getObservacaoAlvara() + ", areaPublicidade1=" + this.getAreaPublicidade1() + ", areaPublicidade2=" + this.getAreaPublicidade2() + ", dataAuditoriaInicio=" + this.getDataAuditoriaInicio() + ", dataAuditoriaFim=" + this.getDataAuditoriaFim() + ", dataHomologacao=" + this.getDataHomologacao() + ", ramoAtividade=" + this.getRamoAtividade() + ", areaBombeiro=" + this.getAreaBombeiro() + ", idNotificacaoFiscalizacao=" + this.getIdNotificacaoFiscalizacao() + ", atividadePrincipal=" + this.getAtividadePrincipal() + ", telefone=" + this.getTelefone() + ", dispensaNotaFiscal=" + this.getDispensaNotaFiscal() + ", substituicaoTributaria=" + this.getSubstituicaoTributaria() + ", laudo=" + this.getLaudo() + ", exercicioLaudo=" + this.getExercicioLaudo() + ", naturezaJuridica=" + this.getNaturezaJuridica() + ", idCadastroMobiliarioISS=" + this.getIdCadastroMobiliarioISS() + ", solicitacao=" + this.getSolicitacao() + ", exercicioSolicitacao=" + this.getExercicioSolicitacao() + ", areaPatio=" + this.getAreaPatio() + ", areaConstruida=" + this.getAreaConstruida() + ", setorVistoria=" + this.getSetorVistoria() + ", lotacaoVistoria=" + this.getLotacaoVistoria() + ", cadastroMobiliarioSituacoes=" + this.getCadastroMobiliarioSituacoes() + ", cadastroMobiliarioAtividades=" + this.getCadastroMobiliarioAtividades() + ", cadastroMobiliarioCnaes=" + this.getCadastroMobiliarioCnaes() + ", cadastroMobiliarioHorariosEspeciais=" + this.getCadastroMobiliarioHorariosEspeciais() + ", cadastroMobiliarioListasServicos=" + this.getCadastroMobiliarioListasServicos() + ", cadastroMobiliarioServicos=" + this.getCadastroMobiliarioServicos() + ", cadastroMobiliarioVeiculos=" + this.getCadastroMobiliarioVeiculos() + ", cadastroMobiliarioRegimesFiscais=" + this.getCadastroMobiliarioRegimesFiscais() + ", boletinsMobiliario=" + this.getBoletinsMobiliario() + ", cadastroMobiliarioProfissionais=" + this.getCadastroMobiliarioProfissionais() + ", contratosSocial=" + this.getContratosSocial() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroMobiliario)) {
            return false;
        }
        CadastroMobiliario other = (CadastroMobiliario)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Pessoa this$pessoaEmpresa = this.getPessoaEmpresa();
        Pessoa other$pessoaEmpresa = other.getPessoaEmpresa();
        if (this$pessoaEmpresa == null ? other$pessoaEmpresa != null : !this$pessoaEmpresa.equals(other$pessoaEmpresa)) {
            return false;
        }
        String this$registroFederal = this.getRegistroFederal();
        String other$registroFederal = other.getRegistroFederal();
        if (this$registroFederal == null ? other$registroFederal != null : !this$registroFederal.equals(other$registroFederal)) {
            return false;
        }
        String this$juntaComercial = this.getJuntaComercial();
        String other$juntaComercial = other.getJuntaComercial();
        if (this$juntaComercial == null ? other$juntaComercial != null : !this$juntaComercial.equals(other$juntaComercial)) {
            return false;
        }
        Boolean this$inscricaoEstadual = this.getInscricaoEstadual();
        Boolean other$inscricaoEstadual = other.getInscricaoEstadual();
        if (this$inscricaoEstadual == null ? other$inscricaoEstadual != null : !((Object)this$inscricaoEstadual).equals(other$inscricaoEstadual)) {
            return false;
        }
        String this$numeroRegistro = this.getNumeroRegistro();
        String other$numeroRegistro = other.getNumeroRegistro();
        if (this$numeroRegistro == null ? other$numeroRegistro != null : !this$numeroRegistro.equals(other$numeroRegistro)) {
            return false;
        }
        String this$gerente = this.getGerente();
        String other$gerente = other.getGerente();
        if (this$gerente == null ? other$gerente != null : !this$gerente.equals(other$gerente)) {
            return false;
        }
        Boolean this$microEmpresa = this.getMicroEmpresa();
        Boolean other$microEmpresa = other.getMicroEmpresa();
        if (this$microEmpresa == null ? other$microEmpresa != null : !((Object)this$microEmpresa).equals(other$microEmpresa)) {
            return false;
        }
        BigDecimal this$areaUtilizada = this.getAreaUtilizada();
        BigDecimal other$areaUtilizada = other.getAreaUtilizada();
        if (this$areaUtilizada == null ? other$areaUtilizada != null : !((Object)this$areaUtilizada).equals(other$areaUtilizada)) {
            return false;
        }
        LocalDate this$dataAbertura = this.getDataAbertura();
        LocalDate other$dataAbertura = other.getDataAbertura();
        if (this$dataAbertura == null ? other$dataAbertura != null : !((Object)this$dataAbertura).equals(other$dataAbertura)) {
            return false;
        }
        LocalDate this$dataValidadeAlvara = this.getDataValidadeAlvara();
        LocalDate other$dataValidadeAlvara = other.getDataValidadeAlvara();
        if (this$dataValidadeAlvara == null ? other$dataValidadeAlvara != null : !((Object)this$dataValidadeAlvara).equals(other$dataValidadeAlvara)) {
            return false;
        }
        LocalDate this$dataEncerramento = this.getDataEncerramento();
        LocalDate other$dataEncerramento = other.getDataEncerramento();
        if (this$dataEncerramento == null ? other$dataEncerramento != null : !((Object)this$dataEncerramento).equals(other$dataEncerramento)) {
            return false;
        }
        LocalDate this$dataUltimaFiscalizacao = this.getDataUltimaFiscalizacao();
        LocalDate other$dataUltimaFiscalizacao = other.getDataUltimaFiscalizacao();
        if (this$dataUltimaFiscalizacao == null ? other$dataUltimaFiscalizacao != null : !((Object)this$dataUltimaFiscalizacao).equals(other$dataUltimaFiscalizacao)) {
            return false;
        }
        PessoaMobiliario this$pessoaMobiliario = this.getPessoaMobiliario();
        PessoaMobiliario other$pessoaMobiliario = other.getPessoaMobiliario();
        if (this$pessoaMobiliario == null ? other$pessoaMobiliario != null : !this$pessoaMobiliario.equals(other$pessoaMobiliario)) {
            return false;
        }
        CategoriaMobiliario this$categoriaMobiliario = this.getCategoriaMobiliario();
        CategoriaMobiliario other$categoriaMobiliario = other.getCategoriaMobiliario();
        if (this$categoriaMobiliario == null ? other$categoriaMobiliario != null : !this$categoriaMobiliario.equals(other$categoriaMobiliario)) {
            return false;
        }
        ClassificacaoMobiliario this$classificacaoMobiliario = this.getClassificacaoMobiliario();
        ClassificacaoMobiliario other$classificacaoMobiliario = other.getClassificacaoMobiliario();
        if (this$classificacaoMobiliario == null ? other$classificacaoMobiliario != null : !this$classificacaoMobiliario.equals(other$classificacaoMobiliario)) {
            return false;
        }
        LocalDate this$dataAlvara = this.getDataAlvara();
        LocalDate other$dataAlvara = other.getDataAlvara();
        if (this$dataAlvara == null ? other$dataAlvara != null : !((Object)this$dataAlvara).equals(other$dataAlvara)) {
            return false;
        }
        Boolean this$superSimples = this.getSuperSimples();
        Boolean other$superSimples = other.getSuperSimples();
        if (this$superSimples == null ? other$superSimples != null : !((Object)this$superSimples).equals(other$superSimples)) {
            return false;
        }
        Long this$superSimplesAnexo = this.getSuperSimplesAnexo();
        Long other$superSimplesAnexo = other.getSuperSimplesAnexo();
        if (this$superSimplesAnexo == null ? other$superSimplesAnexo != null : !((Object)this$superSimplesAnexo).equals(other$superSimplesAnexo)) {
            return false;
        }
        Long this$tipoCadastroImobiliario = this.getTipoCadastroImobiliario();
        Long other$tipoCadastroImobiliario = other.getTipoCadastroImobiliario();
        if (this$tipoCadastroImobiliario == null ? other$tipoCadastroImobiliario != null : !((Object)this$tipoCadastroImobiliario).equals(other$tipoCadastroImobiliario)) {
            return false;
        }
        Long this$cadastroGeralImobiliario = this.getCadastroGeralImobiliario();
        Long other$cadastroGeralImobiliario = other.getCadastroGeralImobiliario();
        if (this$cadastroGeralImobiliario == null ? other$cadastroGeralImobiliario != null : !((Object)this$cadastroGeralImobiliario).equals(other$cadastroGeralImobiliario)) {
            return false;
        }
        Long this$exercicioAlvara = this.getExercicioAlvara();
        Long other$exercicioAlvara = other.getExercicioAlvara();
        if (this$exercicioAlvara == null ? other$exercicioAlvara != null : !((Object)this$exercicioAlvara).equals(other$exercicioAlvara)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicioProcessoAbertura = this.getExercicioProcessoAbertura();
        Long other$exercicioProcessoAbertura = other.getExercicioProcessoAbertura();
        if (this$exercicioProcessoAbertura == null ? other$exercicioProcessoAbertura != null : !((Object)this$exercicioProcessoAbertura).equals(other$exercicioProcessoAbertura)) {
            return false;
        }
        Long this$idProcessoAbertura = this.getIdProcessoAbertura();
        Long other$idProcessoAbertura = other.getIdProcessoAbertura();
        if (this$idProcessoAbertura == null ? other$idProcessoAbertura != null : !((Object)this$idProcessoAbertura).equals(other$idProcessoAbertura)) {
            return false;
        }
        Long this$exercicioProcessoEncerramento = this.getExercicioProcessoEncerramento();
        Long other$exercicioProcessoEncerramento = other.getExercicioProcessoEncerramento();
        if (this$exercicioProcessoEncerramento == null ? other$exercicioProcessoEncerramento != null : !((Object)this$exercicioProcessoEncerramento).equals(other$exercicioProcessoEncerramento)) {
            return false;
        }
        Long this$idProcessoEncerramento = this.getIdProcessoEncerramento();
        Long other$idProcessoEncerramento = other.getIdProcessoEncerramento();
        if (this$idProcessoEncerramento == null ? other$idProcessoEncerramento != null : !((Object)this$idProcessoEncerramento).equals(other$idProcessoEncerramento)) {
            return false;
        }
        Long this$numeroAlvara = this.getNumeroAlvara();
        Long other$numeroAlvara = other.getNumeroAlvara();
        if (this$numeroAlvara == null ? other$numeroAlvara != null : !((Object)this$numeroAlvara).equals(other$numeroAlvara)) {
            return false;
        }
        Long this$qtdeFuncionario = this.getQtdeFuncionario();
        Long other$qtdeFuncionario = other.getQtdeFuncionario();
        if (this$qtdeFuncionario == null ? other$qtdeFuncionario != null : !((Object)this$qtdeFuncionario).equals(other$qtdeFuncionario)) {
            return false;
        }
        Long this$cmcResponsavel = this.getCmcResponsavel();
        Long other$cmcResponsavel = other.getCmcResponsavel();
        if (this$cmcResponsavel == null ? other$cmcResponsavel != null : !((Object)this$cmcResponsavel).equals(other$cmcResponsavel)) {
            return false;
        }
        String this$observacaoAlvara = this.getObservacaoAlvara();
        String other$observacaoAlvara = other.getObservacaoAlvara();
        if (this$observacaoAlvara == null ? other$observacaoAlvara != null : !this$observacaoAlvara.equals(other$observacaoAlvara)) {
            return false;
        }
        BigDecimal this$areaPublicidade1 = this.getAreaPublicidade1();
        BigDecimal other$areaPublicidade1 = other.getAreaPublicidade1();
        if (this$areaPublicidade1 == null ? other$areaPublicidade1 != null : !((Object)this$areaPublicidade1).equals(other$areaPublicidade1)) {
            return false;
        }
        BigDecimal this$areaPublicidade2 = this.getAreaPublicidade2();
        BigDecimal other$areaPublicidade2 = other.getAreaPublicidade2();
        if (this$areaPublicidade2 == null ? other$areaPublicidade2 != null : !((Object)this$areaPublicidade2).equals(other$areaPublicidade2)) {
            return false;
        }
        LocalDate this$dataAuditoriaInicio = this.getDataAuditoriaInicio();
        LocalDate other$dataAuditoriaInicio = other.getDataAuditoriaInicio();
        if (this$dataAuditoriaInicio == null ? other$dataAuditoriaInicio != null : !((Object)this$dataAuditoriaInicio).equals(other$dataAuditoriaInicio)) {
            return false;
        }
        LocalDate this$dataAuditoriaFim = this.getDataAuditoriaFim();
        LocalDate other$dataAuditoriaFim = other.getDataAuditoriaFim();
        if (this$dataAuditoriaFim == null ? other$dataAuditoriaFim != null : !((Object)this$dataAuditoriaFim).equals(other$dataAuditoriaFim)) {
            return false;
        }
        LocalDate this$dataHomologacao = this.getDataHomologacao();
        LocalDate other$dataHomologacao = other.getDataHomologacao();
        if (this$dataHomologacao == null ? other$dataHomologacao != null : !((Object)this$dataHomologacao).equals(other$dataHomologacao)) {
            return false;
        }
        RamoAtividade this$ramoAtividade = this.getRamoAtividade();
        RamoAtividade other$ramoAtividade = other.getRamoAtividade();
        if (this$ramoAtividade == null ? other$ramoAtividade != null : !this$ramoAtividade.equals(other$ramoAtividade)) {
            return false;
        }
        BigDecimal this$areaBombeiro = this.getAreaBombeiro();
        BigDecimal other$areaBombeiro = other.getAreaBombeiro();
        if (this$areaBombeiro == null ? other$areaBombeiro != null : !((Object)this$areaBombeiro).equals(other$areaBombeiro)) {
            return false;
        }
        Long this$idNotificacaoFiscalizacao = this.getIdNotificacaoFiscalizacao();
        Long other$idNotificacaoFiscalizacao = other.getIdNotificacaoFiscalizacao();
        if (this$idNotificacaoFiscalizacao == null ? other$idNotificacaoFiscalizacao != null : !((Object)this$idNotificacaoFiscalizacao).equals(other$idNotificacaoFiscalizacao)) {
            return false;
        }
        String this$atividadePrincipal = this.getAtividadePrincipal();
        String other$atividadePrincipal = other.getAtividadePrincipal();
        if (this$atividadePrincipal == null ? other$atividadePrincipal != null : !this$atividadePrincipal.equals(other$atividadePrincipal)) {
            return false;
        }
        String this$telefone = this.getTelefone();
        String other$telefone = other.getTelefone();
        if (this$telefone == null ? other$telefone != null : !this$telefone.equals(other$telefone)) {
            return false;
        }
        Boolean this$dispensaNotaFiscal = this.getDispensaNotaFiscal();
        Boolean other$dispensaNotaFiscal = other.getDispensaNotaFiscal();
        if (this$dispensaNotaFiscal == null ? other$dispensaNotaFiscal != null : !((Object)this$dispensaNotaFiscal).equals(other$dispensaNotaFiscal)) {
            return false;
        }
        Boolean this$substituicaoTributaria = this.getSubstituicaoTributaria();
        Boolean other$substituicaoTributaria = other.getSubstituicaoTributaria();
        if (this$substituicaoTributaria == null ? other$substituicaoTributaria != null : !((Object)this$substituicaoTributaria).equals(other$substituicaoTributaria)) {
            return false;
        }
        Long this$laudo = this.getLaudo();
        Long other$laudo = other.getLaudo();
        if (this$laudo == null ? other$laudo != null : !((Object)this$laudo).equals(other$laudo)) {
            return false;
        }
        Long this$exercicioLaudo = this.getExercicioLaudo();
        Long other$exercicioLaudo = other.getExercicioLaudo();
        if (this$exercicioLaudo == null ? other$exercicioLaudo != null : !((Object)this$exercicioLaudo).equals(other$exercicioLaudo)) {
            return false;
        }
        NaturezaJuridica this$naturezaJuridica = this.getNaturezaJuridica();
        NaturezaJuridica other$naturezaJuridica = other.getNaturezaJuridica();
        if (this$naturezaJuridica == null ? other$naturezaJuridica != null : !this$naturezaJuridica.equals(other$naturezaJuridica)) {
            return false;
        }
        Long this$idCadastroMobiliarioISS = this.getIdCadastroMobiliarioISS();
        Long other$idCadastroMobiliarioISS = other.getIdCadastroMobiliarioISS();
        if (this$idCadastroMobiliarioISS == null ? other$idCadastroMobiliarioISS != null : !((Object)this$idCadastroMobiliarioISS).equals(other$idCadastroMobiliarioISS)) {
            return false;
        }
        Long this$solicitacao = this.getSolicitacao();
        Long other$solicitacao = other.getSolicitacao();
        if (this$solicitacao == null ? other$solicitacao != null : !((Object)this$solicitacao).equals(other$solicitacao)) {
            return false;
        }
        Long this$exercicioSolicitacao = this.getExercicioSolicitacao();
        Long other$exercicioSolicitacao = other.getExercicioSolicitacao();
        if (this$exercicioSolicitacao == null ? other$exercicioSolicitacao != null : !((Object)this$exercicioSolicitacao).equals(other$exercicioSolicitacao)) {
            return false;
        }
        BigDecimal this$areaPatio = this.getAreaPatio();
        BigDecimal other$areaPatio = other.getAreaPatio();
        if (this$areaPatio == null ? other$areaPatio != null : !((Object)this$areaPatio).equals(other$areaPatio)) {
            return false;
        }
        BigDecimal this$areaConstruida = this.getAreaConstruida();
        BigDecimal other$areaConstruida = other.getAreaConstruida();
        if (this$areaConstruida == null ? other$areaConstruida != null : !((Object)this$areaConstruida).equals(other$areaConstruida)) {
            return false;
        }
        Long this$setorVistoria = this.getSetorVistoria();
        Long other$setorVistoria = other.getSetorVistoria();
        if (this$setorVistoria == null ? other$setorVistoria != null : !((Object)this$setorVistoria).equals(other$setorVistoria)) {
            return false;
        }
        Long this$lotacaoVistoria = this.getLotacaoVistoria();
        Long other$lotacaoVistoria = other.getLotacaoVistoria();
        if (this$lotacaoVistoria == null ? other$lotacaoVistoria != null : !((Object)this$lotacaoVistoria).equals(other$lotacaoVistoria)) {
            return false;
        }
        List this$cadastroMobiliarioSituacoes = this.getCadastroMobiliarioSituacoes();
        List other$cadastroMobiliarioSituacoes = other.getCadastroMobiliarioSituacoes();
        if (this$cadastroMobiliarioSituacoes == null ? other$cadastroMobiliarioSituacoes != null : !((Object)this$cadastroMobiliarioSituacoes).equals(other$cadastroMobiliarioSituacoes)) {
            return false;
        }
        List this$cadastroMobiliarioAtividades = this.getCadastroMobiliarioAtividades();
        List other$cadastroMobiliarioAtividades = other.getCadastroMobiliarioAtividades();
        if (this$cadastroMobiliarioAtividades == null ? other$cadastroMobiliarioAtividades != null : !((Object)this$cadastroMobiliarioAtividades).equals(other$cadastroMobiliarioAtividades)) {
            return false;
        }
        List this$cadastroMobiliarioCnaes = this.getCadastroMobiliarioCnaes();
        List other$cadastroMobiliarioCnaes = other.getCadastroMobiliarioCnaes();
        if (this$cadastroMobiliarioCnaes == null ? other$cadastroMobiliarioCnaes != null : !((Object)this$cadastroMobiliarioCnaes).equals(other$cadastroMobiliarioCnaes)) {
            return false;
        }
        List this$cadastroMobiliarioHorariosEspeciais = this.getCadastroMobiliarioHorariosEspeciais();
        List other$cadastroMobiliarioHorariosEspeciais = other.getCadastroMobiliarioHorariosEspeciais();
        if (this$cadastroMobiliarioHorariosEspeciais == null ? other$cadastroMobiliarioHorariosEspeciais != null : !((Object)this$cadastroMobiliarioHorariosEspeciais).equals(other$cadastroMobiliarioHorariosEspeciais)) {
            return false;
        }
        List this$cadastroMobiliarioListasServicos = this.getCadastroMobiliarioListasServicos();
        List other$cadastroMobiliarioListasServicos = other.getCadastroMobiliarioListasServicos();
        if (this$cadastroMobiliarioListasServicos == null ? other$cadastroMobiliarioListasServicos != null : !((Object)this$cadastroMobiliarioListasServicos).equals(other$cadastroMobiliarioListasServicos)) {
            return false;
        }
        List this$cadastroMobiliarioServicos = this.getCadastroMobiliarioServicos();
        List other$cadastroMobiliarioServicos = other.getCadastroMobiliarioServicos();
        if (this$cadastroMobiliarioServicos == null ? other$cadastroMobiliarioServicos != null : !((Object)this$cadastroMobiliarioServicos).equals(other$cadastroMobiliarioServicos)) {
            return false;
        }
        List this$cadastroMobiliarioVeiculos = this.getCadastroMobiliarioVeiculos();
        List other$cadastroMobiliarioVeiculos = other.getCadastroMobiliarioVeiculos();
        if (this$cadastroMobiliarioVeiculos == null ? other$cadastroMobiliarioVeiculos != null : !((Object)this$cadastroMobiliarioVeiculos).equals(other$cadastroMobiliarioVeiculos)) {
            return false;
        }
        List this$cadastroMobiliarioRegimesFiscais = this.getCadastroMobiliarioRegimesFiscais();
        List other$cadastroMobiliarioRegimesFiscais = other.getCadastroMobiliarioRegimesFiscais();
        if (this$cadastroMobiliarioRegimesFiscais == null ? other$cadastroMobiliarioRegimesFiscais != null : !((Object)this$cadastroMobiliarioRegimesFiscais).equals(other$cadastroMobiliarioRegimesFiscais)) {
            return false;
        }
        List this$boletinsMobiliario = this.getBoletinsMobiliario();
        List other$boletinsMobiliario = other.getBoletinsMobiliario();
        if (this$boletinsMobiliario == null ? other$boletinsMobiliario != null : !((Object)this$boletinsMobiliario).equals(other$boletinsMobiliario)) {
            return false;
        }
        List this$cadastroMobiliarioProfissionais = this.getCadastroMobiliarioProfissionais();
        List other$cadastroMobiliarioProfissionais = other.getCadastroMobiliarioProfissionais();
        if (this$cadastroMobiliarioProfissionais == null ? other$cadastroMobiliarioProfissionais != null : !((Object)this$cadastroMobiliarioProfissionais).equals(other$cadastroMobiliarioProfissionais)) {
            return false;
        }
        List this$contratosSocial = this.getContratosSocial();
        List other$contratosSocial = other.getContratosSocial();
        return !(this$contratosSocial == null ? other$contratosSocial != null : !((Object)this$contratosSocial).equals(other$contratosSocial));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CadastroMobiliario;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Pessoa $pessoaEmpresa = this.getPessoaEmpresa();
        result = result * 59 + ($pessoaEmpresa == null ? 43 : $pessoaEmpresa.hashCode());
        String $registroFederal = this.getRegistroFederal();
        result = result * 59 + ($registroFederal == null ? 43 : $registroFederal.hashCode());
        String $juntaComercial = this.getJuntaComercial();
        result = result * 59 + ($juntaComercial == null ? 43 : $juntaComercial.hashCode());
        Boolean $inscricaoEstadual = this.getInscricaoEstadual();
        result = result * 59 + ($inscricaoEstadual == null ? 43 : ((Object)$inscricaoEstadual).hashCode());
        String $numeroRegistro = this.getNumeroRegistro();
        result = result * 59 + ($numeroRegistro == null ? 43 : $numeroRegistro.hashCode());
        String $gerente = this.getGerente();
        result = result * 59 + ($gerente == null ? 43 : $gerente.hashCode());
        Boolean $microEmpresa = this.getMicroEmpresa();
        result = result * 59 + ($microEmpresa == null ? 43 : ((Object)$microEmpresa).hashCode());
        BigDecimal $areaUtilizada = this.getAreaUtilizada();
        result = result * 59 + ($areaUtilizada == null ? 43 : ((Object)$areaUtilizada).hashCode());
        LocalDate $dataAbertura = this.getDataAbertura();
        result = result * 59 + ($dataAbertura == null ? 43 : ((Object)$dataAbertura).hashCode());
        LocalDate $dataValidadeAlvara = this.getDataValidadeAlvara();
        result = result * 59 + ($dataValidadeAlvara == null ? 43 : ((Object)$dataValidadeAlvara).hashCode());
        LocalDate $dataEncerramento = this.getDataEncerramento();
        result = result * 59 + ($dataEncerramento == null ? 43 : ((Object)$dataEncerramento).hashCode());
        LocalDate $dataUltimaFiscalizacao = this.getDataUltimaFiscalizacao();
        result = result * 59 + ($dataUltimaFiscalizacao == null ? 43 : ((Object)$dataUltimaFiscalizacao).hashCode());
        PessoaMobiliario $pessoaMobiliario = this.getPessoaMobiliario();
        result = result * 59 + ($pessoaMobiliario == null ? 43 : $pessoaMobiliario.hashCode());
        CategoriaMobiliario $categoriaMobiliario = this.getCategoriaMobiliario();
        result = result * 59 + ($categoriaMobiliario == null ? 43 : $categoriaMobiliario.hashCode());
        ClassificacaoMobiliario $classificacaoMobiliario = this.getClassificacaoMobiliario();
        result = result * 59 + ($classificacaoMobiliario == null ? 43 : $classificacaoMobiliario.hashCode());
        LocalDate $dataAlvara = this.getDataAlvara();
        result = result * 59 + ($dataAlvara == null ? 43 : ((Object)$dataAlvara).hashCode());
        Boolean $superSimples = this.getSuperSimples();
        result = result * 59 + ($superSimples == null ? 43 : ((Object)$superSimples).hashCode());
        Long $superSimplesAnexo = this.getSuperSimplesAnexo();
        result = result * 59 + ($superSimplesAnexo == null ? 43 : ((Object)$superSimplesAnexo).hashCode());
        Long $tipoCadastroImobiliario = this.getTipoCadastroImobiliario();
        result = result * 59 + ($tipoCadastroImobiliario == null ? 43 : ((Object)$tipoCadastroImobiliario).hashCode());
        Long $cadastroGeralImobiliario = this.getCadastroGeralImobiliario();
        result = result * 59 + ($cadastroGeralImobiliario == null ? 43 : ((Object)$cadastroGeralImobiliario).hashCode());
        Long $exercicioAlvara = this.getExercicioAlvara();
        result = result * 59 + ($exercicioAlvara == null ? 43 : ((Object)$exercicioAlvara).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicioProcessoAbertura = this.getExercicioProcessoAbertura();
        result = result * 59 + ($exercicioProcessoAbertura == null ? 43 : ((Object)$exercicioProcessoAbertura).hashCode());
        Long $idProcessoAbertura = this.getIdProcessoAbertura();
        result = result * 59 + ($idProcessoAbertura == null ? 43 : ((Object)$idProcessoAbertura).hashCode());
        Long $exercicioProcessoEncerramento = this.getExercicioProcessoEncerramento();
        result = result * 59 + ($exercicioProcessoEncerramento == null ? 43 : ((Object)$exercicioProcessoEncerramento).hashCode());
        Long $idProcessoEncerramento = this.getIdProcessoEncerramento();
        result = result * 59 + ($idProcessoEncerramento == null ? 43 : ((Object)$idProcessoEncerramento).hashCode());
        Long $numeroAlvara = this.getNumeroAlvara();
        result = result * 59 + ($numeroAlvara == null ? 43 : ((Object)$numeroAlvara).hashCode());
        Long $qtdeFuncionario = this.getQtdeFuncionario();
        result = result * 59 + ($qtdeFuncionario == null ? 43 : ((Object)$qtdeFuncionario).hashCode());
        Long $cmcResponsavel = this.getCmcResponsavel();
        result = result * 59 + ($cmcResponsavel == null ? 43 : ((Object)$cmcResponsavel).hashCode());
        String $observacaoAlvara = this.getObservacaoAlvara();
        result = result * 59 + ($observacaoAlvara == null ? 43 : $observacaoAlvara.hashCode());
        BigDecimal $areaPublicidade1 = this.getAreaPublicidade1();
        result = result * 59 + ($areaPublicidade1 == null ? 43 : ((Object)$areaPublicidade1).hashCode());
        BigDecimal $areaPublicidade2 = this.getAreaPublicidade2();
        result = result * 59 + ($areaPublicidade2 == null ? 43 : ((Object)$areaPublicidade2).hashCode());
        LocalDate $dataAuditoriaInicio = this.getDataAuditoriaInicio();
        result = result * 59 + ($dataAuditoriaInicio == null ? 43 : ((Object)$dataAuditoriaInicio).hashCode());
        LocalDate $dataAuditoriaFim = this.getDataAuditoriaFim();
        result = result * 59 + ($dataAuditoriaFim == null ? 43 : ((Object)$dataAuditoriaFim).hashCode());
        LocalDate $dataHomologacao = this.getDataHomologacao();
        result = result * 59 + ($dataHomologacao == null ? 43 : ((Object)$dataHomologacao).hashCode());
        RamoAtividade $ramoAtividade = this.getRamoAtividade();
        result = result * 59 + ($ramoAtividade == null ? 43 : $ramoAtividade.hashCode());
        BigDecimal $areaBombeiro = this.getAreaBombeiro();
        result = result * 59 + ($areaBombeiro == null ? 43 : ((Object)$areaBombeiro).hashCode());
        Long $idNotificacaoFiscalizacao = this.getIdNotificacaoFiscalizacao();
        result = result * 59 + ($idNotificacaoFiscalizacao == null ? 43 : ((Object)$idNotificacaoFiscalizacao).hashCode());
        String $atividadePrincipal = this.getAtividadePrincipal();
        result = result * 59 + ($atividadePrincipal == null ? 43 : $atividadePrincipal.hashCode());
        String $telefone = this.getTelefone();
        result = result * 59 + ($telefone == null ? 43 : $telefone.hashCode());
        Boolean $dispensaNotaFiscal = this.getDispensaNotaFiscal();
        result = result * 59 + ($dispensaNotaFiscal == null ? 43 : ((Object)$dispensaNotaFiscal).hashCode());
        Boolean $substituicaoTributaria = this.getSubstituicaoTributaria();
        result = result * 59 + ($substituicaoTributaria == null ? 43 : ((Object)$substituicaoTributaria).hashCode());
        Long $laudo = this.getLaudo();
        result = result * 59 + ($laudo == null ? 43 : ((Object)$laudo).hashCode());
        Long $exercicioLaudo = this.getExercicioLaudo();
        result = result * 59 + ($exercicioLaudo == null ? 43 : ((Object)$exercicioLaudo).hashCode());
        NaturezaJuridica $naturezaJuridica = this.getNaturezaJuridica();
        result = result * 59 + ($naturezaJuridica == null ? 43 : $naturezaJuridica.hashCode());
        Long $idCadastroMobiliarioISS = this.getIdCadastroMobiliarioISS();
        result = result * 59 + ($idCadastroMobiliarioISS == null ? 43 : ((Object)$idCadastroMobiliarioISS).hashCode());
        Long $solicitacao = this.getSolicitacao();
        result = result * 59 + ($solicitacao == null ? 43 : ((Object)$solicitacao).hashCode());
        Long $exercicioSolicitacao = this.getExercicioSolicitacao();
        result = result * 59 + ($exercicioSolicitacao == null ? 43 : ((Object)$exercicioSolicitacao).hashCode());
        BigDecimal $areaPatio = this.getAreaPatio();
        result = result * 59 + ($areaPatio == null ? 43 : ((Object)$areaPatio).hashCode());
        BigDecimal $areaConstruida = this.getAreaConstruida();
        result = result * 59 + ($areaConstruida == null ? 43 : ((Object)$areaConstruida).hashCode());
        Long $setorVistoria = this.getSetorVistoria();
        result = result * 59 + ($setorVistoria == null ? 43 : ((Object)$setorVistoria).hashCode());
        Long $lotacaoVistoria = this.getLotacaoVistoria();
        result = result * 59 + ($lotacaoVistoria == null ? 43 : ((Object)$lotacaoVistoria).hashCode());
        List $cadastroMobiliarioSituacoes = this.getCadastroMobiliarioSituacoes();
        result = result * 59 + ($cadastroMobiliarioSituacoes == null ? 43 : ((Object)$cadastroMobiliarioSituacoes).hashCode());
        List $cadastroMobiliarioAtividades = this.getCadastroMobiliarioAtividades();
        result = result * 59 + ($cadastroMobiliarioAtividades == null ? 43 : ((Object)$cadastroMobiliarioAtividades).hashCode());
        List $cadastroMobiliarioCnaes = this.getCadastroMobiliarioCnaes();
        result = result * 59 + ($cadastroMobiliarioCnaes == null ? 43 : ((Object)$cadastroMobiliarioCnaes).hashCode());
        List $cadastroMobiliarioHorariosEspeciais = this.getCadastroMobiliarioHorariosEspeciais();
        result = result * 59 + ($cadastroMobiliarioHorariosEspeciais == null ? 43 : ((Object)$cadastroMobiliarioHorariosEspeciais).hashCode());
        List $cadastroMobiliarioListasServicos = this.getCadastroMobiliarioListasServicos();
        result = result * 59 + ($cadastroMobiliarioListasServicos == null ? 43 : ((Object)$cadastroMobiliarioListasServicos).hashCode());
        List $cadastroMobiliarioServicos = this.getCadastroMobiliarioServicos();
        result = result * 59 + ($cadastroMobiliarioServicos == null ? 43 : ((Object)$cadastroMobiliarioServicos).hashCode());
        List $cadastroMobiliarioVeiculos = this.getCadastroMobiliarioVeiculos();
        result = result * 59 + ($cadastroMobiliarioVeiculos == null ? 43 : ((Object)$cadastroMobiliarioVeiculos).hashCode());
        List $cadastroMobiliarioRegimesFiscais = this.getCadastroMobiliarioRegimesFiscais();
        result = result * 59 + ($cadastroMobiliarioRegimesFiscais == null ? 43 : ((Object)$cadastroMobiliarioRegimesFiscais).hashCode());
        List $boletinsMobiliario = this.getBoletinsMobiliario();
        result = result * 59 + ($boletinsMobiliario == null ? 43 : ((Object)$boletinsMobiliario).hashCode());
        List $cadastroMobiliarioProfissionais = this.getCadastroMobiliarioProfissionais();
        result = result * 59 + ($cadastroMobiliarioProfissionais == null ? 43 : ((Object)$cadastroMobiliarioProfissionais).hashCode());
        List $contratosSocial = this.getContratosSocial();
        result = result * 59 + ($contratosSocial == null ? 43 : ((Object)$contratosSocial).hashCode());
        return result;
    }
}

